/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ArgsWrapper;
import cpw.mods.fml.relauncher.FMLRelauncher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public abstract class MinecraftServer
implements aa,
Runnable,
lg {
    public static Logger a = Logger.getLogger("Minecraft");
    private static MinecraftServer l = null;
    private final aij m;
    private final le n = new le("server", this);
    private final File o;
    private final List p = new ArrayList();
    private final z q;
    public final kh b = new kh();
    private String r;
    private int s = -1;
    public in[] c;
    private gm t;
    private boolean u = true;
    private boolean v = false;
    private int w = 0;
    public String d;
    public int e;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private String C;
    private int D;
    private long E;
    private long F;
    private long G;
    private long H;
    public final long[] f = new long[100];
    public final long[] g = new long[100];
    public final long[] h = new long[100];
    public final long[] i = new long[100];
    public final long[] j = new long[100];
    public Hashtable worldTickTimes = new Hashtable();
    private KeyPair I;
    private String J;
    private String K;
    @SideOnly(value=Side.CLIENT)
    private String L;
    private boolean M;
    private boolean N;
    private boolean O;
    private String P = "";
    private boolean Q = false;
    private long R;
    private String S;
    private boolean T;

    public MinecraftServer(File par1File) {
        l = this;
        this.o = par1File;
        this.q = new hi();
        this.m = new ahs(par1File);
        this.al();
    }

    private void al() {
        ajw.a.a(up.l, new fs(this));
        ajw.a.a(up.aP, new gc(this));
        ajw.a.a(up.aD, new gd(this));
        ajw.a.a(up.bD, new ge(this));
        ajw.a.a(up.bs, new gf(this));
        ajw.a.a(up.bC, new gh(this));
        ajw.a.a(up.bU, new gi(this));
        ajw.a.a(up.bE, new gj(this));
        gk var1 = new gk(this);
        ajw.a.a(up.az, var1);
        ajw.a.a(up.aN, var1);
        ajw.a.a(up.aO, var1);
        ajw.a.a(up.aE, new ft(this));
        fu var2 = new fu(this);
        ajw.a.a(up.ay, var2);
        ajw.a.a(up.ax, var2);
        ajw.a.a(up.aw, new fv(this));
    }

    protected abstract boolean c() throws IOException;

    protected void b(String par1Str) {
        if (this.N().b(par1Str)) {
            a.info("Converting map!");
            this.c("menu.convertingLevel");
            this.N().a(par1Str, new fw(this));
        }
    }

    protected synchronized void c(String par1Str) {
        this.S = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public synchronized String d() {
        return this.S;
    }

    protected void a(String par1Str, String par2Str, long par3, yn par5WorldType, String par6Str) {
        yk var8;
        this.b(par1Str);
        this.c("menu.loadingLevel");
        aih var7 = this.m.a(par1Str, true);
        ahx var9 = var7.d();
        if (var9 == null) {
            var8 = new yk(par3, this.g(), this.f(), this.i(), par5WorldType);
            var8.a(par6Str);
        } else {
            var8 = new yk(var9);
        }
        if (this.N) {
            var8.a();
        }
        in overWorld = this.M() ? new if(this, var7, par2Str, 0, this.b) : new in(this, var7, par2Str, 0, var8, this.b);
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n2 = integerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int dim = integerArray[i2];
            in world = dim == 0 ? overWorld : new ih(this, var7, par2Str, dim, var8, overWorld, this.b);
            world.a(new ij(this, world));
            if (!this.I()) {
                world.K().a(this.g());
            }
            this.t.a(this.c);
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        }
        this.t.a(new in[]{overWorld});
        this.c(this.h());
        this.e();
    }

    protected void e() {
        int var5 = 0;
        this.c("menu.generatingTerrain");
        int var6 = 0;
        a.info("Preparing start region for level " + var6);
        in var7 = this.c[var6];
        s var8 = var7.H();
        long var9 = System.currentTimeMillis();
        for (int var11 = -192; var11 <= 192 && this.m(); var11 += 16) {
            for (int var12 = -192; var12 <= 192 && this.m(); var12 += 16) {
                long var13 = System.currentTimeMillis();
                if (var13 - var9 > 1000L) {
                    this.a_("Preparing spawn area", var5 * 100 / 625);
                    var9 = var13;
                }
                ++var5;
                var7.b.c(var8.a + var11 >> 4, var8.c + var12 >> 4);
            }
        }
        this.j();
    }

    public abstract boolean f();

    public abstract yl g();

    public abstract int h();

    public abstract boolean i();

    protected void a_(String par1Str, int par2) {
        this.d = par1Str;
        this.e = par2;
        a.info(par1Str + ": " + par2 + "%");
    }

    protected void j() {
        this.d = null;
        this.e = 0;
    }

    protected void a(boolean par1) {
        if (!this.O) {
            for (in var5 : this.c) {
                if (var5 == null) continue;
                if (!par1) {
                    a.info("Saving chunks for level '" + var5.K().k() + "'/" + var5.u.l());
                }
                try {
                    var5.a(true, (kj)null);
                }
                catch (yh var7) {
                    a.warning(var7.getMessage());
                }
            }
        }
    }

    public void k() {
        if (!this.O) {
            in[] tmp;
            a.info("Stopping server");
            if (this.ae() != null) {
                this.ae().a();
            }
            if (this.t != null) {
                a.info("Saving players");
                this.t.g();
                this.t.r();
            }
            a.info("Saving worlds");
            this.a(false);
            for (int var1 = 0; var1 < this.c.length; ++var1) {
                in var2 = this.c[var1];
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(var2));
                var2.m();
            }
            for (in world : tmp = this.c) {
                DimensionManager.setWorld(world.u.h, null);
            }
            if (this.n != null && this.n.d()) {
                this.n.e();
            }
        }
    }

    public String l() {
        return this.r;
    }

    public void d(String par1Str) {
        this.r = par1Str;
    }

    public boolean m() {
        return this.u;
    }

    public void n() {
        this.u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long var50;
        long var1;
        try {
            if (!this.c()) {
                this.a((a)null);
                return;
            }
            FMLCommonHandler.instance().handleServerStarted();
            var1 = System.currentTimeMillis();
            FMLCommonHandler.instance().onWorldLoadTick(this.c);
            var50 = 0L;
        }
        catch (Throwable var48) {
            if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                return;
            }
            var48.printStackTrace();
            a.log(Level.SEVERE, "Encountered an unexpected exception " + var48.getClass().getSimpleName(), var48);
            a var2 = null;
            var2 = var48 instanceof t ? this.b(((t)var48).a()) : this.b(new a("Exception in server tick loop", var48));
            File var3 = new File(new File(this.o(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (var2.a(var3)) {
                a.severe("This crash report has been saved to: " + var3.getAbsolutePath());
            } else {
                a.severe("We were unable to save this crash report to disk.");
            }
            this.a(var2);
            return;
        }
        finally {
            try {
                if (FMLCommonHandler.instance().shouldServerBeKilledQuietly()) {
                    return;
                }
                this.k();
                this.v = true;
            }
            catch (Throwable var46) {
                var46.printStackTrace();
            }
            finally {
                FMLCommonHandler.instance().handleServerStopped();
                this.p();
            }
        }
        while (true) {
            if (!this.u) {
                FMLCommonHandler.instance().handleServerStopping();
                return;
            }
            long var5 = System.currentTimeMillis();
            long var7 = var5 - var1;
            if (var7 > 2000L && var1 - this.R >= 15000L) {
                a.warning("Can't keep up! Did the system time change, or is the server overloaded?");
                var7 = 2000L;
                this.R = var1;
            }
            if (var7 < 0L) {
                a.warning("Time ran backwards! Did the system time change?");
                var7 = 0L;
            }
            var50 += var7;
            var1 = var5;
            if (this.c[0].e()) {
                this.q();
                var50 = 0L;
            } else {
                while (var50 > 50L) {
                    var50 -= 50L;
                    this.q();
                }
            }
            Thread.sleep(1L);
            this.Q = true;
        }
    }

    protected File o() {
        return new File(".");
    }

    protected void a(a par1CrashReport) {
    }

    protected void p() {
    }

    public void q() {
        FMLCommonHandler.instance().rescheduleTicks(Side.SERVER);
        long var1 = System.nanoTime();
        aoe.a().a();
        FMLCommonHandler.instance().onPreServerTick();
        ++this.w;
        if (this.T) {
            this.T = false;
            this.b.a = true;
            this.b.a();
        }
        this.b.a("root");
        this.r();
        if (this.w % 900 == 0) {
            this.b.a("save");
            this.t.g();
            this.a(true);
            this.b.b();
        }
        this.b.a("tallying");
        this.j[this.w % 100] = System.nanoTime() - var1;
        this.f[this.w % 100] = ef.p - this.E;
        this.E = ef.p;
        this.g[this.w % 100] = ef.q - this.F;
        this.F = ef.q;
        this.h[this.w % 100] = ef.n - this.G;
        this.G = ef.n;
        this.i[this.w % 100] = ef.o - this.H;
        this.H = ef.o;
        this.b.b();
        this.b.a("snooper");
        if (!this.n.d() && this.w > 100) {
            this.n.a();
        }
        if (this.w % 6000 == 0) {
            this.n.b();
        }
        this.b.b();
        this.b.b();
        FMLCommonHandler.instance().onPostServerTick();
    }

    public void r() {
        this.b.a("levels");
        Integer[] ids = DimensionManager.getIDs(this.w % 200 == 0);
        for (int x2 = 0; x2 < ids.length; ++x2) {
            int id = ids[x2];
            long var2 = System.nanoTime();
            if (id == 0 || this.s()) {
                in var4 = DimensionManager.getWorld(id);
                this.b.a(var4.K().k());
                this.b.a("pools");
                var4.S().a();
                this.b.b();
                if (this.w % 20 == 0) {
                    this.b.a("timeSync");
                    this.t.a(new fa(var4.F(), var4.G()), var4.u.h);
                    this.b.b();
                }
                this.b.a("tick");
                FMLCommonHandler.instance().onPreWorldTick(var4);
                try {
                    var4.b();
                }
                catch (Throwable var8) {
                    a var6 = a.a(var8, "Exception ticking world");
                    var4.a(var6);
                    throw new t(var6);
                }
                try {
                    var4.h();
                }
                catch (Throwable var7) {
                    a var6 = a.a(var7, "Exception ticking world entities");
                    var4.a(var6);
                    throw new t(var6);
                }
                FMLCommonHandler.instance().onPostWorldTick(var4);
                this.b.b();
                this.b.a("tracker");
                var4.p().a();
                this.b.b();
                this.b.b();
            }
            ((long[])this.worldTickTimes.get((Object)Integer.valueOf((int)id)))[this.w % 100] = System.nanoTime() - var2;
        }
        this.b.c("dim_unloading");
        DimensionManager.unloadWorlds(this.worldTickTimes);
        this.b.c("connection");
        this.ae().b();
        this.b.c("players");
        this.t.b();
        this.b.c("tickables");
        for (int var1 = 0; var1 < this.p.size(); ++var1) {
            ((gp)this.p.get(var1)).a();
        }
        this.b.b();
    }

    public boolean s() {
        return true;
    }

    public void t() {
        new fy(this, "Server thread").start();
    }

    public File e(String par1Str) {
        return new File(this.o(), par1Str);
    }

    public void f(String par1Str) {
        a.info(par1Str);
    }

    public void g(String par1Str) {
        a.warning(par1Str);
    }

    public in a(int par1) {
        in ret = DimensionManager.getWorld(par1);
        if (ret == null) {
            DimensionManager.initDimension(par1);
            ret = DimensionManager.getWorld(par1);
        }
        return ret;
    }

    @SideOnly(value=Side.SERVER)
    public void a(gp par1IUpdatePlayerListBox) {
        this.p.add(par1IUpdatePlayerListBox);
    }

    public String u() {
        return this.r;
    }

    public int v() {
        return this.s;
    }

    public String w() {
        return this.C;
    }

    public String x() {
        return "1.4.7";
    }

    public int y() {
        return this.t.k();
    }

    public int z() {
        return this.t.l();
    }

    public String[] A() {
        return this.t.d();
    }

    public String B() {
        return "";
    }

    public String h(String par1Str) {
        iz.a.c();
        this.q.a(iz.a, par1Str);
        return iz.a.d();
    }

    public boolean C() {
        return false;
    }

    public void i(String par1Str) {
        a.log(Level.SEVERE, par1Str);
    }

    public void j(String par1Str) {
        if (this.C()) {
            a.log(Level.INFO, par1Str);
        }
    }

    public String getServerModName() {
        return "forge,fml";
    }

    public a b(a par1CrashReport) {
        par1CrashReport.g().a("Profiler Position", new fz(this));
        if (this.c != null && this.c.length > 0 && this.c[0] != null) {
            par1CrashReport.g().a("Vec3 Pool Size", new ga(this));
        }
        if (this.t != null) {
            par1CrashReport.g().a("Player Count", new gb(this));
        }
        return par1CrashReport;
    }

    public List a(aa par1ICommandSender, String par2Str) {
        ArrayList<String> var3 = new ArrayList<String>();
        if (par2Str.startsWith("/")) {
            boolean var10 = !(par2Str = par2Str.substring(1)).contains(" ");
            List var11 = this.q.b(par1ICommandSender, par2Str);
            if (var11 != null) {
                for (String var13 : var11) {
                    if (var10) {
                        var3.add("/" + var13);
                        continue;
                    }
                    var3.add(var13);
                }
            }
            return var3;
        }
        String[] var4 = par2Str.split(" ", -1);
        String var5 = var4[var4.length - 1];
        for (String var9 : this.t.d()) {
            if (!w.a(var5, var9)) continue;
            var3.add(var9);
        }
        return var3;
    }

    public static MinecraftServer D() {
        return l;
    }

    @Override
    public String c_() {
        return "Server";
    }

    @Override
    public void a(String par1Str) {
        a.info(km.a(par1Str));
    }

    @Override
    public boolean a(int par1, String par2Str) {
        return true;
    }

    @Override
    public String a(String par1Str, Object ... par2ArrayOfObj) {
        return bn.a().a(par1Str, par2ArrayOfObj);
    }

    public z E() {
        return this.q;
    }

    public KeyPair F() {
        return this.I;
    }

    public int G() {
        return this.s;
    }

    public void b(int par1) {
        this.s = par1;
    }

    public String H() {
        return this.J;
    }

    public void k(String par1Str) {
        this.J = par1Str;
    }

    public boolean I() {
        return this.J != null;
    }

    public String J() {
        return this.K;
    }

    public void l(String par1Str) {
        this.K = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public void m(String par1Str) {
        this.L = par1Str;
    }

    @SideOnly(value=Side.CLIENT)
    public String K() {
        return this.L;
    }

    public void a(KeyPair par1KeyPair) {
        this.I = par1KeyPair;
    }

    public void c(int par1) {
        for (int var2 = 0; var2 < this.c.length; ++var2) {
            in var3 = this.c[var2];
            if (var3 == null) continue;
            if (var3.K().t()) {
                var3.s = 3;
                var3.a(true, true);
                continue;
            }
            if (this.I()) {
                var3.s = par1;
                var3.a(var3.s > 0, true);
                continue;
            }
            var3.s = par1;
            var3.a(this.L(), this.y);
        }
    }

    protected boolean L() {
        return true;
    }

    public boolean M() {
        return this.M;
    }

    public void b(boolean par1) {
        this.M = par1;
    }

    public void c(boolean par1) {
        this.N = par1;
    }

    public aij N() {
        return this.m;
    }

    public void P() {
        this.O = true;
        this.N().d();
        for (int var1 = 0; var1 < this.c.length; ++var1) {
            in var2 = this.c[var1];
            if (var2 == null) continue;
            MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(var2));
            var2.m();
        }
        this.N().e(this.c[0].J().g());
        this.n();
    }

    public String Q() {
        return this.P;
    }

    public void n(String par1Str) {
        this.P = par1Str;
    }

    @Override
    public void a(le par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("whitelist_enabled", false);
        par1PlayerUsageSnooper.a("whitelist_count", 0);
        par1PlayerUsageSnooper.a("players_current", this.y());
        par1PlayerUsageSnooper.a("players_max", this.z());
        par1PlayerUsageSnooper.a("players_seen", this.t.m().length);
        par1PlayerUsageSnooper.a("uses_auth", this.x);
        par1PlayerUsageSnooper.a("gui_state", this.ag() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.a("avg_tick_ms", (int)(ke.a(this.j) * 1.0E-6));
        par1PlayerUsageSnooper.a("avg_sent_packet_count", (int)ke.a(this.f));
        par1PlayerUsageSnooper.a("avg_sent_packet_size", (int)ke.a(this.g));
        par1PlayerUsageSnooper.a("avg_rec_packet_count", (int)ke.a(this.h));
        par1PlayerUsageSnooper.a("avg_rec_packet_size", (int)ke.a(this.i));
        int var2 = 0;
        for (int var3 = 0; var3 < this.c.length; ++var3) {
            if (this.c[var3] == null) continue;
            in var4 = this.c[var3];
            ahx var5 = var4.K();
            par1PlayerUsageSnooper.a("world[" + var2 + "][dimension]", var4.u.h);
            par1PlayerUsageSnooper.a("world[" + var2 + "][mode]", (Object)var5.r());
            par1PlayerUsageSnooper.a("world[" + var2 + "][difficulty]", var4.s);
            par1PlayerUsageSnooper.a("world[" + var2 + "][hardcore]", var5.t());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_name]", var5.u().a());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_version]", var5.u().c());
            par1PlayerUsageSnooper.a("world[" + var2 + "][height]", this.D);
            par1PlayerUsageSnooper.a("world[" + var2 + "][chunks_loaded]", var4.I().e());
            ++var2;
        }
        par1PlayerUsageSnooper.a("worlds", var2);
    }

    @Override
    public void b(le par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("singleplayer", this.I());
        par1PlayerUsageSnooper.a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.a("dedicated", this.T());
    }

    @Override
    public boolean R() {
        return true;
    }

    public int S() {
        return 16;
    }

    public abstract boolean T();

    public boolean U() {
        return this.x;
    }

    public void d(boolean par1) {
        this.x = par1;
    }

    public boolean V() {
        return this.y;
    }

    public void e(boolean par1) {
        this.y = par1;
    }

    public boolean W() {
        return this.z;
    }

    public void f(boolean par1) {
        this.z = par1;
    }

    public boolean X() {
        return this.A;
    }

    public void g(boolean par1) {
        this.A = par1;
    }

    public boolean Y() {
        return this.B;
    }

    public void h(boolean par1) {
        this.B = par1;
    }

    public abstract boolean Z();

    public String aa() {
        return this.C;
    }

    public void o(String par1Str) {
        this.C = par1Str;
    }

    public int ab() {
        return this.D;
    }

    public void d(int par1) {
        this.D = par1;
    }

    public boolean ac() {
        return this.v;
    }

    public gm ad() {
        return this.t;
    }

    public void a(gm par1ServerConfigurationManager) {
        this.t = par1ServerConfigurationManager;
    }

    public void a(yl par1EnumGameType) {
        for (int var2 = 0; var2 < this.c.length; ++var2) {
            MinecraftServer.D().c[var2].K().a(par1EnumGameType);
        }
    }

    public abstract iw ae();

    @SideOnly(value=Side.CLIENT)
    public boolean af() {
        return this.Q;
    }

    public boolean ag() {
        return false;
    }

    public abstract String a(yl var1, boolean var2);

    public int ah() {
        return this.w;
    }

    public void ai() {
        this.T = true;
    }

    @SideOnly(value=Side.CLIENT)
    public le aj() {
        return this.n;
    }

    @Override
    public s b() {
        return new s(0, 0, 0);
    }

    public int ak() {
        return 16;
    }

    public static gm a(MinecraftServer par0MinecraftServer) {
        return par0MinecraftServer.t;
    }

    @SideOnly(value=Side.SERVER)
    public static void main(String[] par0ArrayOfStr) {
        FMLRelauncher.handleServerRelaunch(new ArgsWrapper(par0ArrayOfStr));
    }

    @SideOnly(value=Side.SERVER)
    public static void fmlReentry(ArgsWrapper wrap) {
        String[] par0ArrayOfStr = wrap.args;
        jq.a();
        try {
            boolean var1 = !GraphicsEnvironment.isHeadless();
            String var2 = null;
            String var3 = ".";
            String var4 = null;
            boolean var5 = false;
            boolean var6 = false;
            int var7 = -1;
            for (int var8 = 0; var8 < par0ArrayOfStr.length; ++var8) {
                String var9 = par0ArrayOfStr[var8];
                String var10 = var8 == par0ArrayOfStr.length - 1 ? null : par0ArrayOfStr[var8 + 1];
                boolean var11 = false;
                if (!var9.equals("nogui") && !var9.equals("--nogui")) {
                    if (var9.equals("--port") && var10 != null) {
                        var11 = true;
                        try {
                            var7 = Integer.parseInt(var10);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (var9.equals("--singleplayer") && var10 != null) {
                        var11 = true;
                        var2 = var10;
                    } else if (var9.equals("--universe") && var10 != null) {
                        var11 = true;
                        var3 = var10;
                    } else if (var9.equals("--world") && var10 != null) {
                        var11 = true;
                        var4 = var10;
                    } else if (var9.equals("--demo")) {
                        var5 = true;
                    } else if (var9.equals("--bonusChest")) {
                        var6 = true;
                    }
                } else {
                    var1 = false;
                }
                if (!var11) continue;
                ++var8;
            }
            ho var15 = new ho(new File(var3));
            if (var2 != null) {
                var15.k(var2);
            }
            if (var4 != null) {
                var15.l(var4);
            }
            if (var7 >= 0) {
                var15.b(var7);
            }
            if (var5) {
                var15.b(true);
            }
            if (var6) {
                var15.c(true);
            }
            if (var1) {
                var15.an();
            }
            var15.t();
            Runtime.getRuntime().addShutdownHook((Thread)new fx(var15));
        }
        catch (Exception var14) {
            a.log(Level.SEVERE, "Failed to start the minecraft server", var14);
        }
    }
}

