/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.util.Properties;

public class CustomAnimation {
    private String imagePath = null;
    public byte[] imageBytes = null;
    public int frameWidth = 0;
    public int frameHeight = 0;
    public CustomAnimationFrame[] frames = null;
    public int activeFrame = 0;
    public String destTexture = null;
    public int destX = 0;
    public int destY = 0;

    public CustomAnimation(String imagePath, byte[] data, int frameWidth, int frameHeight, Properties props, int durDef) {
        this.imagePath = imagePath;
        this.imageBytes = data;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        int frameLen = frameWidth * frameHeight * 4;
        if (data.length % frameLen != 0) {
            Config.dbg("Invalid animated texture length: " + data.length + ", frameWidth: " + frameHeight + ", frameHeight: " + frameHeight);
        }
        int numFrames = data.length / frameLen;
        if (props.get("tile.0") != null) {
            int i2 = 0;
            while (props.get("tile." + i2) != null) {
                numFrames = i2 + 1;
                ++i2;
            }
        }
        String durationDefStr = (String)props.get("duration");
        int durationDef = Config.parseInt(durationDefStr, durDef);
        this.frames = new CustomAnimationFrame[numFrames];
        for (int i3 = 0; i3 < this.frames.length; ++i3) {
            CustomAnimationFrame frm;
            String indexStr = (String)props.get("tile." + i3);
            int index = Config.parseInt(indexStr, i3);
            String durationStr = (String)props.get("duration." + i3);
            int duration = Config.parseInt(durationStr, durationDef);
            this.frames[i3] = frm = new CustomAnimationFrame(index, duration);
        }
    }

    public boolean nextFrame() {
        if (this.frames.length <= 0) {
            return false;
        }
        if (this.activeFrame >= this.frames.length) {
            this.activeFrame = 0;
        }
        CustomAnimationFrame frame = this.frames[this.activeFrame];
        ++frame.counter;
        if (frame.counter < frame.duration) {
            return false;
        }
        frame.counter = 0;
        ++this.activeFrame;
        if (this.activeFrame >= this.frames.length) {
            this.activeFrame = 0;
        }
        return true;
    }

    public int getActiveFrameIndex() {
        if (this.frames.length <= 0) {
            return 0;
        }
        if (this.activeFrame >= this.frames.length) {
            this.activeFrame = 0;
        }
        CustomAnimationFrame frame = this.frames[this.activeFrame];
        return frame.index;
    }

    public int getFrameCount() {
        return this.frames.length;
    }

    public boolean updateCustomTexture(ByteBuffer imgData, boolean animated, boolean dynamicTexturesUpdated, StringBuffer dataIdBuf) {
        if (this.imageBytes == null) {
            return false;
        }
        if (!animated && dynamicTexturesUpdated) {
            return true;
        }
        if (!this.nextFrame()) {
            return true;
        }
        int imgLen = this.frameWidth * this.frameHeight * 4;
        if (this.imageBytes.length < imgLen) {
            return false;
        }
        int imgCount = this.getFrameCount();
        int imgNum = this.getActiveFrameIndex();
        int offset = 0;
        if (animated) {
            offset = imgLen * imgNum;
        }
        if (offset + imgLen > this.imageBytes.length) {
            return true;
        }
        imgData.clear();
        imgData.put(this.imageBytes, offset, imgLen);
        imgData.position(0).limit(imgLen);
        dataIdBuf.append(this.imagePath);
        dataIdBuf.append(":");
        dataIdBuf.append(imgNum);
        return true;
    }
}

