/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.sounds;

import java.util.HashMap;
import java.util.Map;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.aesthetics.cube.BlockCube;
import railcraft.common.blocks.aesthetics.cube.EnumCube;
import railcraft.common.blocks.aesthetics.post.EnumPost;
import railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import railcraft.common.blocks.aesthetics.wall.EnumWall;

public class SoundRegistry {
    private static final Map customSounds = new HashMap();

    public static amu getSound(int blockID, int meta) {
        Map blockSounds = (Map)customSounds.get(blockID);
        if (blockSounds != null) {
            return (amu)blockSounds.get(meta);
        }
        return null;
    }

    public static void setupBlockSounds() {
        Object block = RailcraftBlocks.getBlockPost();
        if (block != null) {
            SoundRegistry.registerCustomStepSound(block.cm, EnumPost.WOOD.ordinal(), amq.e);
            SoundRegistry.registerCustomStepSound(block.cm, EnumPost.STONE.ordinal(), amq.h);
        }
        if ((block = BlockCube.getBlock()) != null) {
            for (Enum enum_ : EnumCube.VALUES) {
                SoundRegistry.registerCustomStepSound(block.cm, enum_.ordinal(), amq.h);
            }
            SoundRegistry.registerCustomStepSound(block.cm, EnumCube.STEEL_BLOCK.ordinal(), amq.i);
            SoundRegistry.registerCustomStepSound(block.cm, EnumCube.CRUSHED_OBSIDIAN.ordinal(), amq.f);
        }
        if ((block = BlockRailcraftWall.getBlock()) != null) {
            for (Enum enum_ : EnumWall.VALUES) {
                SoundRegistry.registerCustomStepSound(block.cm, enum_.ordinal(), amq.h);
            }
            SoundRegistry.registerCustomStepSound(block.cm, EnumWall.ICE.ordinal(), amq.j);
            SoundRegistry.registerCustomStepSound(block.cm, EnumWall.SNOW.ordinal(), amq.m);
        }
    }

    private static void registerCustomStepSound(int blockID, int metadata, amu sound) {
        HashMap<Integer, amu> blockSounds = (HashMap<Integer, amu>)customSounds.get(blockID);
        if (blockSounds == null) {
            blockSounds = new HashMap<Integer, amu>();
            customSounds.put(blockID, blockSounds);
        }
        blockSounds.put(metadata, sound);
    }
}

