/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.TrackRegistry;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.RailcraftTileEntity;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.RailcraftPacket;

public class PacketTileEntity
extends RailcraftPacket {
    private RailcraftTileEntity tile;

    public PacketTileEntity() {
    }

    public PacketTileEntity(RailcraftTileEntity tile) {
        this.tile = tile;
    }

    @Override
    public ef getPacket() {
        ef pkt = super.getPacket();
        pkt.r = true;
        return pkt;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tile.l);
        data.writeInt(this.tile.m);
        data.writeInt(this.tile.n);
        data.writeShort(this.tile.getId());
        this.tile.writePacketData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        yc world = Game.getWorld();
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        short id = data.readShort();
        if (id < 0 || y < 0 || !world.f(x, y, z)) {
            return;
        }
        any te = world.q(x, y, z);
        if (te instanceof RailcraftTileEntity) {
            this.tile = (RailcraftTileEntity)te;
            if (this.tile.getId() != id) {
                this.tile = null;
            }
        } else {
            this.tile = null;
        }
        if (this.tile == null) {
            int blockId = world.a(x, y, z);
            amq blockTrack = RailcraftBlocks.getBlockTrack();
            if (blockTrack != null && blockTrack.cm == blockId) {
                ITrackInstance track = TrackRegistry.getTrackSpec(id).createInstanceFromSpec();
                this.tile = new TileTrack(track);
                world.a(x, y, z, (any)this.tile);
            } else {
                world.r(x, y, z);
                te = world.q(x, y, z);
                if (te instanceof RailcraftTileEntity) {
                    this.tile = (RailcraftTileEntity)te;
                }
            }
        }
        if (this.tile == null) {
            return;
        }
        this.tile.readPacketData(data);
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.TILE_ENTITY.ordinal();
    }
}

