/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.DimensionManager;
import railcraft.common.api.signals.AbstractPair;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SignalReceiver;
import railcraft.common.util.network.PacketPairUpdate;
import railcraft.common.util.network.RailcraftPacket;

public class PacketPairRequest
extends RailcraftPacket {
    private AbstractPair pairing;
    private Player player;
    private RailcraftPacket.PacketType packetType;

    public PacketPairRequest(Player player, RailcraftPacket.PacketType type) {
        this.player = player;
        this.packetType = type;
    }

    public PacketPairRequest(AbstractPair pairing) {
        this.pairing = pairing;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        any tile = this.pairing.getTile();
        data.writeInt(tile.k.u.h);
        data.writeInt(tile.l);
        data.writeInt(tile.m);
        data.writeInt(tile.n);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        in world = DimensionManager.getWorld((int)data.readInt());
        if (world == null) {
            return;
        }
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        any tile = world.q(x, y, z);
        switch (this.packetType) {
            case CONTROLLER_REQUEST: {
                if (!(tile instanceof IControllerTile)) break;
                this.pairing = ((IControllerTile)tile).getController();
                break;
            }
            case RECEIVER_REQUEST: {
                if (!(tile instanceof IReceiverTile)) break;
                this.pairing = ((IReceiverTile)tile).getReceiver();
            }
        }
        if (this.pairing != null && this.player != null) {
            PacketPairUpdate pkt = new PacketPairUpdate(this.pairing);
            PacketDispatcher.sendPacketToPlayer((ef)pkt.getPacket(), (Player)this.player);
        }
    }

    @Override
    public int getID() {
        if (this.pairing instanceof SignalController) {
            return RailcraftPacket.PacketType.CONTROLLER_REQUEST.ordinal();
        }
        if (this.pairing instanceof SignalReceiver) {
            return RailcraftPacket.PacketType.RECEIVER_REQUEST.ordinal();
        }
        return -1;
    }
}

