/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.DimensionManager;
import railcraft.common.util.network.IGuiReturnHandler;
import railcraft.common.util.network.RailcraftPacket;

public class PacketGuiReturn
extends RailcraftPacket {
    private IGuiReturnHandler obj;

    public PacketGuiReturn() {
    }

    public PacketGuiReturn(IGuiReturnHandler obj) {
        this.obj = obj;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.obj.getWorld().u.h);
        if (this.obj instanceof any) {
            any tile = (any)this.obj;
            data.writeBoolean(true);
            data.writeInt(tile.l);
            data.writeInt(tile.m);
            data.writeInt(tile.n);
        } else if (this.obj instanceof lq) {
            lq entity = (lq)this.obj;
            data.writeBoolean(false);
            data.writeInt(entity.k);
        } else {
            return;
        }
        this.obj.writeGuiData(data);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        int dim = data.readInt();
        in world = DimensionManager.getWorld((int)dim);
        boolean tileReturn = data.readBoolean();
        if (tileReturn) {
            int z;
            int y;
            int x = data.readInt();
            any t = world.q(x, y = data.readInt(), z = data.readInt());
            if (t instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)t).readGuiData(data);
            }
        } else {
            int entityId = data.readInt();
            lq entity = world.a(entityId);
            if (entity instanceof IGuiReturnHandler) {
                ((IGuiReturnHandler)entity).readGuiData(data);
            }
        }
    }

    public void sendPacket() {
        PacketDispatcher.sendPacketToServer((ef)this.getPacket());
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.GUI_RETURN.ordinal();
    }
}

