/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.misc;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import railcraft.common.core.Railcraft;

public class Game {
    private static final Logger log = Logger.getLogger("Railcraft");

    public static boolean isHost(yc world) {
        return !world.I;
    }

    public static boolean isNotHost(yc world) {
        return world.I;
    }

    @SideOnly(value=Side.CLIENT)
    public static yc getWorld() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null) {
            return mc.e;
        }
        return null;
    }

    public static boolean isObfuscated() {
        return !yc.class.getSimpleName().equals("World");
    }

    public static void log(Level level, String msg, Object ... params) {
        String m = msg;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            m = m.replace("{" + i + "}", params[i].toString());
        }
        log.log(level, m);
    }

    public static void logDebug(Level level, String msg, Object ... params) {
        if (Railcraft.getVersion().endsWith("0")) {
            return;
        }
        String m = msg;
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            m = m.replace("{" + i + "}", params[i].toString());
        }
        log.log(level, m);
    }

    public static void logErrorAPI(String mod, Throwable error) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        StackTraceElement[] stackTrace = error.getStackTrace();
        if (stackTrace.length > 0) {
            msg.append(", ").append(stackTrace[0]);
        }
        log.log(Level.SEVERE, msg.toString());
    }

    public static void logError(String msg, Throwable error) {
        log.log(Level.SEVERE, msg, error);
    }

    public static void logErrorFingerprint(String mod) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" failed validation, terminating. Please re-download ").append(mod).append(".");
        log.log(Level.SEVERE, msg.toString());
    }

    static {
        log.setParent(FMLCommonHandler.instance().getFMLLogger());
    }
}

