/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.misc;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityEvent;
import railcraft.common.blocks.machine.alpha.TileAnchorPersonal;
import railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import railcraft.common.carts.EntityCartAnchor;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.util.misc.Game;

public class ChunkManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static ChunkManager instance;

    public static ChunkManager getInstance() {
        if (instance == null) {
            instance = new ChunkManager();
        }
        return instance;
    }

    @ForgeSubscribe
    public void entityEnteredChunk(EntityEvent.EnteringChunk event) {
        lq entity = event.entity;
        if (entity instanceof EntityCartAnchor) {
            if (Game.isHost(entity.p)) {
                ((EntityCartAnchor)entity).forceChunkLoading(event.newChunkX, event.newChunkZ);
            } else {
                ((EntityCartAnchor)entity).setupChunks(event.newChunkX, event.newChunkZ);
            }
        }
    }

    public Set getChunksBetween(int xChunkA, int zChunkA, int xChunkB, int zChunkB, int max) {
        HashSet<xv> chunkList = new HashSet<xv>();
        if (xChunkA != xChunkB && zChunkA != zChunkB) {
            return chunkList;
        }
        int xStart = Math.min(xChunkA, xChunkB);
        int xEnd = Math.max(xChunkA, xChunkB);
        int zStart = Math.min(zChunkA, zChunkB);
        int zEnd = Math.max(zChunkA, zChunkB);
        for (int xx2 = xStart; xx2 <= xEnd; ++xx2) {
            for (int zz = zStart; zz <= zEnd; ++zz) {
                chunkList.add(new xv(xx2, zz));
                if (chunkList.size() < max) continue;
                return chunkList;
            }
        }
        return chunkList;
    }

    public Set getChunksAround(int xChunk, int zChunk, int radius) {
        HashSet<xv> chunkList = new HashSet<xv>();
        for (int xx2 = xChunk - radius; xx2 <= xChunk + radius; ++xx2) {
            for (int zz = zChunk - radius; zz <= zChunk + radius; ++zz) {
                chunkList.add(new xv(xx2, zz));
            }
        }
        return chunkList;
    }

    public Set getBufferAround(int xWorld, int zWorld, int radius) {
        int minX = xWorld - radius >> 4;
        int maxX = xWorld + radius >> 4;
        int minZ = zWorld - radius >> 4;
        int maxZ = zWorld + radius >> 4;
        HashSet<xv> chunkList = new HashSet<xv>();
        for (int xx2 = minX; xx2 <= maxX; ++xx2) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                chunkList.add(new xv(xx2, zz));
            }
        }
        return chunkList;
    }

    private void printAnchor(String type, int x, int y, int z) {
        if (RailcraftConfig.printAnchorLocations()) {
            Game.log(Level.FINEST, "{0} found at [{1},{2},{3}]", type, x, y, z);
        }
    }

    public void ticketsLoaded(List tickets, yc world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            lq entity = ticket.getEntity();
            if (entity == null) {
                any tile;
                int x = ticket.getModData().e("xCoord");
                int y = ticket.getModData().e("yCoord");
                int z = ticket.getModData().e("zCoord");
                if (y < 0 || !((tile = world.q(x, y, z)) instanceof TileAnchorWorld)) continue;
                TileAnchorWorld anchor = (TileAnchorWorld)tile;
                anchor.forceChunkLoading(ticket);
                this.printAnchor(anchor.b(), x, y, z);
                continue;
            }
            if (!(entity instanceof EntityCartAnchor)) continue;
            EntityCartAnchor anchor = (EntityCartAnchor)entity;
            anchor.setChunkTicket(ticket);
            anchor.forceChunkLoading(anchor.ai, anchor.ak);
            this.printAnchor(anchor.b(), (int)entity.t, (int)entity.u, (int)entity.v);
        }
    }

    public List ticketsLoaded(List tickets, yc world, int maxTicketCount) {
        HashSet<ForgeChunkManager.Ticket> tileTickets = new HashSet<ForgeChunkManager.Ticket>();
        HashSet<ForgeChunkManager.Ticket> cartTickets = new HashSet<ForgeChunkManager.Ticket>();
        for (ForgeChunkManager.Ticket ticket : tickets) {
            lq entity = ticket.getEntity();
            if (entity == null) {
                any tile;
                int x = ticket.getModData().e("xCoord");
                int y = ticket.getModData().e("yCoord");
                int z = ticket.getModData().e("zCoord");
                if (y < 0 || !((tile = world.q(x, y, z)) instanceof TileAnchorWorld)) continue;
                tileTickets.add(ticket);
                continue;
            }
            if (!(entity instanceof EntityCartAnchor)) continue;
            cartTickets.add(ticket);
        }
        LinkedList<ForgeChunkManager.Ticket> claimedTickets = new LinkedList<ForgeChunkManager.Ticket>();
        claimedTickets.addAll(cartTickets);
        claimedTickets.addAll(tileTickets);
        return claimedTickets;
    }

    public ListMultimap playerTicketsLoaded(ListMultimap tickets, yc world) {
        for (ForgeChunkManager.Ticket ticket : tickets.values()) {
            any tile;
            lq entity = ticket.getEntity();
            if (entity != null) continue;
            int x = ticket.getModData().e("xCoord");
            int y = ticket.getModData().e("yCoord");
            int z = ticket.getModData().e("zCoord");
            if (y < 0 || !((tile = world.q(x, y, z)) instanceof TileAnchorPersonal)) continue;
            this.printAnchor(((TileAnchorPersonal)tile).b(), x, y, z);
        }
        return LinkedListMultimap.create();
    }
}

