/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.inventory;

import buildcraft.api.inventory.ISelectiveInventory;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.PipeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.api.core.items.IItemType;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.ItemStackMap;
import railcraft.common.util.inventory.SelectiveInventoryMapper;
import railcraft.common.util.inventory.SpecialInventoryMapper;
import railcraft.common.util.inventory.StandaloneInventory;
import railcraft.common.util.misc.EnumColor;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public abstract class InvTools {
    private static final String TAG_ID = "id";
    private static final String TAG_SIZE = "stackSize";
    private static final String TAG_DAMAGE = "Damage";
    private static final String TAG_COUNT = "Count";
    private static final String TAG_NBT = "tag";
    private static final String TAG_SLOT = "Slot";

    public static List getAdjacentInventories(yc world, int i, int j, int k) {
        return InvTools.getAdjacentInventories(world, i, j, k, null);
    }

    public static List getAdjacentInventories(yc world, int i, int j, int k, Class type) {
        ArrayList<la> list = new ArrayList<la>(5);
        for (int side = 0; side < 6; ++side) {
            la inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            list.add(inv);
        }
        return list;
    }

    public static Map getAdjacentInventoryMap(yc world, int i, int j, int k) {
        return InvTools.getAdjacentInventoryMap(world, i, j, k, null);
    }

    public static Map getAdjacentInventoryMap(yc world, int i, int j, int k, Class type) {
        TreeMap<Integer, la> map = new TreeMap<Integer, la>();
        for (int side = 0; side < 6; ++side) {
            la inv = InvTools.getInventoryFromSide(world, i, j, k, ForgeDirection.getOrientation((int)side), type, null);
            if (inv == null) continue;
            map.put(side, inv);
        }
        return map;
    }

    public static la getInventoryFromSide(yc world, int x, int y, int z, ForgeDirection side, Class type, Class exclude) {
        any tile = world.q(x = MiscTools.getXOnSide(x, side), y = MiscTools.getYOnSide(y, side), z = MiscTools.getZOnSide(z, side));
        if (tile == null || !(tile instanceof la) || type != null && !type.isAssignableFrom(tile.getClass()) || exclude != null && exclude.isAssignableFrom(tile.getClass())) {
            return null;
        }
        if (!PipeManager.canExtractItems(null, world, x, y, z)) {
            return null;
        }
        la inv = (la)tile;
        ForgeDirection oppositeSide = side.getOpposite();
        if (inv instanceof ISelectiveInventory) {
            inv = new SelectiveInventoryMapper((ISelectiveInventory)inv, side);
        } else if (inv instanceof ISpecialInventory) {
            inv = new SpecialInventoryMapper((ISpecialInventory)inv, oppositeSide);
        } else if (inv instanceof ISidedInventory) {
            inv = new InventoryMapper((ISidedInventory)inv, oppositeSide);
        } else if (inv instanceof anm) {
            for (int s = 2; s < 6; ++s) {
                tile = MiscTools.getBlockTileEntityOnSide(world, x, y, z, ForgeDirection.getOrientation((int)s));
                if (!(tile instanceof anm)) continue;
                la inv2 = (la)tile;
                return new kz("Large Chest", inv, inv2);
            }
        }
        return inv;
    }

    public static EnumColor getItemColor(ur stack) {
        if (stack == null) {
            return null;
        }
        if (stack.c == amq.ae.cm) {
            return EnumColor.fromId(15 - stack.j());
        }
        if (stack.c == up.aW.cj) {
            return EnumColor.fromId(stack.j());
        }
        return null;
    }

    public static boolean isSynthetic(ur stack) {
        bq nbt = stack.p();
        return nbt != null && nbt.b("synthetic");
    }

    public static void markItemSynthetic(ur stack) {
        bq nbt = InvTools.getItemData(stack);
        nbt.a("synthetic", true);
        bq display = nbt.l("display");
        nbt.a("display", display);
        by lore = display.m("Lore");
        display.a("Lore", (cd)lore);
        lore.a((cd)new cc("Synthetic", "\u00a77\u00a7o" + RailcraftLanguage.translate("item.synthetic")));
    }

    public static void addItemToolTip(ur stack, String tag, String msg) {
        bq nbt = InvTools.getItemData(stack);
        bq display = nbt.l("display");
        nbt.a("display", display);
        by lore = display.m("Lore");
        display.a("Lore", (cd)lore);
        lore.a((cd)new cc(tag, msg));
    }

    public static bq getItemData(ur stack) {
        bq nbt = stack.p();
        if (nbt == null) {
            nbt = new bq(TAG_NBT);
            stack.d(nbt);
        }
        return nbt;
    }

    public static ur depleteItem(ur stack) {
        if (stack.a == 1) {
            return stack.b().getContainerItemStack(stack);
        }
        stack.a(1);
        return stack;
    }

    public static ur damageItem(ur stack, int damage) {
        if (!stack.f()) {
            return stack;
        }
        int curDamage = stack.j();
        stack.b(curDamage += damage);
        if (stack.j() >= stack.k()) {
            --stack.a;
            stack.b(0);
        }
        if (stack.a <= 0) {
            stack = null;
        }
        return stack;
    }

    public static void dropItem(ur stack, yc world, double x, double y, double z) {
        if (stack == null || stack.a < 1) {
            return;
        }
        px entityItem = new px(world, x, y + 1.5, z, stack);
        entityItem.b = 10;
        world.d((lq)entityItem);
    }

    public static void dropInventory(la inv, yc world, int x, int y, int z) {
        if (Game.isNotHost(world)) {
            return;
        }
        for (int slot = 0; slot < inv.k_(); ++slot) {
            ur stack = inv.a(slot);
            if (stack == null) continue;
            float xOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            float yOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            float zOffset = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
            while (stack.a > 0) {
                int numToDrop = MiscTools.getRand().nextInt(21) + 10;
                if (numToDrop > stack.a) {
                    numToDrop = stack.a;
                }
                ur newStack = stack.l();
                newStack.a = numToDrop;
                stack.a -= numToDrop;
                px entityItem = new px(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), newStack);
                float variance = 0.05f;
                entityItem.w = (float)MiscTools.getRand().nextGaussian() * variance;
                entityItem.x = (float)MiscTools.getRand().nextGaussian() * variance + 0.2f;
                entityItem.y = (float)MiscTools.getRand().nextGaussian() * variance;
                world.d((lq)entityItem);
            }
            inv.a(slot, null);
        }
    }

    public static boolean isInventoryEmpty(la inv) {
        ur stack = null;
        for (int slot = 0; slot < inv.k_() && (stack = inv.a(slot)) == null; ++slot) {
        }
        return stack == null;
    }

    public static boolean isInventoryEmpty(la inv, ForgeDirection side) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            inv = new InventoryMapper(inv, sided.getStartInventorySide(side), sided.getSizeInventorySide(side));
        }
        ur stack = null;
        for (int slot = 0; slot < inv.k_() && (stack = inv.a(slot)) == null; ++slot) {
        }
        return stack == null;
    }

    public static boolean isInventoryFull(la inv) {
        ur stack = null;
        for (int slot = 0; slot < inv.k_() && (stack = inv.a(slot)) != null; ++slot) {
        }
        return stack != null;
    }

    public static boolean isInventoryFull(la inv, ForgeDirection side) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            inv = new InventoryMapper(inv, sided.getStartInventorySide(side), sided.getSizeInventorySide(side));
        }
        ur stack = null;
        for (int slot = 0; slot < inv.k_() && (stack = inv.a(slot)) != null; ++slot) {
        }
        return stack != null;
    }

    public static int countItems(la inv) {
        int count = 0;
        ur stack = null;
        for (int slot = 0; slot < inv.k_(); ++slot) {
            stack = inv.a(slot);
            if (stack == null) continue;
            count += stack.a;
        }
        return count;
    }

    public static int countItems(la inv, ForgeDirection side) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            inv = new InventoryMapper(inv, sided.getStartInventorySide(side), sided.getSizeInventorySide(side));
        }
        return InvTools.countItems(inv);
    }

    public static int countItems(la inv, IItemType filter) {
        int count = 0;
        for (int slot = 0; slot < inv.k_(); ++slot) {
            ur stack = inv.a(slot);
            if (stack == null || !filter.isItemType(stack)) continue;
            count += stack.a;
        }
        return count;
    }

    public static int countItems(la inv, ur ... filters) {
        if (inv instanceof InventoryMapper) {
            inv = ((InventoryMapper)inv).getBaseInventory();
        }
        boolean hasFilter = false;
        for (ur filter : filters) {
            if (filter == null) continue;
            hasFilter = true;
            break;
        }
        if (!hasFilter) {
            return InvTools.countItems(inv);
        }
        int count = 0;
        ur stack = null;
        block1: for (int slot = 0; slot < inv.k_(); ++slot) {
            stack = inv.a(slot);
            if (stack == null) continue;
            for (ur filter : filters) {
                if (filter == null || !InvTools.isItemEqual(stack, filter)) continue;
                count += stack.a;
                continue block1;
            }
        }
        return count;
    }

    public static int countItems(Collection inventories, ur ... filter) {
        int count = 0;
        for (la inv : inventories) {
            count += InvTools.countItems(inv, filter);
        }
        return count;
    }

    public static boolean containsItem(la inv, ur item) {
        return InvTools.countItems(inv, item) > 0;
    }

    public static Map getManifest(la inv) {
        ItemStackMap manifest = new ItemStackMap();
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null) continue;
            Integer count = (Integer)manifest.get(slot);
            if (count == null) {
                count = 0;
            }
            count = count + slot.a;
            manifest.put(slot, count);
        }
        return manifest;
    }

    public static ur moveOneItem(la source, la dest) {
        if (source instanceof ISpecialInventory) {
            ur result;
            ur[] extracted = ((ISpecialInventory)source).extractItem(false, ForgeDirection.UNKNOWN, 1);
            if (extracted != null && extracted.length > 0 && (result = InvTools.moveItemStack(extracted[0], dest)) == null) {
                ((ISpecialInventory)source).extractItem(true, ForgeDirection.UNKNOWN, 1);
                return extracted[0];
            }
            return null;
        }
        for (int inputSlot = 0; inputSlot < source.k_(); ++inputSlot) {
            ur inputStack = source.a(inputSlot);
            if (inputStack == null) continue;
            ur stackToMove = inputStack.l();
            stackToMove.a = 1;
            ur result = InvTools.moveItemStack(stackToMove, dest);
            if (result != null) continue;
            source.a(inputSlot, 1);
            return stackToMove;
        }
        return null;
    }

    public static ur moveOneItem(la source, la dest, ur ... filters) {
        ur[] extracted;
        boolean hasFilter = false;
        for (ur filter : filters) {
            if (filter == null) continue;
            hasFilter = true;
            break;
        }
        if (hasFilter && source instanceof ISelectiveInventory) {
            ur result;
            extracted = ((ISelectiveInventory)source).extractItem(filters, false, false, ForgeDirection.UNKNOWN, 1);
            if (extracted != null && extracted.length == 1 && InvTools.isItemEqual(extracted[0], filters) && (result = InvTools.moveItemStack(extracted[0], dest)) == null) {
                ((ISelectiveInventory)source).extractItem(filters, true, false, ForgeDirection.UNKNOWN, 1);
                return extracted[0];
            }
            return null;
        }
        if (source instanceof ISpecialInventory) {
            ur result;
            extracted = ((ISpecialInventory)source).extractItem(false, ForgeDirection.UNKNOWN, 1);
            if (extracted != null && extracted.length > 0 && (!hasFilter || InvTools.isItemEqual(extracted[0], filters)) && (result = InvTools.moveItemStack(extracted[0], dest)) == null) {
                ((ISpecialInventory)source).extractItem(true, ForgeDirection.UNKNOWN, 1);
                return extracted[0];
            }
            return null;
        }
        for (int inputSlot = 0; inputSlot < source.k_(); ++inputSlot) {
            ur inputStack = source.a(inputSlot);
            if (inputStack == null || hasFilter && !InvTools.isItemEqual(inputStack, filters)) continue;
            ur stackToMove = inputStack.l();
            stackToMove.a = 1;
            ur result = InvTools.moveItemStack(stackToMove, dest);
            if (result != null) continue;
            source.a(inputSlot, 1);
            return stackToMove;
        }
        return null;
    }

    public static ur moveOneItem(la source, la dest, IItemType filter) {
        if (source instanceof ISpecialInventory) {
            ur result;
            ur[] extracted = ((ISpecialInventory)source).extractItem(false, ForgeDirection.UNKNOWN, 1);
            if (extracted != null && extracted.length > 0 && filter.isItemType(extracted[0]) && (result = InvTools.moveItemStack(extracted[0], dest)) == null) {
                ((ISpecialInventory)source).extractItem(true, ForgeDirection.UNKNOWN, 1);
                return extracted[0];
            }
            return null;
        }
        for (int inputSlot = 0; inputSlot < source.k_(); ++inputSlot) {
            ur inputStack = source.a(inputSlot);
            if (inputStack == null || !filter.isItemType(inputStack)) continue;
            ur stackToMove = inputStack.l();
            stackToMove.a = 1;
            ur result = InvTools.moveItemStack(stackToMove, dest);
            if (result != null) continue;
            source.a(inputSlot, 1);
            return stackToMove;
        }
        return null;
    }

    public static ur moveOneItem(List sources, la dest, ur ... filters) {
        for (la inv : sources) {
            ur moved = InvTools.moveOneItem(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ur moveOneItem(la source, List destinations, ur ... filters) {
        for (la dest : destinations) {
            ur moved = InvTools.moveOneItem(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ur moveOneItemExcept(la source, la dest, ur ... filters) {
        boolean hasFilter = false;
        for (ur filter : filters) {
            if (filter == null) continue;
            hasFilter = true;
            break;
        }
        if (source instanceof ISpecialInventory) {
            ur result;
            ur[] extracted = ((ISpecialInventory)source).extractItem(false, ForgeDirection.UNKNOWN, 1);
            if (!(extracted == null || extracted.length <= 0 || hasFilter && InvTools.isItemEqual(extracted[0], filters) || (result = InvTools.moveItemStack(extracted[0], dest)) != null)) {
                ((ISpecialInventory)source).extractItem(true, ForgeDirection.UNKNOWN, 1);
                return extracted[0];
            }
            return null;
        }
        for (int inputSlot = 0; inputSlot < source.k_(); ++inputSlot) {
            ur inputStack = source.a(inputSlot);
            if (inputStack == null || hasFilter && InvTools.isItemEqual(inputStack, filters)) continue;
            ur stackToMove = inputStack.l();
            stackToMove.a = 1;
            ur result = InvTools.moveItemStack(stackToMove, dest);
            if (result != null) continue;
            source.a(inputSlot, 1);
            return stackToMove;
        }
        return null;
    }

    public static ur moveOneItemExcept(List sources, la dest, ur ... filters) {
        for (la inv : sources) {
            ur moved = InvTools.moveOneItemExcept(inv, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static ur moveOneItemExcept(la source, List destinations, ur ... filters) {
        for (la dest : destinations) {
            ur moved = InvTools.moveOneItemExcept(source, dest, filters);
            if (moved == null) continue;
            return moved;
        }
        return null;
    }

    public static boolean isItemEqual(ur a, ur b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.c != b.c) {
            return false;
        }
        if (a.d != null && !a.d.equals((Object)b.d)) {
            return false;
        }
        if (a.g()) {
            if (a.j() == -1 || b.j() == -1) {
                return true;
            }
            if (a.j() != b.j()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqualStrict(ur a, ur b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.c != b.c) {
            return false;
        }
        if (a.a != b.a) {
            return false;
        }
        if (a.g() && a.j() != b.j()) {
            return false;
        }
        return a.d == null || a.d.equals((Object)b.d);
    }

    public static boolean isItemEqualIgnoreNBT(ur a, ur b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.c != b.c) {
            return false;
        }
        if (a.g()) {
            if (a.j() == -1 || b.j() == -1) {
                return true;
            }
            if (a.j() != b.j()) {
                return false;
            }
        }
        return true;
    }

    public static boolean isItemEqual(ur stack, ur ... matches) {
        for (ur match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ur stack, Collection matches) {
        for (ur match : matches) {
            if (!InvTools.isItemEqual(stack, match)) continue;
            return true;
        }
        return false;
    }

    public static ur moveItemStack(ur stack, la dest) {
        boolean movedItem;
        if (stack == null) {
            return null;
        }
        stack = stack.l();
        if (dest == null) {
            return stack;
        }
        if (dest instanceof ISpecialInventory) {
            int used = ((ISpecialInventory)dest).addItem(stack, true, ForgeDirection.UNKNOWN);
            if (used >= stack.a) {
                return null;
            }
            stack.a -= used;
            return stack;
        }
        do {
            ur destStack;
            int ii;
            movedItem = false;
            for (ii = 0; ii < dest.k_(); ++ii) {
                int maxStack;
                int room;
                destStack = dest.a(ii);
                if (destStack == null || !InvTools.isItemEqual(destStack, stack) || (room = (maxStack = Math.min((destStack = destStack.l()).d(), dest.c())) - destStack.a) <= 0) continue;
                int move = Math.min(room, stack.a);
                destStack.a += move;
                stack.a -= move;
                dest.a(ii, destStack);
                if (stack.a <= 0) {
                    return null;
                }
                movedItem = true;
            }
            if (movedItem) continue;
            for (ii = 0; ii < dest.k_(); ++ii) {
                destStack = dest.a(ii);
                if (destStack != null) continue;
                if (stack.a <= dest.c()) {
                    dest.a(ii, stack);
                    return null;
                }
                dest.a(ii, stack.a(dest.c()));
                movedItem = true;
            }
        } while (movedItem);
        return stack;
    }

    public static boolean isRoomForStack(ur stack, la dest) {
        if (stack == null) {
            return false;
        }
        if (dest == null) {
            return false;
        }
        if (dest instanceof ISpecialInventory) {
            return ((ISpecialInventory)dest).addItem(stack, false, ForgeDirection.UNKNOWN) > 0;
        }
        for (int ii = 0; ii < dest.k_(); ++ii) {
            int maxStack;
            int room;
            ur slot = dest.a(ii);
            if (slot == null) {
                return true;
            }
            if (!InvTools.isItemEqual(slot, stack) || (room = (maxStack = Math.min(slot.d(), dest.c())) - slot.a) < stack.a) continue;
            return true;
        }
        return false;
    }

    public static ur[] removeItems(la inv, int numItems) {
        if (inv instanceof ISpecialInventory) {
            return ((ISpecialInventory)inv).extractItem(true, ForgeDirection.UNKNOWN, numItems);
        }
        StandaloneInventory output = new StandaloneInventory(27);
        for (int i = 0; i < inv.k_() && numItems > 0; ++i) {
            ur slot = inv.a(i);
            if (slot == null) continue;
            ur removed = inv.a(i, numItems);
            numItems -= removed.a;
            ur remainder = InvTools.moveItemStack(removed, output);
            if (remainder == null) continue;
            InvTools.moveItemStack(remainder, inv);
            numItems += remainder.a;
            break;
        }
        LinkedList<ur> list = new LinkedList<ur>();
        for (ur stack : output.getContents()) {
            if (stack == null) continue;
            list.add(stack);
        }
        return list.toArray(new ur[0]);
    }

    public static ur removeOneItem(la inv) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    public static ur removeOneItem(la inv, ur filter) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null || !InvTools.isItemEqual(slot, filter)) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    public static ur removeOneItem(la inv, IItemType filter) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null || !filter.isItemType(slot)) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    public static void writeInvToNBT(la inv, String tag, bq data) {
        by list = new by();
        for (byte slot = 0; slot < inv.k_(); slot = (byte)((byte)(slot + 1))) {
            ur stack = inv.a((int)slot);
            if (stack == null) continue;
            bq itemTag = new bq();
            itemTag.a(TAG_SLOT, slot);
            InvTools.writeItemToNBT(stack, itemTag);
            list.a((cd)itemTag);
        }
        data.a(tag, (cd)list);
    }

    public static void readInvFromNBT(la inv, String tag, bq data) {
        by list = data.m(tag);
        for (int entry = 0; entry < list.c(); entry = (int)((byte)(entry + 1))) {
            bq itemTag = (bq)list.b(entry);
            byte slot = itemTag.c(TAG_SLOT);
            if (slot < 0 || slot >= inv.k_()) continue;
            ur stack = InvTools.readItemFromNBT(itemTag);
            inv.a((int)slot, stack);
        }
    }

    public static void writeItemToNBT(ur stack, bq data) {
        if (stack == null || stack.a <= 0) {
            return;
        }
        if (stack.a > 127) {
            stack.a = 127;
        }
        stack.b(data);
    }

    public static ur readItemFromNBT(bq data) {
        short itemID = data.d(TAG_ID);
        short stackSize = data.d(TAG_SIZE);
        short damage = data.d(TAG_DAMAGE);
        if (stackSize <= 0) {
            stackSize = data.c(TAG_COUNT);
        }
        if (itemID <= 0 || stackSize <= 0) {
            return null;
        }
        ur stack = new ur((int)itemID, (int)stackSize, (int)damage);
        if (data.b(TAG_NBT)) {
            stack.d = data.l(TAG_NBT);
        }
        return stack.b() != null ? stack : null;
    }
}

