/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.effects;

import cpw.mods.fml.common.SidedProxy;
import railcraft.common.util.effects.IEffectManager;

public class EffectManager {
    @SidedProxy(clientSide="railcraft.client.util.effects.ClientProxy", serverSide="railcraft.common.util.effects.CommonProxy")
    public static IEffectManager instance;

    public static IEffectSource getEffectSource(Object source) {
        if (source instanceof any) {
            return new EffectSourceTile((any)source);
        }
        if (source instanceof lq) {
            return new EffectSourceEntity((lq)source);
        }
        return null;
    }

    public static class EffectSourceEntity
    implements IEffectSource {
        private final lq source;

        private EffectSourceEntity(lq source) {
            this.source = source;
        }

        @Override
        public double getX() {
            return this.source.t;
        }

        @Override
        public double getY() {
            return this.source.u + (double)this.source.M;
        }

        @Override
        public double getZ() {
            return this.source.v;
        }

        @Override
        public boolean isDead() {
            return this.source.L;
        }
    }

    public static class EffectSourceTile
    implements IEffectSource {
        private final any source;

        private EffectSourceTile(any source) {
            this.source = source;
        }

        @Override
        public double getX() {
            return (double)this.source.l + 0.5;
        }

        @Override
        public double getY() {
            return (double)this.source.m + 0.5;
        }

        @Override
        public double getZ() {
            return (double)this.source.n + 0.5;
        }

        @Override
        public boolean isDead() {
            return this.source.r();
        }
    }

    public static interface IEffectSource {
        public double getX();

        public double getY();

        public double getZ();

        public boolean isDead();
    }
}

