/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.crafting;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.crafting.ICokeOvenCraftingManager;
import railcraft.common.api.crafting.ICokeOvenRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.util.misc.Game;

public class CokeOvenCraftingManager
implements ICokeOvenCraftingManager {
    private final List recipes = new ArrayList();

    public static ICokeOvenCraftingManager getInstance() {
        return RailcraftCraftingManager.cokeOven;
    }

    @Override
    public List getRecipes() {
        ArrayList list = new ArrayList(this.recipes);
        return list;
    }

    @Override
    public void addRecipe(ur input, ur output, LiquidStack liquidOutput, int cookTime) {
        this.addRecipe(input.c, input.j(), output, liquidOutput, cookTime);
    }

    @Override
    public void addRecipe(int inputId, int inputDamage, ur output, LiquidStack liquidOutput, int cookTime) {
        this.recipes.add(new CokeOvenRecipe(inputId, inputDamage, output, liquidOutput, cookTime));
        Game.log(Level.FINEST, "Adding Coke Oven recipe: {0}, {1}, {2}", up.e[inputId].getClass().getName(), inputId, inputDamage);
    }

    @Override
    public void addRecipe(int inputId, ur output, LiquidStack liquidOutput, int cookTime) {
        this.addRecipe(inputId, -1, output, liquidOutput, cookTime);
    }

    @Override
    public ICokeOvenRecipe getRecipe(ur stack) {
        if (stack == null) {
            return null;
        }
        return this.getRecipe(stack.c, stack.j());
    }

    @Override
    public ICokeOvenRecipe getRecipe(int inputId, int inputDamage) {
        for (CokeOvenRecipe r : this.recipes) {
            if (r.inputId != inputId || r.inputDamage != inputDamage) continue;
            return r;
        }
        for (CokeOvenRecipe r : this.recipes) {
            if (r.inputId != inputId || r.inputDamage != -1) continue;
            return r;
        }
        return null;
    }

    public static class CokeOvenRecipe
    implements ICokeOvenRecipe {
        private final int inputId;
        private final int inputDamage;
        private final LiquidStack liquidOutput;
        private final int cookTime;
        private final ur output;

        public CokeOvenRecipe(int inputId, int inputDamage, ur output, LiquidStack liquid, int cookTime) {
            this.inputId = inputId;
            this.inputDamage = inputDamage;
            this.output = output;
            this.liquidOutput = liquid;
            this.cookTime = cookTime;
        }

        @Override
        public ur getInput() {
            return new ur(this.inputId, 1, this.inputDamage);
        }

        @Override
        public ur getOutput() {
            if (this.output == null) {
                return null;
            }
            return this.output.l();
        }

        @Override
        public LiquidStack getLiquidOutput() {
            if (this.liquidOutput != null) {
                return this.liquidOutput.copy();
            }
            return null;
        }

        @Override
        public int getCookTime() {
            return this.cookTime;
        }
    }
}

