/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.crafting;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.api.crafting.IBlastFurnaceCraftingManager;
import railcraft.common.api.crafting.IBlastFurnaceRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.items.RailcraftToolItems;

public class BlastFurnaceCraftingManager
implements IBlastFurnaceCraftingManager {
    private final List recipes = new ArrayList();

    public static IBlastFurnaceCraftingManager getInstance() {
        return RailcraftCraftingManager.blastFurnace;
    }

    @Override
    public List getFuels() {
        ArrayList<ur> fuels = new ArrayList<ur>();
        fuels.add(RailcraftToolItems.getCoalCoke());
        fuels.add(new ur(up.m, 1, 1));
        return fuels;
    }

    @Override
    public List getRecipes() {
        ArrayList list = new ArrayList(this.recipes);
        return list;
    }

    @Override
    public void addRecipe(int inputId, int inputDamage, int cookTime, ur output) {
        if (output != null) {
            this.recipes.add(new BlastFurnaceRecipe(inputId, inputDamage, cookTime, output));
        }
    }

    @Override
    public void addRecipe(int inputId, int cookTime, ur output) {
        this.addRecipe(inputId, -1, cookTime, output);
    }

    @Override
    public void addRecipe(ur input, boolean strictMatching, int cookTime, ur output) {
        if (input != null && output != null) {
            this.recipes.add(new BlastFurnaceRecipe(input.c, strictMatching ? input.j() : -1, cookTime, output));
        }
    }

    @Override
    public IBlastFurnaceRecipe getRecipe(int inputId, int inputDamage) {
        for (BlastFurnaceRecipe r : this.recipes) {
            if (r.inputId != inputId || r.inputDamage != inputDamage) continue;
            return r;
        }
        for (BlastFurnaceRecipe r : this.recipes) {
            if (r.inputId != inputId || r.inputDamage != -1) continue;
            return r;
        }
        return null;
    }

    @Override
    public IBlastFurnaceRecipe getRecipe(ur stack) {
        if (stack == null) {
            return null;
        }
        return this.getRecipe(stack.c, stack.j());
    }

    public static class BlastFurnaceRecipe
    implements IBlastFurnaceRecipe {
        private final int inputId;
        private final int inputDamage;
        private final int cookTime;
        private final ur output;

        public BlastFurnaceRecipe(int inputId, int inputDamage, int cookTime, ur output) {
            this.inputId = inputId;
            this.inputDamage = inputDamage;
            this.cookTime = cookTime;
            this.output = output;
        }

        @Override
        public boolean isRoomForOutput(ur out) {
            return out == null || this.output == null || out.a(this.output) && out.a + this.output.a <= this.output.d();
        }

        @Override
        public ur getInput() {
            return new ur(this.inputId, 1, this.inputDamage);
        }

        @Override
        public ur getOutput() {
            if (this.output == null) {
                return null;
            }
            return this.output.l();
        }

        @Override
        public int getOutputStackSize() {
            if (this.output == null) {
                return 0;
            }
            return this.output.a;
        }

        @Override
        public int getCookTime() {
            return this.cookTime;
        }
    }
}

