/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.ic2;

import cpw.mods.fml.common.Loader;
import ic2.api.Ic2Recipes;
import ic2.api.Items;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.Game;

public class IC2Plugin {
    private static Map itemCache = new HashMap();
    private static Boolean modLoaded = null;

    public static ur getItem(String tag) {
        if (!IC2Plugin.isIC2Installed()) {
            return null;
        }
        ur stack = (ur)itemCache.get(tag);
        if (stack != null) {
            return stack;
        }
        try {
            stack = Items.getItem(tag);
            if (stack != null) {
                itemCache.put(tag, stack.l());
            }
            return stack;
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
            return null;
        }
    }

    public static void addTileToNet(IEnergyTile tile) {
        try {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(tile));
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
        }
    }

    public static void removeTileFromNet(IEnergyTile tile) {
        try {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(tile));
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
        }
    }

    public static int emitEnergy(IEnergySource source, int amount) {
        try {
            EnergyTileSourceEvent event = new EnergyTileSourceEvent(source, amount);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.amount;
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
            return amount;
        }
    }

    public static void removeMaceratorRecipes(ur ... items) {
        try {
            List recipes = Ic2Recipes.getMaceratorRecipes();
            Iterator it = recipes.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (!InvTools.isItemEqual((ur)entry.getValue(), items) && !InvTools.isItemEqual((ur)entry.getKey(), items)) continue;
                it.remove();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
        }
    }

    public static void removeMaceratorDustRecipes(ur ... items) {
        try {
            List recipes = Ic2Recipes.getMaceratorRecipes();
            Iterator it = recipes.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                ur input = (ur)entry.getKey();
                if (input == null || !(input.b() instanceof vq) || !InvTools.isItemEqual((ur)entry.getValue(), items)) continue;
                it.remove();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
        }
    }

    public static void nerfSyntheticCoal() {
        for (wp r : wn.a().b()) {
            ur output = r.b();
            if (output == null || output.c != up.m.cj || output.a != 20) continue;
            output.a = 5;
        }
    }

    private static void tagCompressorCoalRecipe() {
        try {
            if (IC2Plugin.isIC2Installed()) {
                ur coal = new ur(up.m);
                List recipes = Ic2Recipes.getCompressorRecipes();
                for (Map.Entry recipe : recipes) {
                    ur output = (ur)recipe.getValue();
                    if (!InvTools.isItemEqualIgnoreNBT(output, coal)) continue;
                    InvTools.markItemSynthetic(output);
                }
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("IC2", error);
        }
    }

    public static boolean isIC2Installed() {
        if (modLoaded == null) {
            modLoaded = Loader.isModLoaded((String)"IC2");
        }
        return modLoaded;
    }
}

