/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.forge;

import net.minecraftforge.common.ChestGenHooks;
import railcraft.common.core.RailcraftConfig;

public class LootPlugin {
    public static void increaseLootGen(int min, int max, String ... locations) {
        for (String location : locations) {
            ChestGenHooks lootInfo = ChestGenHooks.getInfo((String)location);
            lootInfo.setMin(lootInfo.getMin() + min);
            lootInfo.setMax(lootInfo.getMax() + max);
        }
    }

    public static void addLoot(ur loot, int minStack, int maxStack, String tag, String ... locations) {
        kw contents = new kw(loot, minStack, maxStack, RailcraftConfig.getLootChance(tag));
        LootPlugin.addLoot(contents, locations);
    }

    public static void addLoot(kw loot, String ... locations) {
        for (String location : locations) {
            ChestGenHooks.addItem((String)location, (kw)loot);
        }
    }

    public static void addLootWarrior(ur loot, int minStack, int maxStack, String tag) {
        LootPlugin.addLoot(loot, minStack, maxStack, tag, "villageBlacksmith", "dungeonChest", "pyramidDesertyChest", "pyramidJungleChest", "strongholdCorridor", "strongholdCrossing");
    }

    public static void addLootMineshaft(ur loot, int minStack, int maxStack, String tag) {
        LootPlugin.addLoot(loot, minStack, maxStack, tag, "mineshaftCorridor");
    }

    public static void addLootTool(ur loot, int minStack, int maxStack, String tag) {
        LootPlugin.addLoot(loot, minStack, maxStack, tag, "mineshaftCorridor", "villageBlacksmith");
    }
}

