/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.craftguide;

import java.util.Map;
import railcraft.common.api.crafting.IRockCrusherRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.plugins.craftguide.FloatChanceSlot;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.RecipeGenerator;
import uristqwerty.CraftGuide.api.RecipeProvider;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.SlotType;

public class RockCrusherPlugin
implements RecipeProvider {
    private static final int RATIO = 10000;
    private final ItemSlot[] slots = new ItemSlot[11];

    public RockCrusherPlugin() {
        this.slots[0] = new ItemSlot(4, 11, 16, 16);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.slots[1 + y * 3 + x] = new FloatChanceSlot(24 + x * 18, 3 + y * 18, 16, 16, true).setSlotType(SlotType.OUTPUT_SLOT);
            }
        }
        this.slots[10] = new ItemSlot(4, 34, 16, 16).setSlotType(SlotType.MACHINE_SLOT);
    }

    @Override
    public void generateRecipes(RecipeGenerator generator) {
        ur crafter = EnumMachineAlpha.ROCK_CRUSHER.getItem();
        if (crafter != null) {
            RecipeTemplate template = generator.createRecipeTemplate(this.slots, crafter, "/railcraft/client/textures/gui/gui_craft_guide.png", 1, 61, 82, 61);
            for (IRockCrusherRecipe recipe : RailcraftCraftingManager.rockCrusher.getRecipes()) {
                Object[] items = new Object[11];
                items[0] = recipe.getInput();
                Map output = recipe.getOutputs();
                int i = 1;
                for (Map.Entry e : output.entrySet()) {
                    if (i > 9) break;
                    items[i] = new Object[]{e.getKey(), e.getValue()};
                    ++i;
                }
                items[10] = crafter;
                generator.addRecipe(template, items);
            }
        }
    }
}

