/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.buildcraft.triggers;

import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.transport.IPipe;
import java.util.LinkedList;
import railcraft.common.blocks.machine.beta.TileEngine;
import railcraft.common.plugins.buildcraft.triggers.EnumTriggers;
import railcraft.common.plugins.buildcraft.triggers.IHasCart;
import railcraft.common.plugins.buildcraft.triggers.IHasWork;
import railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import railcraft.common.plugins.buildcraft.triggers.INeedsMaintenance;
import railcraft.common.plugins.buildcraft.triggers.ITemperature;

public class TriggerProvider
implements ITriggerProvider {
    public TriggerProvider() {
        EnumTriggers.init();
    }

    @Override
    public LinkedList getPipeTriggers(IPipe pipe) {
        return null;
    }

    @Override
    public LinkedList getNeighborTriggers(amq block, any tile) {
        LinkedList<ITrigger> triggers = new LinkedList<ITrigger>();
        if (tile instanceof IHasWork) {
            triggers.add(EnumTriggers.HAS_WORK.getTrigger());
        }
        if (tile instanceof IHasCart) {
            triggers.add(EnumTriggers.HAS_CART.getTrigger());
        }
        if (tile instanceof INeedsFuel) {
            triggers.add(EnumTriggers.LOW_FUEL.getTrigger());
        }
        if (tile instanceof TileEngine) {
            triggers.add(EnumTriggers.ENGINE_BLUE.getTrigger());
            triggers.add(EnumTriggers.ENGINE_GREEN.getTrigger());
            triggers.add(EnumTriggers.ENGINE_YELLOW.getTrigger());
            triggers.add(EnumTriggers.ENGINE_ORANGE.getTrigger());
            triggers.add(EnumTriggers.ENGINE_RED.getTrigger());
        }
        if (tile instanceof ITemperature) {
            triggers.add(EnumTriggers.TEMP_COLD.getTrigger());
            triggers.add(EnumTriggers.TEMP_WARM.getTrigger());
            triggers.add(EnumTriggers.TEMP_HOT.getTrigger());
        }
        if (tile instanceof INeedsMaintenance) {
            triggers.add(EnumTriggers.NEEDS_MAINT.getTrigger());
        }
        return triggers;
    }
}

