/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.buildcraft.triggers;

import buildcraft.api.gates.ITriggerParameter;
import java.util.EnumSet;
import railcraft.common.blocks.machine.beta.TileEngine;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.plugins.buildcraft.triggers.TriggerBase;

public class TriggerEngine
extends TriggerBase {
    private final EnumSet stages;
    private final int textureOffset;

    public TriggerEngine(int id, EnumSet stages, int textureOffset) {
        super(id);
        this.stages = stages;
        this.textureOffset = textureOffset;
    }

    @Override
    public String getDescription() {
        return RailcraftLanguage.translate("gates.trigger.engine");
    }

    @Override
    public int getIndexInTexture() {
        return this.textureOffset + 240;
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (tile instanceof TileEngine) {
            TileEngine.EnergyStage engineStage = ((TileEngine)tile).getEnergyStage();
            return this.stages.contains((Object)engineStage);
        }
        return false;
    }
}

