/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.modules;

import cpw.mods.fml.common.registry.EntityRegistry;
import forestry.api.recipes.RecipeManagers;
import ic2.api.Ic2Recipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.aesthetics.cube.BlockCube;
import railcraft.common.blocks.aesthetics.cube.EntityFallingCube;
import railcraft.common.blocks.aesthetics.cube.EnumCube;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.ItemNugget;
import railcraft.common.items.RailcraftPartItems;
import railcraft.common.items.RailcraftToolItems;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.modules.ModuleManager;
import railcraft.common.modules.RailcraftModule;
import railcraft.common.plugins.forge.CraftingPlugin;
import railcraft.common.plugins.forge.LootPlugin;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.crafting.RollingMachineCraftingManager;
import railcraft.common.util.misc.BallastRegistry;
import railcraft.common.util.misc.Game;

public class ModuleFactory
extends RailcraftModule {
    @Override
    public void initFirst() {
        ur stack;
        RailcraftBlocks.registerBlockMachineAlpha();
        amq blockUtility = RailcraftBlocks.getBlockMachineAlpha();
        if (blockUtility == null) {
            this.postInitNotLoaded();
            return;
        }
        BlockCube.registerBlock();
        RailcraftToolItems.registerCoalCoke();
        EnumMachineAlpha typeUtility = EnumMachineAlpha.COKE_OVEN;
        if (RailcraftConfig.isSubBlockEnabled(typeUtility.getTag())) {
            ur rubberWood;
            stack = typeUtility.getItem();
            CraftingPlugin.addShapedRecipe(stack, "MBM", "BMB", "MBM", Character.valueOf('B'), new ur(up.aH), Character.valueOf('M'), new ur(amq.H));
            RailcraftLanguage.getInstance().registerItemName(stack, typeUtility.getTag());
            if (RailcraftToolItems.getCoalCoke() != null) {
                RailcraftCraftingManager.cokeOven.addRecipe(up.m.cj, 0, RailcraftToolItems.getCoalCoke(), LiquidItems.getCreosoteOilLiquid(500), 3000);
            }
            if ((rubberWood = IC2Plugin.getItem("rubberWood")) != null) {
                RailcraftCraftingManager.cokeOven.addRecipe(rubberWood.l(), new ur(up.m, 1, 1), LiquidItems.getCreosoteOilLiquid(250), 3000);
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((typeUtility = EnumMachineAlpha.STEAM_OVEN).getTag())) {
            CraftingPlugin.addShapedRecipe(typeUtility.getItem(4), "SSS", "SFS", "SSS", Character.valueOf('F'), new ur(amq.aE), Character.valueOf('S'), RailcraftPartItems.getPlateSteel());
            RailcraftLanguage.getInstance().registerItemName(typeUtility.getItem(), typeUtility.getTag());
        }
        if (RailcraftConfig.isSubBlockEnabled((typeUtility = EnumMachineAlpha.BLAST_FURNACE).getTag())) {
            stack = typeUtility.getItem(4);
            CraftingPlugin.addShapedRecipe(stack, "MBM", "BPB", "MBM", Character.valueOf('B'), new ur(amq.bD), Character.valueOf('M'), new ur(amq.bf), Character.valueOf('P'), up.bx);
            RailcraftLanguage.getInstance().registerItemName(stack, typeUtility.getTag());
            int burnTime = 1200;
            if (IC2Plugin.isIC2Installed() && RailcraftConfig.getRecipeConfig("ic2.refinedIron.disable") && RailcraftConfig.getRecipeConfig("ic2.refinedIron.useSteel")) {
                burnTime = RailcraftConfig.getSteelCookTime();
            }
            RailcraftCraftingManager.blastFurnace.addRecipe(up.o.cj, burnTime, RailcraftPartItems.getIngotSteel(1));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.ad.cj, 0, burnTime * 5, RailcraftPartItems.getIngotSteel(5));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.ae.cj, 0, burnTime * 8, RailcraftPartItems.getIngotSteel(8));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.af.cj, 0, burnTime * 7, RailcraftPartItems.getIngotSteel(7));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.ag.cj, 0, burnTime * 4, RailcraftPartItems.getIngotSteel(4));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.q.cj, 0, burnTime * 2, RailcraftPartItems.getIngotSteel(2));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.f.cj, 0, burnTime, RailcraftPartItems.getIngotSteel(1));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.g.cj, 0, burnTime * 3, RailcraftPartItems.getIngotSteel(3));
            RailcraftCraftingManager.blastFurnace.addRecipe(up.P.cj, 0, burnTime * 2, RailcraftPartItems.getIngotSteel(2));
            try {
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getCrowbar(), true, burnTime * 3, RailcraftPartItems.getIngotSteel(3));
                int recycleTime = burnTime / 2;
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelHelm(), false, recycleTime * 4, RailcraftPartItems.getIngotSteel(4));
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelArmor(), false, recycleTime * 6, RailcraftPartItems.getIngotSteel(6));
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelLegs(), false, recycleTime * 5, RailcraftPartItems.getIngotSteel(5));
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelBoots(), false, recycleTime * 3, RailcraftPartItems.getIngotSteel(3));
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelSword(), false, recycleTime * 1, RailcraftPartItems.getIngotSteel(1));
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelPickaxe(), false, recycleTime * 2, RailcraftPartItems.getIngotSteel(2));
                RailcraftCraftingManager.blastFurnace.addRecipe(RailcraftToolItems.getSteelHoe(), false, recycleTime * 1, RailcraftPartItems.getIngotSteel(1));
            }
            catch (Throwable error) {
                Game.logErrorAPI("Railcraft", error);
            }
        }
        if (RailcraftConfig.isSubBlockEnabled((typeUtility = EnumMachineAlpha.ROCK_CRUSHER).getTag())) {
            stack = typeUtility.getItem(4);
            CraftingPlugin.addShapedOreRecipe(stack, "PDP", "DSD", "PDP", Character.valueOf('D'), new ur(up.n), Character.valueOf('P'), new ur(amq.ac), Character.valueOf('S'), "blockSteel");
            RailcraftLanguage.getInstance().registerItemName(stack, typeUtility.getTag());
            LinkedHashMap<ur, Float> output = new LinkedHashMap<ur, Float>();
            output.put(EnumCube.CRUSHED_OBSIDIAN.getItem(), Float.valueOf(1.0f));
            output.put(RailcraftPartItems.getDustObsidian(), Float.valueOf(0.25f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.as.cm, 0, output);
            output = new LinkedHashMap();
            output.put(RailcraftPartItems.getDustObsidian(), Float.valueOf(1.0f));
            output.put(RailcraftPartItems.getDustObsidian(), Float.valueOf(0.25f));
            RailcraftCraftingManager.rockCrusher.addRecipe(EnumCube.CRUSHED_OBSIDIAN.getItem(), output);
            output = new LinkedHashMap();
            output.put(new ur(up.aH, 3), Float.valueOf(1.0f));
            output.put(new ur(up.aH), Float.valueOf(0.5f));
            output.put(new ur(amq.H), Float.valueOf(0.25f));
            output.put(new ur(amq.H), Float.valueOf(0.25f));
            output.put(new ur(amq.H), Float.valueOf(0.25f));
            output.put(new ur(amq.H), Float.valueOf(0.25f));
            output.put(new ur(amq.H), Float.valueOf(0.25f));
            RailcraftCraftingManager.rockCrusher.addRecipe(EnumMachineAlpha.COKE_OVEN.getItem(), output);
            output = new LinkedHashMap();
            output.put(new ur(amq.bD), Float.valueOf(0.75f));
            output.put(new ur(amq.bf), Float.valueOf(0.75f));
            output.put(new ur(up.bw), Float.valueOf(0.05f));
            RailcraftCraftingManager.rockCrusher.addRecipe(EnumMachineAlpha.BLAST_FURNACE.getItem(), output);
            output = new LinkedHashMap();
            output.put(EnumCube.CRUSHED_OBSIDIAN.getItem(), Float.valueOf(1.0f));
            output.put(EnumCube.CRUSHED_OBSIDIAN.getItem(), Float.valueOf(0.5f));
            output.put(new ur(up.n), Float.valueOf(0.5f));
            output.put(new ur(amq.as), Float.valueOf(0.25f));
            output.put(RailcraftPartItems.getDustObsidian(), Float.valueOf(0.25f));
            output.put(new ur(up.bq, 16), Float.valueOf(1.0f));
            output.put(new ur(up.bq, 8), Float.valueOf(0.5f));
            output.put(new ur(up.bq, 8), Float.valueOf(0.5f));
            output.put(new ur(up.bq, 4), Float.valueOf(0.5f));
            RailcraftCraftingManager.rockCrusher.addRecipe(EnumMachineAlpha.WORLD_ANCHOR.getItem(), output);
            output = new LinkedHashMap();
            output.put(EnumCube.CRUSHED_OBSIDIAN.getItem(), Float.valueOf(1.0f));
            output.put(EnumCube.CRUSHED_OBSIDIAN.getItem(), Float.valueOf(0.5f));
            output.put(new ur(up.bH), Float.valueOf(0.5f));
            output.put(new ur(amq.as), Float.valueOf(0.25f));
            output.put(RailcraftPartItems.getDustObsidian(), Float.valueOf(0.25f));
            output.put(new ur(up.bq, 16), Float.valueOf(1.0f));
            output.put(new ur(up.bq, 8), Float.valueOf(0.5f));
            output.put(new ur(up.bq, 8), Float.valueOf(0.5f));
            output.put(new ur(up.bq, 4), Float.valueOf(0.5f));
            RailcraftCraftingManager.rockCrusher.addRecipe(EnumMachineAlpha.PERSONAL_ANCHOR.getItem(), output);
            output = new LinkedHashMap();
            output.put(new ur(amq.I), Float.valueOf(1.0f));
            output.put(new ur(up.ap), Float.valueOf(0.1f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.z.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.I), Float.valueOf(1.0f));
            output.put(new ur(amq.bx), Float.valueOf(0.1f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.ar.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.H), Float.valueOf(1.0f));
            output.put(new ur(up.bq), Float.valueOf(0.001f));
            output.put(new ur(up.n), Float.valueOf(5.0E-5f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.I.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.z), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.w.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.H), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.T.cm, -1, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aH, 3), Float.valueOf(1.0f));
            output.put(new ur(up.aH), Float.valueOf(0.5f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.ao.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aI, 4), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.aZ.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.z), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bp.cm, -1, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.I), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.aK.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.z), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bA.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.bD), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bF.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aH, 4), Float.valueOf(1.0f));
            output.put(new ur(up.aH), Float.valueOf(0.5f));
            output.put(new ur(up.aH), Float.valueOf(0.5f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bz.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.z), Float.valueOf(0.45f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.an.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.H), Float.valueOf(0.45f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.an.cm, 1, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.I), Float.valueOf(0.45f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.an.cm, 3, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aH), Float.valueOf(1.0f));
            output.put(new ur(up.aH), Float.valueOf(0.75f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.an.cm, 4, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.z), Float.valueOf(0.45f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.an.cm, 5, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.aX), Float.valueOf(0.85f));
            output.put(new ur(up.aD), Float.valueOf(0.25f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.aW.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(amq.bD), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bE.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aT, 3), Float.valueOf(1.0f));
            output.put(new ur(up.aT), Float.valueOf(0.75f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bg.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aT, 3), Float.valueOf(1.0f));
            output.put(new ur(up.aT), Float.valueOf(0.75f));
            output.put(new ur(up.aC, 3), Float.valueOf(1.0f));
            output.put(new ur(up.aC), Float.valueOf(0.75f));
            RailcraftCraftingManager.rockCrusher.addRecipe(amq.bO.cm, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(up.aW, 4, 15), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(up.aX.cj, 0, output);
            output = new LinkedHashMap();
            output.put(new ur(up.bw, 2), Float.valueOf(1.0f));
            output.put(new ur(up.bw), Float.valueOf(0.25f));
            output.put(new ur(up.bw), Float.valueOf(0.25f));
            output.put(new ur(up.bw), Float.valueOf(0.25f));
            RailcraftCraftingManager.rockCrusher.addRecipe(up.bo.cj, 0, output);
            output = new LinkedHashMap();
            output.put(RailcraftPartItems.getDustCharcoal(), Float.valueOf(1.0f));
            RailcraftCraftingManager.rockCrusher.addRecipe(up.m.cj, 1, output);
        }
        if (RailcraftConfig.isSubBlockEnabled((typeUtility = EnumMachineAlpha.ROLLING_MACHINE).getTag())) {
            stack = typeUtility.getItem();
            CraftingPlugin.addShapedRecipe(stack, "IPI", "PCP", "IPI", Character.valueOf('I'), up.o, Character.valueOf('P'), amq.ac, Character.valueOf('C'), amq.aB);
            RailcraftLanguage.getInstance().registerItemName(stack, typeUtility.getTag());
        } else {
            this.postInitNotLoaded();
        }
        if (BlockCube.getBlock() != null) {
            ur stack2;
            EnumCube type = EnumCube.STEEL_BLOCK;
            if (RailcraftConfig.isSubBlockEnabled(type.getTag())) {
                stack2 = type.getItem();
                RailcraftLanguage.getInstance().registerItemName(stack2, type.getTag());
                ShapedOreRecipe recipe = new ShapedOreRecipe(stack2, new Object[]{"III", "III", "III", Character.valueOf('I'), "ingotSteel"});
                wn.a().b().add(recipe);
                CraftingPlugin.addShapelessRecipe(RailcraftPartItems.getIngotSteel(9), stack2);
                LootPlugin.addLootTool(stack2.l(), 1, 1, "steel.block");
                OreDictionary.registerOre((String)"blockSteel", (ur)stack2);
                if (EnumMachineAlpha.BLAST_FURNACE.isEnabled()) {
                    RailcraftCraftingManager.blastFurnace.addRecipe(amq.al.cm, 0, 11520, EnumCube.STEEL_BLOCK.getItem());
                }
            }
            if (RailcraftConfig.isSubBlockEnabled((type = EnumCube.CRUSHED_OBSIDIAN).getTag())) {
                stack2 = type.getItem();
                RailcraftLanguage.getInstance().registerItemName(stack2, type.getTag());
                BallastRegistry.registerBallast(BlockCube.getBlock().cm, type.ordinal());
                EntityRegistry.registerModEntity(EntityFallingCube.class, (String)"FallingCube", (int)52, (Object)Railcraft.getMod(), (int)160, (int)20, (boolean)true);
                if (IC2Plugin.isIC2Installed() && RailcraftConfig.addObsidianRecipesToMacerator()) {
                    Ic2Recipes.addMaceratorRecipe(new ur(amq.as), stack2);
                    Ic2Recipes.addMaceratorRecipe(stack2, RailcraftPartItems.getDustObsidian());
                }
            }
        }
    }

    @Override
    public void initSecond() {
        if (ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && BlockCube.getBlock() != null) {
            ur stack;
            if (EnumMachineAlpha.BLAST_FURNACE.isEnabled() && EnumCube.INFERNAL_BRICK.isEnabled()) {
                stack = EnumMachineAlpha.BLAST_FURNACE.getItem(4);
                CraftingPlugin.addShapedRecipe(stack, " B ", "BPB", " B ", Character.valueOf('B'), EnumCube.INFERNAL_BRICK.getItem(), Character.valueOf('P'), up.bx);
            }
            if (EnumMachineAlpha.COKE_OVEN.isEnabled() && EnumCube.SANDY_BRICK.isEnabled()) {
                stack = EnumMachineAlpha.COKE_OVEN.getItem();
                CraftingPlugin.addShapedRecipe(stack, " B ", " S ", " B ", Character.valueOf('B'), EnumCube.SANDY_BRICK.getItem(), Character.valueOf('S'), new ur(amq.H));
            }
        }
    }

    private void registerOreDustRecipe(ur ore, ur dust) {
        if (dust == null) {
            return;
        }
        dust = dust.l();
        dust.a = 2;
        HashMap<ur, Float> output = new HashMap<ur, Float>();
        output.put(dust, Float.valueOf(1.0f));
        RailcraftCraftingManager.rockCrusher.addRecipe(ore, output);
    }

    @Override
    public void postInit() {
        if (OreDictionary.getOres((String)"blockSteel").isEmpty()) {
            OreDictionary.registerOre((String)"blockSteel", (amq)amq.al);
        }
        if (!EnumMachineAlpha.BLAST_FURNACE.isEnabled()) {
            ModuleFactory.registerAltSteelFurnaceRecipe();
        }
        ArrayList logs = OreDictionary.getOres((String)"logWood");
        for (ur log : logs) {
            RailcraftCraftingManager.cokeOven.addRecipe(log, new ur(up.m, 1, 1), LiquidItems.getCreosoteOilLiquid(250), 3000);
        }
        if (IC2Plugin.isIC2Installed()) {
            ur dustIron = IC2Plugin.getItem("ironDust");
            ur dustGold = IC2Plugin.getItem("goldDust");
            ur dustCopper = IC2Plugin.getItem("copperDust");
            ur dustTin = IC2Plugin.getItem("tinDust");
            ur dustSilver = IC2Plugin.getItem("silverDust");
            if (RailcraftConfig.canCrushOres()) {
                this.registerOreDustRecipe(new ur(amq.K), dustIron);
                this.registerOreDustRecipe(new ur(amq.J), dustGold);
                ArrayList ores = OreDictionary.getOres((String)"oreCopper");
                for (ur ore : ores) {
                    this.registerOreDustRecipe(ore, dustCopper);
                }
                ores = OreDictionary.getOres((String)"oreTin");
                for (ur ore : ores) {
                    this.registerOreDustRecipe(ore, dustTin);
                }
                ores = OreDictionary.getOres((String)"oreSilver");
                for (ur ore : ores) {
                    this.registerOreDustRecipe(ore, dustSilver);
                }
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.ores")) {
                IC2Plugin.removeMaceratorDustRecipes(dustIron, dustGold, dustCopper, dustTin, dustSilver);
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.bones")) {
                IC2Plugin.removeMaceratorRecipes(new ur(up.aW, 1, 15));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.blaze")) {
                IC2Plugin.removeMaceratorRecipes(new ur(up.bw));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.cobble")) {
                IC2Plugin.removeMaceratorRecipes(new ur(amq.z));
            }
            if (!RailcraftConfig.getRecipeConfig("ic2.macerator.dirt")) {
                IC2Plugin.removeMaceratorRecipes(new ur(amq.y));
            }
        }
        if (RecipeManagers.carpenterManager != null && RailcraftConfig.getRecipeConfig("forestry.carpenter.ties")) {
            RecipeManagers.carpenterManager.addRecipe(40, LiquidItems.getCreosoteOilLiquid(750), null, RailcraftPartItems.getTieWood(), new Object[]{"###", Character.valueOf('#'), "slabWood"});
        }
    }

    public static int getFuelValues(int id) {
        if (RailcraftToolItems.getCoalCoke() != null && id == RailcraftToolItems.getCoalCoke().c) {
            return 3200;
        }
        return 0;
    }

    private static void registerAltSteelFurnaceRecipe() {
        ArrayList iron = OreDictionary.getOres((String)"nuggetIron");
        for (ur nugget : iron) {
            CraftingPlugin.addFurnaceRecipe(nugget, ItemNugget.getNuggetSteel(), 0.0f);
        }
    }

    @Override
    public void postInitNotLoaded() {
        RollingMachineCraftingManager.copyRecipesToWorkbench();
        ModuleFactory.registerAltSteelFurnaceRecipe();
    }
}

