/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.liquids;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.liquids.ForestryLiquidAdapater;
import railcraft.common.liquids.ForgeLiquidAdapater;
import railcraft.common.liquids.ILiquidAdaptor;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.inventory.InvTools;

public final class LiquidManager
implements ILiquidAdaptor {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int BUCKET_VOLUME = 1000;
    private static LiquidManager instance;
    private List adapters = new ArrayList();

    private LiquidManager() {
        this.adapters.add(ForestryLiquidAdapater.getInstance());
        this.adapters.add(ForgeLiquidAdapater.getInstance());
    }

    public static LiquidManager getInstance() {
        if (instance == null) {
            instance = new LiquidManager();
        }
        return instance;
    }

    public boolean handleRightClick(ITankContainer tank, int tankIndex, qx player, boolean fill, boolean drain) {
        ur current = player.bJ.g();
        if (current != null) {
            ur filled;
            LiquidStack available;
            LiquidStack liquid = this.getLiquidInContainer(current);
            if (fill && liquid != null) {
                int used = tank.fill(tankIndex, liquid, true);
                if (used > 0) {
                    player.bJ.a(player.bJ.c, InvTools.depleteItem(current));
                    return true;
                }
            } else if (drain && (available = tank.getTanks(ForgeDirection.UNKNOWN)[tankIndex].getLiquid()) != null && (liquid = this.getLiquidInContainer(filled = this.fillLiquidContainer(available, current))) != null) {
                if (current.a > 1) {
                    if (!player.bJ.a(filled)) {
                        return false;
                    }
                    player.bJ.a(player.bJ.c, InvTools.depleteItem(current));
                } else {
                    player.bJ.a(player.bJ.c, InvTools.depleteItem(current));
                    player.bJ.a(player.bJ.c, filled);
                }
                tank.drain(tankIndex, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public void processContainers(StandardTank tank, la inv, int inputSlot, int outputSlot) {
        this.processContainers(tank, inv, inputSlot, outputSlot, true, true);
    }

    public void processContainers(StandardTank tank, la inv, int inputSlot, int outputSlot, boolean processFilled, boolean processEmpty) {
        TankManager tankManger = new TankManager();
        tankManger.addTank(tank);
        this.processContainers(tankManger, 0, inv, inputSlot, outputSlot, processFilled, processEmpty);
    }

    public void processContainers(ITankContainer tank, int tankIndex, la inv, int inputSlot, int outputSlot) {
        this.processContainers(tank, tankIndex, inv, inputSlot, outputSlot, true, true);
    }

    public void processContainers(ITankContainer tank, int tankIndex, la inv, int inputSlot, int outputSlot, boolean processFilled, boolean processEmpty) {
        ur input = inv.a(inputSlot);
        ur output = inv.a(outputSlot);
        if (input != null) {
            ur filled;
            LiquidStack bucketLiquid = LiquidManager.getInstance().getLiquidInContainer(input);
            ur emptyItem = input.b().getContainerItemStack(input);
            if (processFilled && bucketLiquid != null && (emptyItem == null || output == null || output.a < output.d() && InvTools.isItemEqual(output, emptyItem))) {
                int used = tank.fill(tankIndex, bucketLiquid, false);
                if (used >= bucketLiquid.amount) {
                    tank.fill(tankIndex, bucketLiquid, true);
                    if (emptyItem != null) {
                        if (output == null) {
                            inv.a(outputSlot, emptyItem);
                        } else {
                            ++output.a;
                        }
                    }
                    inv.a(inputSlot, 1);
                }
            } else if (processEmpty && LiquidManager.getInstance().isEmptyContainer(input) && (filled = LiquidManager.getInstance().fillLiquidContainer(tank.getTanks(ForgeDirection.UNKNOWN)[tankIndex].getLiquid(), input)) != null && (output == null || output.a < output.d() && InvTools.isItemEqual(filled, output))) {
                LiquidStack liquid = LiquidManager.getInstance().getLiquidInContainer(filled);
                LiquidStack drain = tank.drain(tankIndex, liquid.amount, false);
                if (drain != null && drain.amount > 0) {
                    tank.drain(tankIndex, liquid.amount, true);
                    if (output == null) {
                        inv.a(outputSlot, filled);
                    } else {
                        ++output.a;
                    }
                    inv.a(inputSlot, 1);
                }
            }
        }
    }

    public boolean isBucket(ur stack) {
        return LiquidContainerRegistry.isBucket((ur)stack);
    }

    public boolean isContainer(ur stack) {
        return LiquidContainerRegistry.isContainer((ur)stack);
    }

    public boolean isFilledContainer(ur stack) {
        return LiquidContainerRegistry.isFilledContainer((ur)stack);
    }

    public boolean isEmptyContainer(ur stack) {
        return LiquidContainerRegistry.isEmptyContainer((ur)stack);
    }

    public ur fillLiquidContainer(LiquidStack liquid, ur empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        return LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (ur)empty);
    }

    public ur getFilledLiquidContainer(LiquidStack liquid, ur empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        liquid = liquid.copy();
        liquid.amount = Integer.MAX_VALUE;
        return LiquidContainerRegistry.fillLiquidContainer((LiquidStack)liquid, (ur)empty);
    }

    public LiquidStack getLiquidInContainer(ur stack) {
        return LiquidContainerRegistry.getLiquidForFilledItem((ur)stack);
    }

    public boolean containsLiquid(ur stack, LiquidStack liquid) {
        return LiquidContainerRegistry.containsLiquid((ur)stack, (LiquidStack)liquid);
    }

    public boolean isLiquidEqual(LiquidStack L1, LiquidStack L2) {
        if (L1 == null || L2 == null) {
            return false;
        }
        return L1.isLiquidEqual(L2);
    }

    public void registerBucket(LiquidStack liquid, ur filled) {
        ur empty = new ur(up.aw);
        LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
        this.registerContainer(container);
    }

    public boolean registerWax(LiquidStack liquid, ur filled) {
        ur empty = ForestryLiquidAdapater.getInstance().waxCapsule;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public boolean registerRefactory(LiquidStack liquid, ur filled) {
        ur empty = ForestryLiquidAdapater.getInstance().refractoryEmpty;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public boolean registerCan(LiquidStack liquid, ur filled) {
        ur empty = ForestryLiquidAdapater.getInstance().canEmpty;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public boolean registerCell(LiquidStack liquid, ur filled) {
        ur empty = ForestryLiquidAdapater.getInstance().cellEmpty;
        if (empty != null) {
            LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
            this.registerContainer(container);
            return true;
        }
        return false;
    }

    public void registerBottle(LiquidStack liquid, ur filled) {
        ur empty = new ur(up.bt);
        LiquidContainerData container = new LiquidContainerData(liquid, filled, empty);
        this.registerContainer(container);
    }

    @Override
    public void registerContainer(LiquidContainerData container) {
        for (ILiquidAdaptor adapter : this.adapters) {
            adapter.registerContainer(container);
        }
    }
}

