/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.liquids;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.api.fuel.FuelManager;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.ItemLiquid;
import railcraft.common.liquids.ItemLiquidContainer;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.plugins.forge.CreativePlugin;
import railcraft.common.plugins.forge.LootPlugin;

public abstract class LiquidItems {
    private static LiquidStack liquidCreosoteOil;
    private static LiquidStack liquidSteam;
    private static up itemCreosoteOil;
    private static up itemSteam;
    private static up itemCreosoteOilBucket;
    private static up itemCreosoteOilBottle;
    private static up itemSteamBottle;
    private static ItemLiquidContainer itemCreosoteOilCell;
    private static ItemLiquidContainer itemCreosoteOilCan;
    private static ItemLiquidContainer itemCreosoteOilWax;
    private static ItemLiquidContainer itemCreosoteOilRefactory;

    public static void initialize() {
        LiquidItems.initCreosoteOil();
        LiquidItems.initSteam();
    }

    public static ur getCreosoteOil() {
        LiquidItems.initCreosoteOil();
        return new ur(itemCreosoteOil);
    }

    private static void initCreosoteOil() {
        if (itemCreosoteOil == null) {
            String tag = "rc.liquid.creosote.liquid";
            int id = RailcraftConfig.getItemId(tag);
            up item = new ItemLiquid(id).setRarity(1).c(0).b(tag);
            GameRegistry.registerItem((up)item, (String)tag);
            RailcraftLanguage.getInstance().registerItemName(item, tag);
            liquidCreosoteOil = LiquidDictionary.getOrCreateLiquid((String)"Creosote Oil", (LiquidStack)new LiquidStack(item.cj, 0));
            ItemRegistry.registerItem(tag, new ur(item));
            LiquidStack liquid = liquidCreosoteOil.copy();
            liquid.amount = 1000;
            FuelManager.addBoilerFuel(liquid, 3200);
            itemCreosoteOil = item;
        }
    }

    public static LiquidStack getCreosoteOilLiquid(int qty) {
        LiquidItems.initCreosoteOil();
        LiquidStack liquid = liquidCreosoteOil.copy();
        liquid.amount = qty;
        return liquid;
    }

    public static ur getCreosoteOilBucket() {
        up item = itemCreosoteOilBucket;
        if (item == null) {
            String tag = "rc.liquid.creosote.bucket";
            int id = RailcraftConfig.getItemId(tag);
            item = new ItemLiquidContainer(id).c(1).b(tag).d(1).a(up.aw).a(CreativePlugin.TAB);
            GameRegistry.registerItem((up)item, (String)tag);
            RailcraftLanguage.getInstance().registerItemName(item, tag);
            LiquidManager.getInstance().registerBucket(LiquidItems.getCreosoteOilLiquid(1000), new ur(item));
            ItemRegistry.registerItem(tag, new ur(item));
            itemCreosoteOilBucket = item;
        }
        return new ur(item);
    }

    public static ur getCreosoteOilBottle() {
        return LiquidItems.getCreosoteOilBottle(1);
    }

    public static ur getCreosoteOilBottle(int qty) {
        up item = itemCreosoteOilBottle;
        if (item == null) {
            String tag = "rc.liquid.creosote.bottle";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id).c(2).b(tag).a(CreativePlugin.TAB);
                GameRegistry.registerItem((up)item, (String)tag);
                RailcraftLanguage.getInstance().registerItemName(item, tag);
                LootPlugin.addLootMineshaft(new ur(item), 4, 16, "creosote.bottle");
                LiquidManager.getInstance().registerBottle(LiquidItems.getCreosoteOilLiquid(1000), new ur(item));
                ItemRegistry.registerItem(tag, new ur(item));
                itemCreosoteOilBottle = item;
            } else {
                return null;
            }
        }
        return new ur(item, qty);
    }

    public static ur getCreosoteOilCan() {
        return LiquidItems.getCreosoteOilCan(1);
    }

    public static ur getCreosoteOilCan(int qty) {
        ItemLiquidContainer item = itemCreosoteOilCan;
        if (item == null) {
            String tag = "rc.liquid.creosote.can";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.c(3);
                item.b(tag);
                GameRegistry.registerItem((up)item, (String)tag);
                RailcraftLanguage.getInstance().registerItemName((Object)item, tag);
                boolean forestry = LiquidManager.getInstance().registerCan(LiquidItems.getCreosoteOilLiquid(1000), new ur((up)item));
                if (forestry) {
                    item.a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ur((up)item));
                itemCreosoteOilCan = item;
            } else {
                return null;
            }
        }
        return new ur((up)item, qty);
    }

    public static ur getCreosoteOilWax() {
        return LiquidItems.getCreosoteOilWax(1);
    }

    public static ur getCreosoteOilWax(int qty) {
        ItemLiquidContainer item = itemCreosoteOilWax;
        if (item == null) {
            String tag = "rc.liquid.creosote.wax";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.c(4);
                item.b(tag);
                GameRegistry.registerItem((up)item, (String)tag);
                RailcraftLanguage.getInstance().registerItemName((Object)item, tag);
                boolean forestry = LiquidManager.getInstance().registerWax(LiquidItems.getCreosoteOilLiquid(1000), new ur((up)item));
                if (forestry) {
                    item.a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ur((up)item));
                itemCreosoteOilWax = item;
            } else {
                return null;
            }
        }
        return new ur((up)item, qty);
    }

    public static ur getCreosoteOilRefactory() {
        return LiquidItems.getCreosoteOilRefactory(1);
    }

    public static ur getCreosoteOilRefactory(int qty) {
        ItemLiquidContainer item = itemCreosoteOilRefactory;
        if (item == null) {
            String tag = "rc.liquid.creosote.refactory";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.c(5);
                item.b(tag);
                GameRegistry.registerItem((up)item, (String)tag);
                RailcraftLanguage.getInstance().registerItemName((Object)item, tag);
                boolean forestry = LiquidManager.getInstance().registerRefactory(LiquidItems.getCreosoteOilLiquid(1000), new ur((up)item));
                if (forestry) {
                    item.a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ur((up)item));
                itemCreosoteOilRefactory = item;
            } else {
                return null;
            }
        }
        return new ur((up)item, qty);
    }

    public static ur getCreosoteOilCell() {
        return LiquidItems.getCreosoteOilCell(1);
    }

    public static ur getCreosoteOilCell(int qty) {
        ItemLiquidContainer item = itemCreosoteOilCell;
        if (item == null) {
            String tag = "rc.liquid.creosote.cell";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemLiquidContainer(id);
                item.c(6);
                item.b(tag);
                GameRegistry.registerItem((up)item, (String)tag);
                RailcraftLanguage.getInstance().registerItemName((Object)item, tag);
                boolean ic2 = LiquidManager.getInstance().registerCell(LiquidItems.getCreosoteOilLiquid(1000), new ur((up)item));
                if (ic2) {
                    item.a(CreativePlugin.TAB);
                }
                ItemRegistry.registerItem(tag, new ur((up)item));
                itemCreosoteOilCell = item;
            } else {
                return null;
            }
        }
        return new ur((up)item, qty);
    }

    public static ur getSteam() {
        LiquidItems.initSteam();
        return new ur(itemSteam);
    }

    private static void initSteam() {
        String tag;
        int id;
        if (itemSteam == null && (id = RailcraftConfig.getItemId(tag = "rc.liquid.steam")) > 0) {
            up item = new ItemLiquid(id).setRarity(0).c(16).b(tag);
            GameRegistry.registerItem((up)item, (String)tag);
            RailcraftLanguage.getInstance().registerItemName(item, tag);
            liquidSteam = LiquidDictionary.getOrCreateLiquid((String)"Steam", (LiquidStack)new LiquidStack(item.cj, 0));
            ItemRegistry.registerItem(tag, new ur(item));
            itemSteam = item;
        }
    }

    public static LiquidStack getSteamLiquid() {
        return LiquidItems.getSteamLiquid(0);
    }

    public static LiquidStack getSteamLiquid(int qty) {
        LiquidItems.initSteam();
        LiquidStack liquid = liquidSteam.copy();
        liquid.amount = qty;
        return liquid;
    }
}

