/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import ic2.api.Ic2Recipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.blocks.ore.ItemDust;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.ItemPlate;
import railcraft.common.items.ItemRail;
import railcraft.common.items.ItemRailbed;
import railcraft.common.items.ItemRailcraft;
import railcraft.common.items.ItemTie;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.plugins.forestry.ForestryPlugin;
import railcraft.common.plugins.forge.CraftingPlugin;
import railcraft.common.plugins.forge.LootPlugin;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.crafting.RollingMachineCraftingManager;
import railcraft.common.util.misc.EnumColor;
import railcraft.common.util.misc.MiscTools;

public class RailcraftPartItems {
    public static up itemRail;
    public static up itemTie;
    public static up itemRailbed;
    private static up itemRebar;
    private static up itemPlate;
    private static up itemIngotSteel;
    private static up itemDust;
    private static up itemNugget;
    private static up itemTurbineBlade;
    private static up itemTurbineDisk;
    private static up itemTurbineRotor;
    public static up itemSignalLamp;

    public static void registerItem(String tag, ur stack) {
        tag = MiscTools.cleanTag(tag);
        ItemRegistry.registerItem(tag, stack);
    }

    private static up getRailItem() {
        if (itemRail != null) {
            return itemRail;
        }
        String tag = "rc.part.rail";
        int id = RailcraftConfig.getItemId(tag);
        ItemRail item = new ItemRail(id);
        GameRegistry.registerItem((up)item, (String)tag);
        itemRail = item;
        item.defineRecipes();
        for (int meta = 0; meta < 5; ++meta) {
            ur stack = new ur(itemRail, 1, meta);
            RailcraftLanguage.getInstance().registerItemName(stack, itemRail.d(stack));
            RailcraftPartItems.registerItem(itemRail.d(stack), stack);
        }
        return itemRail;
    }

    public static ur getRailStandard() {
        return RailcraftPartItems.getRailStandard(1);
    }

    public static ur getRailStandard(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ur(up.o, qty);
        }
        return new ur(RailcraftPartItems.getRailItem(), qty, 0);
    }

    public static ur getRailAdvanced() {
        return RailcraftPartItems.getRailAdvanced(1);
    }

    public static ur getRailAdvanced(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ur(up.p, qty);
        }
        return new ur(RailcraftPartItems.getRailItem(), qty, 1);
    }

    public static ur getRailWood() {
        return RailcraftPartItems.getRailWood(1);
    }

    public static ur getRailWood(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ur((amq)amq.bR, 1);
        }
        return new ur(RailcraftPartItems.getRailItem(), qty, 2);
    }

    public static ur getRailSpeed() {
        return RailcraftPartItems.getRailSpeed(1);
    }

    public static ur getRailSpeed(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return RailcraftPartItems.getIngotSteel(qty);
        }
        return new ur(RailcraftPartItems.getRailItem(), qty, 3);
    }

    public static ur getRailReinforced() {
        return RailcraftPartItems.getRailReinforced(1);
    }

    public static ur getRailReinforced(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return RailcraftPartItems.getIngotSteel(qty);
        }
        return new ur(RailcraftPartItems.getRailItem(), qty, 4);
    }

    public static ur getRebar() {
        return RailcraftPartItems.getRebar(1);
    }

    public static ur getRebar(int qty) {
        up item = itemRebar;
        if (item != null) {
            return new ur(item, qty);
        }
        String tag = "rc.part.rebar";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return new ur(up.o, qty);
        }
        item = new ItemRailcraft(id).c(153).b(tag);
        GameRegistry.registerItem((up)item, (String)tag);
        ur stack = new ur(item);
        RailcraftLanguage.getInstance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        RailcraftCraftingManager.rollingMachine.addRecipe(new ur(item, 4), new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), new ur(up.o)});
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ur(item, 4), new Object[]{true, new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotBronze"}});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        recipe = new ShapedOreRecipe(new ur(item, 6), new Object[]{true, new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotRefinedIron"}});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        recipe = new ShapedOreRecipe(new ur(item, 8), new Object[]{true, new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotSteel"}});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        itemRebar = item;
        return new ur(item, qty);
    }

    private static up getPlateItem() {
        if (itemPlate != null) {
            return itemPlate;
        }
        String tag = "rc.part.plate";
        int id = RailcraftConfig.getItemId(tag);
        itemPlate = new ItemPlate(id);
        GameRegistry.registerItem((up)itemPlate, (String)tag);
        for (int meta = 0; meta < 3; ++meta) {
            ur stack = new ur(itemPlate, 1, meta);
            RailcraftLanguage.getInstance().registerItemName(stack, itemPlate.d(stack));
            RailcraftPartItems.registerItem(itemPlate.d(stack), stack);
        }
        return itemPlate;
    }

    public static ur getPlateIron() {
        return RailcraftPartItems.getPlateIron(1);
    }

    public static ur getPlateIron(int qty) {
        return new ur(RailcraftPartItems.getPlateItem(), qty, 0);
    }

    public static ur getPlateSteel() {
        return RailcraftPartItems.getPlateSteel(1);
    }

    public static ur getPlateSteel(int qty) {
        return new ur(RailcraftPartItems.getPlateItem(), qty, 1);
    }

    public static ur getPlateTin() {
        return RailcraftPartItems.getPlateTin(1);
    }

    public static ur getPlateTin(int qty) {
        return new ur(RailcraftPartItems.getPlateItem(), qty, 2);
    }

    private static up getTieItem() {
        if (itemTie != null) {
            return itemTie;
        }
        String tag = "rc.part.tie";
        int id = RailcraftConfig.getItemId(tag);
        itemTie = new ItemTie(id);
        GameRegistry.registerItem((up)itemTie, (String)tag);
        for (int meta = 0; meta < 2; ++meta) {
            ur stack = new ur(itemTie, 1, meta);
            RailcraftLanguage.getInstance().registerItemName(stack, itemTie.d(stack));
            RailcraftPartItems.registerItem(itemTie.d(stack), stack);
        }
        ur tieWood = RailcraftPartItems.getTieWood();
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), LiquidItems.getCreosoteOilBucket(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), LiquidItems.getCreosoteOilBottle(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), LiquidItems.getCreosoteOilCan(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), LiquidItems.getCreosoteOilWax(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), LiquidItems.getCreosoteOilRefactory(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), LiquidItems.getCreosoteOilCell(), Character.valueOf('#'), "slabWood");
        LootPlugin.addLootMineshaft(tieWood, 4, 16, "tie.wood");
        ur tieStone = RailcraftPartItems.getTieStone();
        CraftingPlugin.addShapedRecipe(tieStone, " O ", "###", Character.valueOf('O'), RailcraftPartItems.getRebar(), Character.valueOf('#'), new ur((amq)amq.an, 1, 0));
        return itemTie;
    }

    public static ur getTieWood() {
        return RailcraftPartItems.getTieWood(1);
    }

    public static ur getTieWood(int qty) {
        return new ur(RailcraftPartItems.getTieItem(), qty, 0);
    }

    public static ur getTieStone() {
        return RailcraftPartItems.getTieStone(1);
    }

    public static ur getTieStone(int qty) {
        return new ur(RailcraftPartItems.getTieItem(), qty, 1);
    }

    private static up getRailbedItem() {
        if (itemRailbed != null) {
            return itemRailbed;
        }
        String tag = "rc.part.railbed";
        int id = RailcraftConfig.getItemId(tag);
        itemRailbed = new ItemRailbed(id);
        GameRegistry.registerItem((up)itemRailbed, (String)tag);
        for (int meta = 0; meta < 2; ++meta) {
            ur stack = new ur(itemRailbed, 1, meta);
            RailcraftLanguage.getInstance().registerItemName(stack, itemRailbed.d(stack));
            RailcraftPartItems.registerItem(itemRailbed.d(stack), stack);
        }
        ur output = new ur(itemRailbed, 1, 0);
        wn.a().b(output, new Object[]{RailcraftPartItems.getTieWood(), RailcraftPartItems.getTieWood(), RailcraftPartItems.getTieWood(), RailcraftPartItems.getTieWood()});
        output = new ur(itemRailbed, 1, 1);
        wn.a().b(output, new Object[]{RailcraftPartItems.getTieStone(), RailcraftPartItems.getTieStone(), RailcraftPartItems.getTieStone(), RailcraftPartItems.getTieStone()});
        return itemRailbed;
    }

    public static ur getRailbedWood() {
        return RailcraftPartItems.getRailbedWood(1);
    }

    public static ur getRailbedWood(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ur(up.D, qty);
        }
        return new ur(RailcraftPartItems.getRailbedItem(), qty, 0);
    }

    public static ur getRailbedStone() {
        return RailcraftPartItems.getRailbedStone(1);
    }

    public static ur getRailbedStone(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ur((amq)amq.an, 1, 0);
        }
        return new ur(RailcraftPartItems.getRailbedItem(), qty, 1);
    }

    public static ur getIngotSteel() {
        return RailcraftPartItems.getIngotSteel(1);
    }

    public static ur getIngotSteel(int qty) {
        up item = itemIngotSteel;
        if (item != null) {
            return new ur(item, qty);
        }
        String tag = "rc.part.ingot.steel";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return new ur(up.o, qty);
        }
        item = new ItemRailcraft(id).setSmeltingExperiance(1.0f).c(181).b(tag);
        GameRegistry.registerItem((up)item, (String)tag);
        ur stack = new ur(item);
        RailcraftLanguage.getInstance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        itemIngotSteel = item;
        OreDictionary.registerOre((String)"ingotSteel", (ur)new ur(item));
        LootPlugin.addLootTool(new ur(item), 5, 9, "steel.ingot");
        return new ur(item, qty);
    }

    private static up getDustItem() {
        if (itemDust != null) {
            return itemDust;
        }
        String tag = "rc.dust";
        int id = RailcraftConfig.getItemId(tag);
        itemDust = new ItemDust(id);
        GameRegistry.registerItem((up)itemDust, (String)tag);
        for (ItemDust.EnumDust dust : ItemDust.EnumDust.values()) {
            ur stack = new ur(itemDust, 1, dust.ordinal());
            RailcraftLanguage.getInstance().registerItemName(stack, itemDust.d(stack));
            RailcraftPartItems.registerItem(itemDust.d(stack), stack);
            ForestryPlugin.addBackpackItem("miner", stack);
        }
        OreDictionary.registerOre((String)"dustObsidian", (ur)new ur(itemDust, 1, ItemDust.EnumDust.OBSIDIAN.ordinal()));
        OreDictionary.registerOre((String)"dustSulfur", (ur)new ur(itemDust, 1, ItemDust.EnumDust.SULFUR.ordinal()));
        OreDictionary.registerOre((String)"dustSaltpeter", (ur)new ur(itemDust, 1, ItemDust.EnumDust.SALTPETER.ordinal()));
        OreDictionary.registerOre((String)"dustCharcoal", (ur)new ur(itemDust, 1, ItemDust.EnumDust.CHARCOAL.ordinal()));
        if (IC2Plugin.isIC2Installed() && RailcraftConfig.getRecipeConfig("ic2.macerator.charcoal")) {
            Ic2Recipes.addMaceratorRecipe(new ur(up.m, 1, 1), new ur(itemDust, 1, ItemDust.EnumDust.CHARCOAL.ordinal()));
        }
        return itemDust;
    }

    public static ur getDustObsidian() {
        return RailcraftPartItems.getDustObsidian(1);
    }

    public static ur getDustObsidian(int qty) {
        return new ur(RailcraftPartItems.getDustItem(), qty, ItemDust.EnumDust.OBSIDIAN.ordinal());
    }

    public static ur getDustSulfur() {
        return RailcraftPartItems.getDustSulfur(1);
    }

    public static ur getDustSulfur(int qty) {
        return new ur(RailcraftPartItems.getDustItem(), qty, ItemDust.EnumDust.SULFUR.ordinal());
    }

    public static ur getDustSaltpeter() {
        return RailcraftPartItems.getDustSaltpeter(1);
    }

    public static ur getDustSaltpeter(int qty) {
        return new ur(RailcraftPartItems.getDustItem(), qty, ItemDust.EnumDust.SALTPETER.ordinal());
    }

    public static ur getDustCharcoal() {
        return RailcraftPartItems.getDustCharcoal(1);
    }

    public static ur getDustCharcoal(int qty) {
        return new ur(RailcraftPartItems.getDustItem(), qty, ItemDust.EnumDust.CHARCOAL.ordinal());
    }

    public static ur getTurbineBlade() {
        return RailcraftPartItems.getTurbineBlade(1);
    }

    public static ur getTurbineBlade(int qty) {
        up item = itemTurbineBlade;
        if (item != null) {
            return new ur(item, qty);
        }
        String tag = "rc.part.turbine.blade";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return RailcraftPartItems.getIngotSteel(qty);
        }
        item = new ItemRailcraft(id).c(39).b(tag);
        GameRegistry.registerItem((up)item, (String)tag);
        ur stack = new ur(item);
        RailcraftLanguage.getInstance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        CraftingPlugin.addShapedOreRecipe(stack, "I", "I", "I", Character.valueOf('I'), "ingotSteel");
        itemTurbineBlade = item;
        return new ur(item, qty);
    }

    public static ur getTurbineDisk() {
        return RailcraftPartItems.getTurbineDisk(1);
    }

    public static ur getTurbineDisk(int qty) {
        up item = itemTurbineDisk;
        if (item != null) {
            return new ur(item, qty);
        }
        String tag = "rc.part.turbine.disk";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return null;
        }
        item = new ItemRailcraft(id).c(40).b(tag);
        GameRegistry.registerItem((up)item, (String)tag);
        ur stack = new ur(item);
        RailcraftLanguage.getInstance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        ur blade = RailcraftPartItems.getTurbineBlade();
        if (blade != null) {
            CraftingPlugin.addShapedOreRecipe(stack, "BBB", "BAB", "BBB", Character.valueOf('A'), "blockSteel", Character.valueOf('B'), blade);
        }
        itemTurbineDisk = item;
        return new ur(item, qty);
    }

    public static ur getTurbineRotor() {
        return RailcraftPartItems.getTurbineRotor(1);
    }

    public static ur getTurbineRotor(int qty) {
        up item = itemTurbineRotor;
        if (item != null) {
            return new ur(item, qty);
        }
        String tag = "rc.part.turbine.rotor";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return null;
        }
        item = new ItemRailcraft(id).c(24).b(tag);
        item.e(30000).d(1);
        GameRegistry.registerItem((up)item, (String)tag);
        ur stack = new ur(item);
        RailcraftLanguage.getInstance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        ur disk = RailcraftPartItems.getTurbineDisk();
        if (disk != null) {
            CraftingPlugin.addShapedRecipe(stack, "DDD", Character.valueOf('D'), disk);
        }
        itemTurbineRotor = item;
        return new ur(item, qty);
    }

    public static ur getSignalLamp() {
        return RailcraftPartItems.getSignalLamp(1);
    }

    public static ur getSignalLamp(int qty) {
        up item = itemSignalLamp;
        if (item != null) {
            return new ur(item, qty);
        }
        String tag = "rc.part.signal.lamp";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return new ur(amq.bO, qty);
        }
        item = itemSignalLamp = new ItemRailcraft(id).c(134).b(tag);
        GameRegistry.registerItem((up)item, (String)tag);
        ur stackSignalLamp = new ur(item);
        RailcraftLanguage.getInstance().registerItemName(stackSignalLamp, tag);
        CraftingPlugin.addShapedOreRecipe(stackSignalLamp, "PG ", "PYT", "PRS", Character.valueOf('G'), EnumColor.LIME.getDye(), Character.valueOf('Y'), EnumColor.YELLOW.getDye(), Character.valueOf('R'), EnumColor.RED.getDye(), Character.valueOf('S'), up.aC, Character.valueOf('T'), up.aT, Character.valueOf('P'), amq.bt);
        ItemRegistry.registerItem(tag, stackSignalLamp);
        return new ur(item, qty);
    }
}

