/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.gui.containers;

import java.util.logging.Level;
import railcraft.common.blocks.detector.TileDetectorAdvanced;
import railcraft.common.blocks.detector.TileDetectorItem;
import railcraft.common.blocks.detector.TileDetectorLocomotive;
import railcraft.common.blocks.detector.TileDetectorSheep;
import railcraft.common.blocks.detector.TileDetectorTank;
import railcraft.common.blocks.machine.ITankTile;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import railcraft.common.blocks.machine.alpha.TileBlastFurnace;
import railcraft.common.blocks.machine.alpha.TileCokeOven;
import railcraft.common.blocks.machine.alpha.TileFeedStation;
import railcraft.common.blocks.machine.alpha.TileRockCrusher;
import railcraft.common.blocks.machine.alpha.TileRollingMachine;
import railcraft.common.blocks.machine.alpha.TileSteamOven;
import railcraft.common.blocks.machine.alpha.TileSteamTurbine;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxLiquid;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid;
import railcraft.common.blocks.machine.beta.TileEngineSteam;
import railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import railcraft.common.blocks.machine.gamma.TileDispenserCart;
import railcraft.common.blocks.machine.gamma.TileDispenserTrain;
import railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import railcraft.common.blocks.machine.gamma.TileLiquidUnloader;
import railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import railcraft.common.carts.EntityCartAnchor;
import railcraft.common.carts.EntityCartEnergy;
import railcraft.common.carts.EntityCartTank;
import railcraft.common.carts.EntityCartTrackRelayer;
import railcraft.common.carts.EntityCartUndercutter;
import railcraft.common.carts.EntityCartWork;
import railcraft.common.carts.EntityLocomotiveSteam;
import railcraft.common.carts.EntityTunnelBore;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.containers.ContainerAnchor;
import railcraft.common.gui.containers.ContainerBlastFurnace;
import railcraft.common.gui.containers.ContainerBoilerLiquid;
import railcraft.common.gui.containers.ContainerBoilerSolid;
import railcraft.common.gui.containers.ContainerBore;
import railcraft.common.gui.containers.ContainerCartEnergy;
import railcraft.common.gui.containers.ContainerCokeOven;
import railcraft.common.gui.containers.ContainerDetectorAdvanced;
import railcraft.common.gui.containers.ContainerDetectorItem;
import railcraft.common.gui.containers.ContainerDetectorLocomotive;
import railcraft.common.gui.containers.ContainerDetectorSheep;
import railcraft.common.gui.containers.ContainerDetectorTank;
import railcraft.common.gui.containers.ContainerDispenserCart;
import railcraft.common.gui.containers.ContainerDispenserTrain;
import railcraft.common.gui.containers.ContainerEnergyLoader;
import railcraft.common.gui.containers.ContainerEngineSteam;
import railcraft.common.gui.containers.ContainerEngineSteamHobby;
import railcraft.common.gui.containers.ContainerFeedStation;
import railcraft.common.gui.containers.ContainerItemLoader;
import railcraft.common.gui.containers.ContainerLiquidLoader;
import railcraft.common.gui.containers.ContainerLiquidUnloader;
import railcraft.common.gui.containers.ContainerLocomotiveSteam;
import railcraft.common.gui.containers.ContainerRockCrusher;
import railcraft.common.gui.containers.ContainerRollingMachine;
import railcraft.common.gui.containers.ContainerSteamOven;
import railcraft.common.gui.containers.ContainerTank;
import railcraft.common.gui.containers.ContainerTankCart;
import railcraft.common.gui.containers.ContainerTrackRelayer;
import railcraft.common.gui.containers.ContainerTurbine;
import railcraft.common.gui.containers.ContainerUndercutter;
import railcraft.common.gui.containers.ContainerWorkCart;
import railcraft.common.util.misc.Game;

public class FactoryContainer {
    public static rq build(EnumGui gui, qw inv, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TileMultiBlock && !((TileMultiBlock)obj).isStructureValid()) {
            return null;
        }
        try {
            switch (gui) {
                case LOADER_ITEM: {
                    return new ContainerItemLoader(inv, (TileLoaderItemBase)obj);
                }
                case LOADER_LIQUID: {
                    return new ContainerLiquidLoader(inv, (TileLiquidLoader)obj);
                }
                case UNLOADER_LIQUID: {
                    return new ContainerLiquidUnloader(inv, (TileLiquidUnloader)obj);
                }
                case LOADER_ENERGY: {
                    return new ContainerEnergyLoader(inv, (TileEnergyLoader)obj);
                }
                case UNLOADER_ENERGY: {
                    return new ContainerEnergyLoader(inv, (TileEnergyUnloader)obj);
                }
                case DETECTOR_ITEM: {
                    return new ContainerDetectorItem(inv, (TileDetectorItem)obj);
                }
                case DETECTOR_TANK: {
                    return new ContainerDetectorTank(inv, (TileDetectorTank)obj);
                }
                case DETECTOR_SHEEP: {
                    return new ContainerDetectorSheep(inv, (TileDetectorSheep)obj);
                }
                case DETECTOR_ADVANCED: {
                    return new ContainerDetectorAdvanced(inv, (TileDetectorAdvanced)obj);
                }
                case DETECTOR_LOCOMOTIVE: {
                    return new ContainerDetectorLocomotive(inv, (TileDetectorLocomotive)obj);
                }
                case CART_DISPENSER: {
                    return new ContainerDispenserCart(inv, (TileDispenserCart)obj);
                }
                case TRAIN_DISPENSER: {
                    return new ContainerDispenserTrain(inv, (TileDispenserTrain)obj);
                }
                case COKE_OVEN: {
                    return new ContainerCokeOven(inv, (TileCokeOven)obj);
                }
                case BLAST_FURNACE: {
                    return new ContainerBlastFurnace(inv, (TileBlastFurnace)obj);
                }
                case STEAN_OVEN: {
                    return new ContainerSteamOven(inv, (TileSteamOven)obj);
                }
                case ROCK_CRUSHER: {
                    return new ContainerRockCrusher(inv, (TileRockCrusher)obj);
                }
                case TANK: {
                    return new ContainerTank(inv, (ITankTile)obj);
                }
                case ROLLING_MACHINE: {
                    return new ContainerRollingMachine(inv, (TileRollingMachine)obj);
                }
                case FEED_STATION: {
                    return new ContainerFeedStation(inv, (TileFeedStation)obj);
                }
                case WORLD_ANCHOR: {
                    return new ContainerAnchor(inv, (TileAnchorWorld)obj);
                }
                case ENGINE_STEAM: {
                    return new ContainerEngineSteam(inv, (TileEngineSteam)obj);
                }
                case ENGINE_HOBBY: {
                    return new ContainerEngineSteamHobby(inv, (TileEngineSteamHobby)obj);
                }
                case BOILER_SOLID: {
                    return new ContainerBoilerSolid(inv, (TileBoilerFireboxSolid)obj);
                }
                case BOILER_LIQUID: {
                    return new ContainerBoilerLiquid(inv, (TileBoilerFireboxLiquid)obj);
                }
                case TURBINE: {
                    return new ContainerTurbine(inv, (TileSteamTurbine)obj);
                }
                case CART_BORE: {
                    return new ContainerBore(inv, (EntityTunnelBore)obj);
                }
                case CART_ENERGY: {
                    return new ContainerCartEnergy(inv, (EntityCartEnergy)obj);
                }
                case CART_TANK: {
                    return new ContainerTankCart(inv, (EntityCartTank)obj);
                }
                case CART_ANCHOR: {
                    return new ContainerAnchor(inv, (EntityCartAnchor)obj);
                }
                case CART_WORK: {
                    return new ContainerWorkCart(inv, (EntityCartWork)obj);
                }
                case CART_TRACK_RELAYER: {
                    return new ContainerTrackRelayer(inv, (EntityCartTrackRelayer)obj);
                }
                case CART_UNDERCUTTER: {
                    return new ContainerUndercutter(inv, (EntityCartUndercutter)obj);
                }
                case LOCO_STEAM: {
                    return new ContainerLocomotiveSteam(inv, (EntityLocomotiveSteam)obj);
                }
            }
            return null;
        }
        catch (ClassCastException ex) {
            Game.log(Level.WARNING, "Error when attempting to build gui container {0}: {1}", new Object[]{gui, ex});
            return null;
        }
    }
}

