/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxLiquid;
import railcraft.common.gui.containers.RailcraftContainer;
import railcraft.common.gui.indicator.Indicator;
import railcraft.common.gui.slots.SlotLiquidContainerFilled;
import railcraft.common.gui.slots.SlotOutput;
import railcraft.common.liquids.LiquidGauge;
import railcraft.common.liquids.TankManager;

public class ContainerBoilerLiquid
extends RailcraftContainer {
    private TileBoilerFireboxLiquid tile;
    private sr input;
    private sr output;
    private float lastBurnTime;
    private float lastItemBurnTime;
    private float lastHeat;

    public ContainerBoilerLiquid(qw inventoryplayer, TileBoilerFireboxLiquid tile) {
        super(tile);
        this.tile = tile;
        this.addGauge(new LiquidGauge(tile.getTanks(null)[0], 116, 23, 16, 47));
        this.addGauge(new LiquidGauge(tile.getTanks(null)[1], 17, 23, 16, 47));
        this.addGauge(new LiquidGauge(tile.getTanks(null)[2], 89, 23, 16, 47));
        this.addIndicator(new Indicator(tile.getHeatIndicator(), 40, 25, 6, 43, 176, 61));
        this.input = new SlotLiquidContainerFilled(tile, 0, 143, 21);
        this.addSlot(this.input);
        this.output = new SlotOutput(tile, 1, 143, 56);
        this.addSlot(this.output);
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new sr((la)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new sr((la)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    public void a(rw icrafting) {
        super.a(icrafting);
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
            tMan.initGuiData(this, icrafting, 1);
            tMan.initGuiData(this, icrafting, 2);
        }
        icrafting.a((rq)this, 10, Math.round(this.tile.burnTime));
        icrafting.a((rq)this, 11, Math.round(this.tile.currentItemBurnTime));
        icrafting.a((rq)this, 12, Math.round(this.tile.heat));
    }

    public void b() {
        super.b();
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.e, 0);
            tMan.updateGuiData(this, this.e, 1);
            tMan.updateGuiData(this, this.e, 2);
        }
        for (int var1 = 0; var1 < this.e.size(); ++var1) {
            rw var2 = (rw)this.e.get(var1);
            if (this.lastBurnTime != this.tile.burnTime) {
                var2.a((rq)this, 10, Math.round(this.tile.burnTime));
            }
            if (this.lastItemBurnTime != this.tile.currentItemBurnTime) {
                var2.a((rq)this, 11, Math.round(this.tile.currentItemBurnTime));
            }
            if (this.lastHeat == this.tile.heat) continue;
            var2.a((rq)this, 12, Math.round(this.tile.heat));
        }
        this.lastBurnTime = this.tile.burnTime;
        this.lastItemBurnTime = this.tile.currentItemBurnTime;
        this.lastHeat = this.tile.heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void b(int id, int value) {
        TankManager tMan = this.tile.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, value);
        }
        switch (id) {
            case 10: {
                this.tile.burnTime = value;
                break;
            }
            case 11: {
                this.tile.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.tile.heat = value;
            }
        }
    }
}

