/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import railcraft.common.carts.LinkageManager;

public class Train {
    private final UUID uuid;
    private final Set carts = new HashSet();
    private final Set safeSet = Collections.unmodifiableSet(this.carts);
    private final Set lockingTracks = new HashSet();

    public Train(py cart) {
        this.uuid = UUID.randomUUID();
        this.addCartsToTrain(cart);
    }

    private void addCartsToTrain(py cart) {
        this.addCart(cart);
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        py linkA = lm.getLinkedCartA(cart);
        py linkB = lm.getLinkedCartB(cart);
        if (linkA != null && !this.containsCart(linkA)) {
            this.addCartsToTrain(linkA);
        }
        if (linkB != null && !this.containsCart(linkB)) {
            this.addCartsToTrain(linkB);
        }
    }

    protected void releaseTrain(LinkageManager lm) {
        for (UUID id : this.carts) {
            py cart = lm.getCartFromLinkageId(id);
            if (cart == null) continue;
            cart.getEntityData().o("rcTrainHigh");
            cart.getEntityData().o("rcTrainLow");
        }
        this.carts.clear();
        this.lockingTracks.clear();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    private void addCart(py cart) {
        this.carts.add(cart.getPersistentID());
        cart.getEntityData().a("rcTrainHigh", this.uuid.getMostSignificantBits());
        cart.getEntityData().a("rcTrainLow", this.uuid.getLeastSignificantBits());
    }

    public boolean containsCart(py cart) {
        if (cart == null) {
            return false;
        }
        return this.carts.contains(cart.getPersistentID());
    }

    public Set getCartsInTrain() {
        return this.safeSet;
    }

    public int getSize() {
        return this.carts.size();
    }

    public boolean isTrainLockedDown() {
        return !this.lockingTracks.isEmpty();
    }

    public void addLockingTrack(UUID track) {
        this.lockingTracks.add(track);
    }

    public void removeLockingTrack(UUID track) {
        this.lockingTracks.remove(track);
    }

    public static boolean isTrainLockedDown(py cart) {
        if (cart == null) {
            return false;
        }
        LinkageManager lm = LinkageManager.getInstance(cart.p);
        Train train = lm.getTrain(cart);
        return train.isTrainLockedDown();
    }
}

