/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.List;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.ItemCart;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.EnumColor;

public class ItemLocomotive
extends ItemCart {
    private final int icon1;
    private final int icon2;

    public ItemLocomotive(int id, EnumCart cart, int icon1, int icon2) {
        super(id, cart);
        this.icon1 = icon1;
        this.icon2 = icon2;
        this.d(1);
    }

    public boolean b() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public int a(ur stack, int pass) {
        if (pass == 0) {
            return ItemLocomotive.getPrimaryColor(stack).getHexColor();
        }
        if (pass == 1) {
            return ItemLocomotive.getSecondaryColor(stack).getHexColor();
        }
        return super.a(stack, pass);
    }

    public int getIconIndex(ur stack, int pass) {
        if (pass == 0) {
            return this.icon1;
        }
        if (pass == 1) {
            return this.icon2;
        }
        return super.getIconIndex(stack, pass);
    }

    public void a(ur stack, qx player, List info, boolean adv) {
        EnumColor primary = ItemLocomotive.getPrimaryColor(stack);
        String format = RailcraftLanguage.translate("gui.locomotive.tooltip.primary");
        info.add(String.format(format, primary.getTranslatedName()));
        EnumColor secondary = ItemLocomotive.getSecondaryColor(stack);
        format = RailcraftLanguage.translate("gui.locomotive.tooltip.secondary");
        info.add(String.format(format, secondary.getTranslatedName()));
        float whistle = ItemLocomotive.getWhistlePitch(stack);
        format = RailcraftLanguage.translate("gui.locomotive.tooltip.whistle");
        info.add(String.format(format, whistle < 0.0f ? "???" : String.format("%.2f", Float.valueOf(whistle))));
    }

    public static void setItemColorData(ur stack, int primaryColor, int secondaryColor) {
        if (primaryColor < 0 || secondaryColor < 0) {
            return;
        }
        bq nbt = InvTools.getItemData(stack);
        nbt.a("primaryColor", (byte)primaryColor);
        nbt.a("secondaryColor", (byte)secondaryColor);
    }

    public static void setItemWhistleData(ur stack, float whistlePitch) {
        bq nbt = InvTools.getItemData(stack);
        nbt.a("whistlePitch", whistlePitch);
    }

    public static EnumColor getPrimaryColor(ur stack) {
        bq nbt = stack.p();
        if (nbt == null || !nbt.b("primaryColor")) {
            return EnumColor.LIGHT_GRAY;
        }
        return EnumColor.fromId(nbt.c("primaryColor"));
    }

    public static EnumColor getSecondaryColor(ur stack) {
        bq nbt = stack.p();
        if (nbt == null || !nbt.b("secondaryColor")) {
            return EnumColor.GRAY;
        }
        return EnumColor.fromId(nbt.c("secondaryColor"));
    }

    public static float getWhistlePitch(ur stack) {
        bq nbt = stack.p();
        if (nbt == null || !nbt.b("whistlePitch")) {
            return -1.0f;
        }
        return nbt.g("whistlePitch");
    }
}

