/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.IItemTransfer;
import railcraft.common.api.carts.ILinkableCart;
import railcraft.common.api.carts.bore.IBoreHead;
import railcraft.common.api.carts.bore.IMineable;
import railcraft.common.api.tracks.RailTools;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.carts.DamageSourceBore;
import railcraft.common.carts.LinkageManager;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.inventory.EnumItemType;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.BallastRegistry;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class EntityTunnelBore
extends CartBase
implements la,
ILinkableCart {
    public static final float SPEED = 0.03f;
    public static final float LENGTH = 6.0f;
    public static final int MAX_FILL_DEPTH = 10;
    public static final int FAIL_DELAY = 200;
    public static final int STANDARD_DELAY = 5;
    public static final int LAYER_DELAY = 40;
    public static final int BALLAST_DELAY = 10;
    public static final int FUEL_CONSUMPTION = 12;
    public static final float HARDNESS_MULTIPLER = 8.0f;
    protected static final int WATCHER_ID_MOVING = 20;
    protected static final int WATCHER_ID_BORE_HEAD = 21;
    protected static final int WATCHER_ID_FACING = 5;
    protected boolean degreeCalc = false;
    protected int delay = 0;
    private boolean active;
    private int update;
    private int burnTime;
    private boolean hasInit = true;
    protected boolean placeRail = false;
    protected boolean placeBallast = false;
    protected boolean boreLayer = false;
    protected final la invFuel = new InventoryMapper(this, 1, 6);
    protected final la invBallast = new InventoryMapper(this, 7, 9);
    protected final la invRails = new InventoryMapper(this, 16, 9);
    protected int boreRotationAngle = 0;
    private static final Set mineableBlocks = new HashSet();
    private static final int[] mineable = new int[]{amq.aZ.cm, amq.aX.cm, amq.aY.cm, amq.cg.cm, amq.z.cm, amq.ar.cm, amq.bS.cm, amq.aC.cm, amq.ab.cm, amq.y.cm, amq.au.cm, amq.bg.cm, amq.x.cm, amq.I.cm, amq.aW.cm, amq.N.cm, amq.bu.cm, amq.bw.cm, amq.ai.cm, amq.bq.cm, amq.br.cm, amq.aj.cm, amq.bB.cm, amq.bG.cm, amq.be.cm, amq.as.cm, amq.L.cm, amq.az.cm, amq.bU.cm, amq.J.cm, amq.K.cm, amq.Q.cm, amq.aQ.cm, amq.aR.cm, amq.ah.cm, amq.ag.cm, amq.ch.cm, amq.bd.cm, amq.bv.cm, amq.ba.cm, amq.H.cm, amq.T.cm, amq.B.cm, amq.bf.cm, amq.aV.cm, amq.w.cm, amq.aa.cm, amq.aD.cm, amq.at.cm, amq.bx.cm, amq.bC.cm, amq.Z.cm, amq.bM.cm, amq.M.cm};
    public static final Set replaceableBlocks = new HashSet();
    private static final int[] replaceable = new int[]{amq.at.cm, amq.aa.cm, amq.ab.cm, amq.bx.cm, amq.ai.cm, amq.aj.cm, amq.ag.cm, amq.ah.cm};

    public EntityTunnelBore(yc world, double i, double j, double k) {
        this(world, i, j, k, ForgeDirection.SOUTH);
    }

    public EntityTunnelBore(yc world, double i, double j, double k, ForgeDirection f) {
        super(world);
        this.b(i, j + (double)this.M, k);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = i;
        this.r = j;
        this.s = k;
        this.setFacing(f);
        this.a(6.0f, 2.7f);
        this.update = MiscTools.getRand().nextInt();
    }

    public EntityTunnelBore(yc world) {
        this(world, 0.0, 0.0, 0.0, ForgeDirection.SOUTH);
    }

    public static void addMineableBlock(int id) {
        EntityTunnelBore.addMineableBlock(id, -1);
    }

    public static void addMineableBlock(int id, int meta) {
        mineableBlocks.add(new Mineable(id, meta));
    }

    private boolean isMinableBlock(int id, int meta) {
        if (RailcraftConfig.boreMinesAllBlocks()) {
            return true;
        }
        Mineable mine = new Mineable(id, -1);
        if (mineableBlocks.contains(mine)) {
            return true;
        }
        mine.meta = meta;
        return mineableBlocks.contains(mine);
    }

    protected void a() {
        super.a();
        this.ag.a(20, (Object)0);
        this.ag.a(21, (Object)-1);
        this.ag.a(5, (Object)0);
    }

    public boolean a(lh source, int damage) {
        if (!this.p.I && !this.L) {
            this.i(-this.k());
            this.h(10);
            this.K();
            this.g(this.i() + damage * 10);
            if (source.g() instanceof qx && ((qx)source.g()).cd.d) {
                this.g(500);
            }
            if (this.i() > 120) {
                if (this.n != null) {
                    this.n.a((lq)this);
                }
                this.x();
                this.dropCartAsItem();
            }
            return true;
        }
        return true;
    }

    private void setYaw() {
        float yaw = 0.0f;
        switch (this.getFacing()) {
            case NORTH: {
                yaw = 90.0f;
                break;
            }
            case EAST: {
                yaw = 0.0f;
                break;
            }
            case SOUTH: {
                yaw = 270.0f;
                break;
            }
            case WEST: {
                yaw = 180.0f;
            }
        }
        this.b(yaw, this.A);
    }

    public int k_() {
        return 25;
    }

    public boolean M() {
        return false;
    }

    public void b(double i, double j, double k) {
        if (!this.hasInit) {
            super.b(i, j, k);
            return;
        }
        this.t = i;
        this.u = j;
        this.v = k;
        double w = 1.35;
        double h = 2.7;
        double l = 3.0;
        double x1 = i;
        double x2 = i;
        double z1 = k;
        double z2 = k;
        if (this.getFacing() == ForgeDirection.WEST || this.getFacing() == ForgeDirection.EAST) {
            x1 -= l;
            x2 += l;
            z1 -= w;
            z2 += w;
        } else {
            x1 -= w;
            x2 += w;
            z1 -= l;
            z2 += l;
        }
        this.D.b(x1, j - (double)this.M + (double)this.W, z1, x2, j - (double)this.M + (double)this.W + h, z2);
    }

    public void j_() {
        ++this.update;
        if (Game.isHost(this.p)) {
            if (this.update % 128 == 0) {
                this.forceUpdateBoreHead();
                this.e(false);
                this.setMoving(false);
            } else {
                this.updateBoreHead();
            }
            this.stockBallast();
            this.stockTracks();
        }
        super.j_();
        if (Game.isHost(this.p)) {
            if (this.hasFuel() && this.getDelay() == 0) {
                boolean placed;
                int z;
                int x;
                float offset;
                this.setActive(true);
                int y = ke.c((double)this.u);
                EnumTrackMeta dir = EnumTrackMeta.NORTH_SOUTH;
                if (this.getFacing() == ForgeDirection.WEST || this.getFacing() == ForgeDirection.EAST) {
                    dir = EnumTrackMeta.EAST_WEST;
                }
                if (this.getDelay() == 0) {
                    offset = 1.5f;
                    x = ke.c((double)this.getXAhead(this.t, offset));
                    z = ke.c((double)this.getZAhead(this.v, offset));
                    if (this.placeBallast) {
                        placed = this.placeBallast(x, y - 1, z);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeBallast = false;
                    } else if (!this.p.isBlockSolidOnSide(x, y - 1, z, ForgeDirection.UP)) {
                        this.placeBallast = true;
                        this.setDelay(10);
                    }
                }
                if (this.getDelay() == 0) {
                    offset = 0.8f;
                    x = ke.c((double)this.getXAhead(this.t, offset));
                    z = ke.c((double)this.getZAhead(this.v, offset));
                    if (this.placeRail) {
                        placed = this.placeTrack(x, y, z, dir);
                        if (placed) {
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.placeRail = false;
                    } else if (alr.e_((yc)this.p, (int)x, (int)y, (int)z)) {
                        if (!dir.isEqual(((alr)amq.p[this.p.a(x, y, z)]).getBasicRailMetadata((ym)this.p, (py)this, x, y, z))) {
                            this.p.d(x, y, z, dir.ordinal());
                            this.setDelay(5);
                        }
                    } else {
                        int id = this.p.a(x, y, z);
                        if (id == 0 || replaceableBlocks.contains(id)) {
                            this.placeRail = true;
                            this.setDelay(5);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                    }
                }
                if (this.getDelay() == 0) {
                    offset = 3.3f;
                    x = ke.c((double)this.getXAhead(this.t, offset));
                    z = ke.c((double)this.getZAhead(this.v, offset));
                    if (this.boreLayer) {
                        boolean bored = this.boreLayer(x, y, z, dir);
                        if (bored) {
                            this.setDelay(40);
                        } else {
                            this.setDelay(200);
                            this.setActive(false);
                        }
                        this.boreLayer = false;
                    } else if (this.checkForLava(x, y, z, dir)) {
                        this.setDelay(200);
                        this.setActive(false);
                    } else {
                        this.setDelay((int)Math.ceil(this.getLayerHardness(x, y, z, dir)));
                        if (this.getDelay() != 0) {
                            this.boreLayer = true;
                        }
                    }
                }
            }
            if (this.h()) {
                double i = this.getXAhead(this.t, 3.3);
                double k = this.getZAhead(this.v, 3.3);
                double size = 0.8;
                List entities = this.p.b((lq)this, aoe.a().a(i - size, this.u, k - size, i + size, this.u + 2.0, k + size));
                for (Object e : entities) {
                    if (!(e instanceof md)) continue;
                    md ent = (md)e;
                    ent.a((lh)new DamageSourceBore(this), 2);
                }
            }
            this.setMoving(this.hasFuel() && this.getDelay() == 0);
            if (this.getDelay() > 0) {
                this.setDelay(this.getDelay() - 1);
            }
        }
        if (this.isMoving()) {
            float factorX = ke.b((float)((float)Math.toRadians(this.z)));
            float factorZ = -ke.a((float)((float)Math.toRadians(this.z)));
            this.w = 0.03f * factorX;
            this.y = 0.03f * factorZ;
        } else {
            this.w = 0.0;
            this.y = 0.0;
        }
        this.emitParticles();
        if (this.h()) {
            this.boreRotationAngle += 5;
        }
    }

    @Override
    public float getCartMaxSpeed() {
        return 0.03f;
    }

    protected void updateFuel() {
        if (Game.isHost(this.p)) {
            if (this.h()) {
                this.spendFuel();
            }
            this.stockFuel();
            if (this.outOfFuel()) {
                this.addFuel();
            }
            this.e(this.hasFuel() && this.isActive());
        }
    }

    protected double getXAhead(double x, double offset) {
        if (this.getFacing() == ForgeDirection.EAST) {
            x += offset;
        } else if (this.getFacing() == ForgeDirection.WEST) {
            x -= offset;
        }
        return x;
    }

    protected double getZAhead(double z, double offset) {
        if (this.getFacing() == ForgeDirection.NORTH) {
            z -= offset;
        } else if (this.getFacing() == ForgeDirection.SOUTH) {
            z += offset;
        }
        return z;
    }

    protected void emitParticles() {
        if (this.h()) {
            double randomFactor = 0.125;
            double forwardOffset = -0.35;
            double smokeYOffset = 2.4;
            double flameYOffset = 0.7;
            double smokeSideOffset = 0.92;
            double flameSideOffset = 1.14;
            double smokeX1 = this.t;
            double smokeX2 = this.t;
            double smokeZ1 = this.v;
            double smokeZ2 = this.v;
            double flameX1 = this.t;
            double flameX2 = this.t;
            double flameZ1 = this.v;
            double flameZ2 = this.v;
            if (this.getFacing() == ForgeDirection.NORTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 += forwardOffset;
                smokeZ2 += forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 += forwardOffset + this.aa.nextGaussian() * randomFactor;
                flameZ2 += forwardOffset + this.aa.nextGaussian() * randomFactor;
            } else if (this.getFacing() == ForgeDirection.EAST) {
                smokeX1 -= forwardOffset;
                smokeX2 -= forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 -= forwardOffset + this.aa.nextGaussian() * randomFactor;
                flameX2 -= forwardOffset + this.aa.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            } else if (this.getFacing() == ForgeDirection.SOUTH) {
                smokeX1 += smokeSideOffset;
                smokeX2 -= smokeSideOffset;
                smokeZ1 -= forwardOffset;
                smokeZ2 -= forwardOffset;
                flameX1 += flameSideOffset;
                flameX2 -= flameSideOffset;
                flameZ1 -= forwardOffset + this.aa.nextGaussian() * randomFactor;
                flameZ2 -= forwardOffset + this.aa.nextGaussian() * randomFactor;
            } else if (this.getFacing() == ForgeDirection.WEST) {
                smokeX1 += forwardOffset;
                smokeX2 += forwardOffset;
                smokeZ1 += smokeSideOffset;
                smokeZ2 -= smokeSideOffset;
                flameX1 += forwardOffset + this.aa.nextGaussian() * randomFactor;
                flameX2 += forwardOffset + this.aa.nextGaussian() * randomFactor;
                flameZ1 += flameSideOffset;
                flameZ2 -= flameSideOffset;
            }
            if (this.aa.nextInt(4) == 0) {
                this.p.a("largesmoke", smokeX1, this.u + smokeYOffset, smokeZ1, 0.0, 0.0, 0.0);
                this.p.a("flame", flameX1, this.u + flameYOffset + this.aa.nextGaussian() * randomFactor, flameZ1, 0.0, 0.0, 0.0);
            }
            if (this.aa.nextInt(4) == 0) {
                this.p.a("largesmoke", smokeX2, this.u + smokeYOffset, smokeZ2, 0.0, 0.0, 0.0);
                this.p.a("flame", flameX2, this.u + flameYOffset + this.aa.nextGaussian() * randomFactor, flameZ2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void stockBallast() {
        py link = LinkageManager.getInstance(this.p).getLinkedCartA(this);
        if (link instanceof IItemTransfer) {
            IItemTransfer tranfer = (IItemTransfer)link;
            for (int slot = 0; slot < this.invBallast.k_(); ++slot) {
                ur stack = this.invBallast.a(slot);
                if (stack != null && !BallastRegistry.isItemBallast(stack)) {
                    stack = tranfer.offerItem(this, stack);
                    this.invBallast.a(slot, stack);
                    return;
                }
                if (stack != null) continue;
                stack = tranfer.requestItem((Object)this, EnumItemType.BALLAST);
                InvTools.moveItemStack(stack, this.invBallast);
                return;
            }
        }
    }

    protected boolean placeBallast(int i, int j, int k) {
        if (!this.p.isBlockSolidOnSide(i, j, k, ForgeDirection.UP)) {
            for (int inv = 0; inv < this.invBallast.k_(); ++inv) {
                ur stack = this.invBallast.a(inv);
                if (stack == null || !BallastRegistry.isItemBallast(stack)) continue;
                for (int y = j; y > j - 10; --y) {
                    if (!this.p.isBlockSolidOnSide(i, y, k, ForgeDirection.UP)) continue;
                    this.invBallast.a(inv, 1);
                    this.p.d(i, j, k, stack.c, stack.j());
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    protected void stockTracks() {
        py link = LinkageManager.getInstance(this.p).getLinkedCartA(this);
        if (link instanceof IItemTransfer) {
            IItemTransfer tranfer = (IItemTransfer)link;
            for (int slot = 0; slot < this.invRails.k_(); ++slot) {
                ur stack = this.invRails.a(slot);
                if (stack != null && !EnumItemType.TRACK.isItemType(stack)) {
                    stack = tranfer.offerItem(this, stack);
                    this.invRails.a(slot, stack);
                    return;
                }
                if (stack != null) continue;
                stack = tranfer.requestItem((Object)this, EnumItemType.TRACK);
                InvTools.moveItemStack(stack, this.invRails);
                return;
            }
        }
    }

    protected boolean placeTrack(int i, int j, int k, EnumTrackMeta meta) {
        int id = this.p.a(i, j, k);
        if (replaceableBlocks.contains(id)) {
            int m = this.p.h(i, j, k);
            this.p.e(i, j, k, 0);
            amq.p[id].c(this.p, i, j, k, m, 0);
            id = this.p.a(i, j, k);
        }
        if (id == 0 && this.p.t(i, j - 1, k)) {
            for (int inv = 0; inv < this.invRails.k_(); ++inv) {
                ur stack = this.invRails.a(inv);
                if (stack == null) continue;
                boolean placed = RailTools.placeRailAt(stack, this.p, i, j, k);
                if (placed) {
                    this.p.c(i, j, k, meta.ordinal());
                    this.invRails.a(inv, 1);
                }
                return placed;
            }
        }
        return false;
    }

    protected boolean checkForLava(int i, int j, int k, EnumTrackMeta dir) {
        int xStart = i - 1;
        int zStart = k - 1;
        int xEnd = i + 1;
        int zEnd = k + 1;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            xStart = i - 2;
            xEnd = i + 2;
        } else {
            zStart = k - 2;
            zEnd = k + 2;
        }
        for (int jj = j; jj < j + 4; ++jj) {
            for (int ii = xStart; ii <= xEnd; ++ii) {
                for (int kk = zStart; kk <= zEnd; ++kk) {
                    int id = this.p.a(ii, jj, kk);
                    if (id != amq.G.cm && id != amq.F.cm) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean boreLayer(int i, int j, int k, EnumTrackMeta dir) {
        int jj;
        boolean clear = true;
        int ii = i;
        int kk = k;
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            --ii;
        } else {
            --kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        ii = i;
        kk = k;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            ++ii;
        } else {
            ++kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            clear = clear && this.mineBlock(ii, jj, kk, dir);
        }
        return clear;
    }

    protected boolean mineBlock(int i, int j, int k, EnumTrackMeta dir) {
        int trackMeta;
        int id = this.p.a(i, j, k);
        amq block = amq.p[id];
        if (id == 0 || this.p.c(i, j, k)) {
            return true;
        }
        if (alr.e((int)id) ? dir.isEqual(trackMeta = ((alr)block).getBasicRailMetadata((ym)this.p, (py)this, i, j, k)) : id == amq.at.cm) {
            return true;
        }
        ur head = this.a(0);
        if (head == null) {
            return false;
        }
        int meta = this.p.h(i, j, k);
        if (!this.canMineBlock(i, j, k, id, meta)) {
            return false;
        }
        ArrayList items = block.getBlockDropped(this.p, i, j, k, meta, 0);
        py link = LinkageManager.getInstance(this.p).getLinkedCartA(this);
        for (ur item : items) {
            if (EnumItemType.FUEL.isItemType(item)) {
                item = InvTools.moveItemStack(item, this.invFuel);
            }
            if (item != null && item.a > 0 && item.c == amq.I.cm) {
                item = InvTools.moveItemStack(item, this.invBallast);
            }
            if (item != null && item.a > 0 && link instanceof IItemTransfer) {
                item = ((IItemTransfer)link).offerItem(this, item);
            }
            if (item == null || item.a <= 0 || RailcraftConfig.boreDestroysBlocks()) continue;
            float f = 0.7f;
            double xr = ((double)this.p.t.nextFloat() - 0.5) * (double)f;
            double yr = ((double)this.p.t.nextFloat() - 0.5) * (double)f;
            double zr = ((double)this.p.t.nextFloat() - 0.5) * (double)f;
            px entityitem = new px(this.p, this.getXAhead(this.t, -3.2) + xr, this.u + 0.3 + yr, this.getZAhead(this.v, -3.2) + zr, item);
            this.p.d((lq)entityitem);
        }
        this.p.e(i, j, k, 0);
        head.b(head.j() + 1);
        if (head.j() > head.k()) {
            this.a(0, null);
        }
        return true;
    }

    private boolean canMineBlock(int i, int j, int k, int id, int meta) {
        amq block = amq.p[id];
        if (block instanceof IMineable) {
            ur head = this.a(0);
            if (head == null) {
                return false;
            }
            return ((IMineable)block).canMineBlock(this.p, i, j, k, this, head);
        }
        if (block.m(this.p, i, j, k) < 0.0f) {
            return false;
        }
        return this.isMinableBlock(id, meta) && this.canHeadHarvestBlock(id, meta);
    }

    private boolean canHeadHarvestBlock(int id, int meta) {
        ur head = this.a(0);
        if (head == null) {
            return false;
        }
        if (head.b() instanceof IBoreHead) {
            IBoreHead boreHead = (IBoreHead)head.b();
            boolean mappingExists = false;
            int blockHarvestLevel = MinecraftForge.getBlockHarvestLevel((amq)amq.p[id], (int)meta, (String)"pickaxe");
            if (blockHarvestLevel > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if ((blockHarvestLevel = MinecraftForge.getBlockHarvestLevel((amq)amq.p[id], (int)meta, (String)"axe")) > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if ((blockHarvestLevel = MinecraftForge.getBlockHarvestLevel((amq)amq.p[id], (int)meta, (String)"shovel")) > -1) {
                if (boreHead.getHarvestLevel() >= blockHarvestLevel) {
                    return true;
                }
                mappingExists = true;
            }
            if (mappingExists) {
                return false;
            }
        }
        return true;
    }

    protected float getLayerHardness(int i, int j, int k, EnumTrackMeta dir) {
        int jj;
        float hardness = 0.0f;
        int ii = i;
        int kk = k;
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            --ii;
        } else {
            --kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        ii = i;
        kk = k;
        if (dir == EnumTrackMeta.NORTH_SOUTH) {
            ++ii;
        } else {
            ++kk;
        }
        for (jj = j; jj < j + 3; ++jj) {
            hardness += this.getBlockHardness(ii, jj, kk, dir);
        }
        hardness *= 8.0f;
        if (this.d[0] != null && this.d[0].b() instanceof IBoreHead) {
            IBoreHead head = (IBoreHead)this.d[0].b();
            float dig = 2.0f - head.getDigModifier();
            hardness *= dig;
        }
        return hardness;
    }

    protected float getBlockHardness(int i, int j, int k, EnumTrackMeta dir) {
        int meta;
        int id = this.p.a(i, j, k);
        amq block = amq.p[id];
        if (id == 0 || this.p.c(i, j, k)) {
            return 0.0f;
        }
        if (alr.e_((yc)this.p, (int)i, (int)j, (int)k)) {
            int trackMeta = ((alr)block).getBasicRailMetadata((ym)this.p, (py)this, i, j, k);
            if (dir.isEqual(trackMeta)) {
                return 0.0f;
            }
        } else {
            if (id == amq.at.cm) {
                return 0.0f;
            }
            if (id == amq.as.cm) {
                return 15.0f;
            }
        }
        if (!this.canMineBlock(i, j, k, id, meta = this.p.h(i, j, k))) {
            return 0.1f;
        }
        float hardness = block.m(this.p, i, j, k);
        if (hardness <= 0.0f) {
            hardness = 0.1f;
        }
        return hardness;
    }

    public aoe g(lq other) {
        if (other instanceof md) {
            return other.D;
        }
        return null;
    }

    public aoe E() {
        return this.D;
    }

    public String b() {
        return "Tunnel Bore";
    }

    public float getBoreRotationAngle() {
        return (float)Math.toRadians(this.boreRotationAngle);
    }

    protected void b(bq data) {
        super.b(data);
        data.a("facing", (byte)this.getFacing().ordinal());
        data.a("delay", this.getDelay());
        data.a("active", this.isActive());
        data.a("burnTime", this.getBurnTime());
    }

    protected void a(bq data) {
        super.a(data);
        this.setFacing(ForgeDirection.getOrientation((int)data.c("facing")));
        this.setDelay(data.e("delay"));
        this.setActive(data.n("active"));
        this.setBurnTime(data.e("burnTime"));
        this.update = MiscTools.getRand().nextInt();
    }

    protected void setDelay(int i) {
        this.delay = i;
    }

    protected int getDelay() {
        return this.delay;
    }

    public boolean h() {
        return super.h();
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    protected boolean isMoving() {
        return this.ag.a(20) != 0;
    }

    protected void setMoving(boolean move) {
        this.ag.b(20, (Object)((byte)(move ? 1 : 0)));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getFuel() {
        return this.e;
    }

    public boolean outOfFuel() {
        return this.getFuel() <= 12;
    }

    public boolean hasFuel() {
        return this.getFuel() > 0;
    }

    protected void stockFuel() {
        py link = LinkageManager.getInstance(this.p).getLinkedCartA(this);
        if (link instanceof IItemTransfer) {
            IItemTransfer tranfer = (IItemTransfer)link;
            for (int slot = 0; slot < this.invFuel.k_(); ++slot) {
                ur stack = this.invFuel.a(slot);
                if (stack != null && !EnumItemType.FUEL.isItemType(stack)) {
                    stack = tranfer.offerItem(this, stack);
                    this.invFuel.a(slot, stack);
                    return;
                }
                if (stack != null || (stack = tranfer.requestItem((Object)this, EnumItemType.FUEL)) == null) continue;
                InvTools.moveItemStack(stack, this.invFuel);
                return;
            }
        }
    }

    protected void addFuel() {
        int burn = 0;
        for (int slot = 0; slot < this.invFuel.k_(); ++slot) {
            ur stack = this.invFuel.a(slot);
            if (stack == null || (burn = MiscTools.getItemBurnTime(stack)) <= 0) continue;
            if (stack.b().s()) {
                this.invFuel.a(slot, new ur(stack.b().r()));
                break;
            }
            this.invFuel.a(slot, 1);
            break;
        }
        if (burn > 0) {
            this.setBurnTime(burn + this.getFuel());
            this.setFuel(this.getFuel() + burn);
        }
    }

    public int getBurnProgressScaled(int i) {
        int burnTime = this.getBurnTime();
        if (burnTime == 0) {
            return 0;
        }
        return this.getFuel() * i / burnTime;
    }

    public void setFuel(int i) {
        this.e = i;
    }

    protected void spendFuel() {
        this.setFuel(this.getFuel() - 12);
    }

    protected void updateBoreHead() {
        int id = -1;
        if (this.d[0] != null) {
            id = this.d[0].c;
        }
        this.ag.b(21, (Object)id);
    }

    protected void forceUpdateBoreHead() {
        this.ag.b(21, (Object)-1);
        this.updateBoreHead();
    }

    public IBoreHead getBoreHead() {
        int id = this.ag.c(21);
        IBoreHead head = null;
        if (id > 0 && id < up.e.length && up.e[id] instanceof IBoreHead) {
            head = (IBoreHead)up.e[id];
        }
        return head;
    }

    protected void applyDragAndPushForces() {
        this.w *= this.getDrag();
        this.x *= 0.0;
        this.y *= this.getDrag();
    }

    protected void updatePushForces() {
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean doInteract(qx player) {
        if (Game.isHost(this.p)) {
            GuiHandler.openGui(EnumGui.CART_BORE, player, this.p, (lq)this);
        }
        return true;
    }

    public void d() {
        if (!this.isActive()) {
            this.setDelay(5);
        }
    }

    public final ForgeDirection getFacing() {
        return ForgeDirection.getOrientation((int)this.ag.a(5));
    }

    protected final void setFacing(ForgeDirection facing) {
        this.ag.b(5, (Object)((byte)facing.ordinal()));
        this.setYaw();
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(py cart) {
        double z;
        double x = this.getXAhead(this.t, -3.0);
        return cart.f(x, this.u, z = this.getZAhead(this.v, -3.0)) < 2.5;
    }

    @Override
    public boolean hasTwoLinks() {
        return false;
    }

    @Override
    public float getLinkageDistance(py cart) {
        return 4.0f;
    }

    @Override
    public float getOptimalDistance(py cart) {
        return 3.1f;
    }

    @Override
    public void onLinkCreated(py cart) {
    }

    @Override
    public void onLinkBroken(py cart) {
    }

    @Override
    public boolean canBeAdjusted(py cart) {
        return false;
    }

    public boolean shouldDoRailFunctions() {
        return false;
    }

    public la getInventoryFuel() {
        return this.invFuel;
    }

    public la getInventoryGravel() {
        return this.invBallast;
    }

    public la getInventoryRails() {
        return this.invRails;
    }

    static {
        for (int id : mineable) {
            EntityTunnelBore.addMineableBlock(id);
        }
        for (int id : replaceable) {
            replaceableBlocks.add(id);
        }
    }

    private static class Mineable {
        public int id;
        public int meta;

        public Mineable(int id, int meta) {
            this.id = id;
            this.meta = meta;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mineable other = (Mineable)obj;
            if (this.id != other.id) {
                return false;
            }
            return this.meta == other.meta;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + this.id;
            hash = 41 * hash + this.meta;
            return hash;
        }
    }
}

