/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.aesthetics.post.ItemPost;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.MaintanceCartBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.BallastRegistry;
import railcraft.common.util.misc.Game;
import railcraft.common.util.sounds.SoundHelper;

public class EntityCartUndercutter
extends MaintanceCartBase {
    public static final Set EXCLUDED_BLOCKS = new HashSet();
    private static final int[] TEXTURE = new int[]{208};
    private static final int SLOT_EXIST_UNDER_A = 0;
    private static final int SLOT_EXIST_UNDER_B = 1;
    private static final int SLOT_EXIST_SIDE_A = 2;
    private static final int SLOT_EXIST_SIDE_B = 3;
    private static final int SLOT_REPLACE_UNDER = 4;
    private static final int SLOT_REPLACE_SIDE = 5;
    public static final int SLOT_STOCK_UNDER = 0;
    public static final int SLOT_STOCK_SIDE = 1;

    public static boolean isValidBallast(ur stack) {
        if (stack == null) {
            return false;
        }
        if (EXCLUDED_BLOCKS.contains(stack.c)) {
            return false;
        }
        if (stack.b() instanceof vq && amq.p[stack.c].c()) {
            return true;
        }
        return stack.b() instanceof ItemPost;
    }

    public EntityCartUndercutter(yc world) {
        super(world);
    }

    public EntityCartUndercutter(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = d;
        this.r = d1;
        this.s = d2;
    }

    @Override
    public int[] getTextureArray() {
        return TEXTURE;
    }

    @Override
    public int k_() {
        return 2;
    }

    @Override
    public void j_() {
        int id;
        super.j_();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.stockItems(4, 0);
        this.stockItems(5, 1);
        int x = ke.c((double)this.t);
        int y = ke.c((double)this.u);
        int z = ke.c((double)this.v);
        if (alr.e_((yc)this.p, (int)x, (int)(y - 1), (int)z)) {
            --y;
        }
        if (alr.e((int)(id = this.p.a(x, y, z)))) {
            EnumTrackMeta trackMeta = EnumTrackMeta.fromMeta(((alr)amq.p[id]).getBasicRailMetadata((ym)this.p, (py)this, x, y, z));
            this.replaceUnder(x, --y, z, 0);
            this.replaceUnder(x, y, z, 1);
            this.replaceSide(x, y, z, 2, trackMeta);
            this.replaceSide(x, y, z, 3, trackMeta);
        }
    }

    private void replaceUnder(int x, int y, int z, int slotExist) {
        this.replaceWith(x, y, z, slotExist, 0);
    }

    private void replaceSide(int x, int y, int z, int slotExist, EnumTrackMeta trackMeta) {
        if (trackMeta.isEastWestTrack()) {
            this.replaceWith(x, y, z + 1, slotExist, 1);
            this.replaceWith(x, y, z - 1, slotExist, 1);
        } else if (trackMeta.isNorthSouthTrack()) {
            this.replaceWith(x + 1, y, z, slotExist, 1);
            this.replaceWith(x - 1, y, z, slotExist, 1);
        }
    }

    private void replaceWith(int x, int y, int z, int slotExist, int slotStock) {
        ur exist = this.patternInv.a(slotExist);
        ur stock = this.a(slotStock);
        if (exist != null && exist.b() instanceof vq && EntityCartUndercutter.isValidBallast(stock)) {
            vq existItem = (vq)exist.b();
            int existMeta = 0;
            if (existItem.l()) {
                existMeta = existItem.a(exist.j());
            }
            int id = this.p.a(x, y, z);
            int oldMeta = this.p.h(x, y, z);
            if ((exist.c == id && oldMeta == existMeta || exist.c == amq.y.cm && id == amq.x.cm) && (!BallastRegistry.isItemBallast(stock) || !this.p.c(x, y - 1, z) && !(amq.p[this.p.a(x, y - 1, z)] instanceof akx))) {
                ArrayList drops = amq.p[id].getBlockDropped(this.p, x, y, z, oldMeta, 0);
                vq item = (vq)stock.b();
                int newMeta = 0;
                if (item.l()) {
                    newMeta = item.a(stock.j());
                }
                if (this.p.d(x, y, z, stock.c, newMeta)) {
                    SoundHelper.playBlockSound(this.p, x, y, z, amq.p[stock.c].cz.b(), 1.0f, 0.8f, stock.c, newMeta);
                    this.a(slotStock, 1);
                    for (ur stack : drops) {
                        CartTools.offerOrDropItem(this, stack);
                    }
                    this.blink();
                }
            }
        }
    }

    @Override
    public boolean doInteract(qx player) {
        if (Game.isHost(this.getWorld())) {
            GuiHandler.openGui(EnumGui.CART_UNDERCUTTER, player, this.p, (lq)this);
        }
        return true;
    }

    public String b() {
        return RailcraftLanguage.translate(EnumCart.UNDERCUTTER.getTag());
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        return 0;
    }

    static {
        EXCLUDED_BLOCKS.add(amq.H.cm);
    }
}

