/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import railcraft.common.carts.EntityCartTNT;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.Game;

public class EntityCartPumpkin
extends EntityCartTNT {
    private static final byte SPAWN_DIST = 2;
    private static final Map mobWeights = new HashMap();
    private static final Map mobNumber = new HashMap();
    private static final List mobs = new ArrayList();
    private static final List potions = new ArrayList();

    public EntityCartPumpkin(yc world) {
        super(world);
    }

    public EntityCartPumpkin(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = d;
        this.r = d1;
        this.s = d2;
        this.setBlastRadius(1.5f);
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ur(up.az));
            items.add(new ur(amq.bd));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    protected byte getMinBlastRadius() {
        return 1;
    }

    @Override
    protected byte getMaxBlastRadius() {
        return 8;
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.p.a((lq)this, this.t, this.u, this.v, this.getBlastRadius(), true);
            this.x();
            this.spawnMob();
            this.spawnPotion();
        }
    }

    private String getMobToSpawn() {
        int weight;
        String mob;
        do {
            int index = this.aa.nextInt(mobs.size());
            mob = (String)mobs.get(index);
            weight = this.aa.nextInt(100);
        } while ((Integer)mobWeights.get(mob) < weight);
        return mob;
    }

    private void spawnMob() {
        String mobName = this.getMobToSpawn();
        int numToSpawn = (Integer)mobNumber.get(mobName);
        for (int i = 0; i < numToSpawn; ++i) {
            lq mob = lv.a((String)mobName, (yc)this.p);
            if (mob == null) {
                return;
            }
            double x = this.t + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
            double y = this.u + 1.0 + (double)this.aa.nextInt(3) - 1.0;
            double z = this.v + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
            md living = mob instanceof md ? (md)mob : null;
            mob.b(x, y, z, this.aa.nextFloat() * 360.0f, 0.0f);
            if (!this.p.b(mob.D) || !this.p.a(mob, mob.D).isEmpty() || this.p.d(mob.D)) continue;
            if (mob instanceof qn) {
                qn skel = (qn)mob;
                if (this.aa.nextInt(4) == 0) {
                    skel.bn.a(4, (nc)new nk((md)skel, qx.class, 0.25f, false));
                    skel.a(1);
                    skel.b(0, new ur(up.v));
                } else {
                    skel.bn.a(4, (nc)new nx((ql)skel, 0.25f, 60, 10.0f));
                    skel.b(0, new ur(up.k));
                }
                mob.b(4, new ur(this.aa.nextFloat() < 0.25f ? amq.bi : amq.bd));
            } else {
                living.bG();
            }
            this.p.d(mob);
            this.p.f(2004, (int)x, (int)y, (int)z, 0);
            if (living == null) continue;
            living.aR();
        }
    }

    private void spawnPotion() {
        int meta = (Integer)potions.get(this.aa.nextInt(potions.size()));
        ur potion = new ur((up)up.bs, 1, meta);
        double x = this.t + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        double y = this.u + 1.0 + (double)this.aa.nextInt(3) - 1.0;
        double z = this.v + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        InvTools.dropItem(potion, this.p, x, y, z);
    }

    @Override
    public String b() {
        return "Pumpkin Cart";
    }

    @Override
    public amq getBlock() {
        return amq.bd;
    }

    @Override
    public int getBlockMetadata() {
        return 0;
    }

    static {
        mobs.add("Skeleton");
        mobs.add("Bat");
        mobs.add("Witch");
        mobs.add("WitherBoss");
        mobWeights.put("Skeleton", 50);
        mobWeights.put("Bat", 75);
        mobWeights.put("Witch", 25);
        mobWeights.put("WitherBoss", 5);
        mobNumber.put("Skeleton", 1);
        mobNumber.put("Bat", 3);
        mobNumber.put("Witch", 1);
        mobNumber.put("WitherBoss", 1);
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            List effects = vx.b((int)meta, (boolean)false);
            if (effects == null || effects.isEmpty()) continue;
            potions.add(meta);
        }
    }
}

