/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecartRegistry;
import railcraft.common.api.carts.ICartTextureInterface;
import railcraft.common.api.carts.IItemTransfer;
import railcraft.common.api.carts.TransferCartBase;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.ItemCart;
import railcraft.common.carts.LinkageManager;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.effects.EffectManager;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.ChunkManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.IAnchor;

public class EntityCartAnchor
extends TransferCartBase
implements ICartTextureInterface,
IAnchor,
ISpecialInventory {
    private static final long TICK_PER_HOUR = 72000L;
    public static final byte TICKET_FLAG = 6;
    private static final byte ANCHOR_RADIUS = 1;
    private static final byte MAX_CHUNKS = 12;
    protected ForgeChunkManager.Ticket ticket;
    private Set chunks;
    private boolean first = true;
    private long anchorFuel;
    private la invWrapper = new InventoryMapper(this);

    public EntityCartAnchor(yc world) {
        super(world);
        this.passThrough = true;
    }

    public EntityCartAnchor(yc world, double x, double y, double z) {
        this(world);
        this.b(x, y + (double)this.M, z);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = x;
        this.r = y;
        this.s = z;
    }

    private boolean hasFuel() {
        return this.anchorFuel > 0L;
    }

    public void setAnchorFuel(long fuel) {
        this.anchorFuel = fuel;
    }

    public void j_() {
        super.j_();
        if (Game.isNotHost(this.p)) {
            if (this.e(6)) {
                if (this.chunks != null) {
                    EffectManager.instance.chunkLoaderEffect(this.p, this, this.chunks);
                } else {
                    this.setupChunks(this.ai, this.ak);
                }
            }
            return;
        }
        if (RailcraftConfig.deleteAnchors()) {
            this.x();
            return;
        }
        int hoursPerFeeding = this.getRefuelTime();
        if (hoursPerFeeding > 0) {
            if (this.ticket != null && this.anchorFuel > 0L) {
                --this.anchorFuel;
            }
            if (this.anchorFuel <= 0L) {
                this.stockFuel();
                ur stack = this.a(0);
                if (stack == null || stack.a <= 0) {
                    this.a(0, null);
                    this.releaseTicket();
                } else if (stack.c == RailcraftConfig.anchorFuelItemID()) {
                    this.a(0, 1);
                    this.anchorFuel = (long)hoursPerFeeding * 72000L;
                }
            }
        }
        if (this.ticket == null) {
            this.requestTicket();
        }
    }

    private void stockFuel() {
        LinkageManager lm = LinkageManager.getInstance(this.p);
        py link = lm.getLinkedCartA(this);
        if (link instanceof IItemTransfer) {
            this.requestFuel((IItemTransfer)link);
        }
        if ((link = lm.getLinkedCartB(this)) instanceof IItemTransfer) {
            this.requestFuel((IItemTransfer)link);
        }
    }

    private void requestFuel(IItemTransfer cart) {
        ur stack = this.a(0);
        if (stack != null && stack.c != RailcraftConfig.anchorFuelItemID()) {
            stack = cart.offerItem(this, stack);
            this.a(0, stack);
            return;
        }
        if (stack == null && (stack = cart.requestItem((Object)this, new ur(RailcraftConfig.anchorFuelItemID(), 1, 0))) != null) {
            InvTools.moveItemStack(stack, this);
        }
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)Railcraft.getMod(), (yc)this.p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
    }

    protected int getRefuelTime() {
        return RailcraftConfig.anchorRefuel();
    }

    protected boolean meetsTicketRequirements() {
        return this.hasFuel() || this.getRefuelTime() <= 0;
    }

    protected void releaseTicket() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = null;
        this.a(6, false);
    }

    private boolean requestTicket() {
        ForgeChunkManager.Ticket chunkTicket;
        if (this.meetsTicketRequirements() && (chunkTicket = this.getTicketFromForge()) != null) {
            chunkTicket.getModData();
            chunkTicket.setChunkListDepth(12);
            chunkTicket.bindEntity((lq)this);
            this.setChunkTicket(chunkTicket);
            return true;
        }
        return false;
    }

    public void setChunkTicket(ForgeChunkManager.Ticket tick) {
        if (this.ticket != tick) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = tick;
        this.a(6, this.ticket != null);
    }

    public void forceChunkLoading(int xChunk, int zChunk) {
        if (this.ticket == null) {
            return;
        }
        this.setupChunks(xChunk, zChunk);
        for (xv chunk : this.chunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (xv)chunk);
        }
        xv myChunk = new xv(xChunk, zChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (xv)myChunk);
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (xv)myChunk);
    }

    public void setupChunks(int xChunk, int zChunk) {
        this.chunks = this.e(6) ? ChunkManager.getInstance().getChunksAround(xChunk, zChunk, 1) : null;
    }

    protected void b(bq data) {
        super.b(data);
        data.a("anchorFuel", this.anchorFuel);
    }

    protected void a(bq data) {
        super.a(data);
        if (this.getRefuelTime() > 0) {
            this.anchorFuel = data.f("anchorFuel");
        }
    }

    @Override
    public void x() {
        this.releaseTicket();
        super.x();
    }

    @Override
    public boolean doInteract(qx player) {
        if (Game.isHost(this.getWorld()) && this.getRefuelTime() > 0) {
            GuiHandler.openGui(EnumGui.CART_ANCHOR, player, this.p, (lq)this);
        }
        return true;
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        items.add(this.getCartItem());
        return items;
    }

    public ur getCartItem() {
        ur drop = MinecartRegistry.getItemForCart((py)this);
        if (this.getRefuelTime() > 0 && this.hasFuel()) {
            bq nbt = new bq("tag");
            nbt.a("fuel", this.anchorFuel);
            drop.d(nbt);
        }
        return drop;
    }

    @Override
    public boolean doesCartMatchFilter(ur stack, py cart) {
        return ItemCart.getCartType(stack) == EnumCart.ANCHOR;
    }

    public double getDrag() {
        return 0.991999979019165;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int k_() {
        return this.getRefuelTime() > 0 ? 1 : 0;
    }

    public String b() {
        return RailcraftLanguage.translate(EnumCart.ANCHOR.getTag());
    }

    @Override
    public amq getBlock() {
        return RailcraftBlocks.getBlockMachineAlpha();
    }

    @Override
    public int getBlockMetadata() {
        return EnumMachineAlpha.WORLD_ANCHOR.ordinal();
    }

    @Override
    public int getBlockTextureOnSide(int side) {
        if (side < 2 && !this.e(6)) {
            return EnumMachineAlpha.WORLD_ANCHOR.getTexture(6);
        }
        return EnumMachineAlpha.WORLD_ANCHOR.getTexture(side);
    }

    @Override
    public long getAnchorFuel() {
        return this.anchorFuel;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        ur remainder;
        if (!RailcraftConfig.anchorsCanInteractWithPipes()) {
            return 0;
        }
        if (stack == null) {
            return 0;
        }
        if (stack.c != RailcraftConfig.anchorFuelItemID()) {
            return 0;
        }
        stack = stack.l();
        la inv = this;
        if (!doAdd) {
            inv = new InventoryCopy(inv);
        }
        if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
            return stack.a;
        }
        return stack.a - remainder.a;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this.invWrapper;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }
}

