/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.EnumTrackMeta;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.blocks.tracks.TrackTools;
import railcraft.common.blocks.tracks.speedcontroller.SpeedControllerHighSpeed;
import railcraft.common.carts.CartUtils;
import railcraft.common.core.RailcraftConfig;

public class TrackSpeed
extends TrackBaseRailcraft {
    public static final float SPEED_CUTOFF = 0.39f;
    public Float maxSpeed;

    public TrackSpeed() {
        this.speedController = SpeedControllerHighSpeed.getInstance();
    }

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SPEED;
    }

    @Override
    public int getTextureIndex() {
        int meta = this.tileEntity.p();
        if (meta >= 6) {
            return this.getTrackType().getTextureIndex() - 16;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public boolean isFlexibleRail() {
        return true;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        this.maxSpeed = null;
    }

    @Override
    public void onMinecartPass(py cart) {
        TrackSpeed.testCartSpeedForBasic(this, cart);
    }

    protected static void testSafety(ITrackInstance track, py cart) {
        if (!TrackSpeed.isTrackSafeForHighSpeed(track, cart)) {
            CartUtils.explodeCart(cart);
        }
    }

    protected static boolean isTrackSafeForHighSpeed(ITrackInstance track, py cart) {
        EnumTrackMeta meta = EnumTrackMeta.fromMeta(track.getBasicRailMetadata(cart));
        yc world = track.getWorld();
        int x = track.getX();
        int y = track.getY();
        int z = track.getZ();
        if (!meta.isStraightTrack()) {
            return false;
        }
        return meta.isNorthSouthTrack() ? !(!TrackSpeed.isTrackHighSpeedCapable(world, x, y, z + 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y + 1, z + 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y - 1, z + 1) || !TrackSpeed.isTrackHighSpeedCapable(world, x, y, z - 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y + 1, z - 1) && !TrackSpeed.isTrackHighSpeedCapable(world, x, y - 1, z - 1)) : !(!meta.isEastWestTrack() || !TrackSpeed.isTrackHighSpeedCapable(world, x + 1, y, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x + 1, y + 1, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x + 1, y - 1, z) || !TrackSpeed.isTrackHighSpeedCapable(world, x - 1, y, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x - 1, y + 1, z) && !TrackSpeed.isTrackHighSpeedCapable(world, x - 1, y - 1, z));
    }

    public static boolean isTrackHighSpeedCapable(yc world, int x, int y, int z) {
        if (!world.f(x, y, z)) {
            return true;
        }
        return TrackTools.isHighSpeedTrackAt(world, x, y, z);
    }

    protected static void testCartSpeedForBasic(ITrackInstance track, py cart) {
        boolean highSpeed = cart.getEntityData().n("HighSpeed");
        if (highSpeed) {
            TrackSpeed.testSafety(track, cart);
        } else {
            cart.w = Math.copySign(Math.min((double)0.39f, Math.abs(cart.w)), cart.w);
            cart.y = Math.copySign(Math.min((double)0.39f, Math.abs(cart.y)), cart.y);
        }
    }

    protected static void testCartSpeedForBooster(ITrackInstance track, py cart) {
        boolean highSpeed = cart.getEntityData().n("HighSpeed");
        if (highSpeed) {
            TrackSpeed.testSafety(track, cart);
        } else if (TrackSpeed.isTrackSafeForHighSpeed(track, cart)) {
            if (Math.abs(cart.w) > (double)0.39f) {
                cart.w = Math.copySign((double)0.4f, cart.w);
                cart.getEntityData().a("HighSpeed", true);
                cart.setMaxSpeedRail(RailcraftConfig.getMaxHighSpeed());
            }
            if (Math.abs(cart.y) > (double)0.39f) {
                cart.y = Math.copySign((double)0.4f, cart.y);
                cart.getEntityData().a("HighSpeed", true);
                cart.setMaxSpeedRail(RailcraftConfig.getMaxHighSpeed());
            }
        }
    }
}

