/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;

public class TrackOneWay
extends TrackBaseRailcraft
implements ITrackPowered,
ITrackReversable {
    private boolean reversed = false;
    private boolean powered = false;
    private static final double LOSS_FACTOR = 0.49;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.ONEWAY;
    }

    @Override
    public int getTextureIndex() {
        if (!this.isPowered()) {
            if (this.isReversed()) {
                return this.getTrackType().getTextureIndex() + 3;
            }
            return this.getTrackType().getTextureIndex() + 1;
        }
        if (this.isReversed()) {
            return this.getTrackType().getTextureIndex() + 2;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public void onMinecartPass(py cart) {
        int meta = this.tileEntity.p();
        if (this.isPowered()) {
            if (meta == 1 || meta == 2 || meta == 3) {
                if (this.isReversed() && cart.w > 0.0 || !this.isReversed() && cart.w < 0.0) {
                    double distX = cart.t - ((double)this.tileEntity.l + 0.5);
                    if (!this.isReversed() && distX < -0.01 || this.isReversed() && distX > 0.01) {
                        cart.b((double)this.tileEntity.l + 0.5, cart.u, cart.v);
                    }
                    cart.w = !this.isReversed() ? Math.abs(cart.w) * 0.49 : -Math.abs(cart.w) * 0.49;
                }
            } else if ((meta == 0 || meta == 4 || meta == 5) && (this.isReversed() && cart.y < 0.0 || !this.isReversed() && cart.y > 0.0)) {
                double distZ = cart.v - ((double)this.tileEntity.n + 0.5);
                if (this.isReversed() && distZ < -0.01 || !this.isReversed() && distZ > 0.01) {
                    cart.b(cart.t, cart.u, (double)this.tileEntity.n + 0.5);
                }
                cart.y = this.isReversed() ? Math.abs(cart.y) * 0.49 : -Math.abs(cart.y) * 0.49;
            }
        }
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("direction", this.reversed);
        nbttagcompound.a("powered", this.powered);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.n("direction");
        this.powered = nbttagcompound.n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

