/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import railcraft.common.api.tracks.ITrackLockdown;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.carts.LinkageManager;
import railcraft.common.carts.Train;

public abstract class TrackLockingBase
extends TrackBaseRailcraft
implements ITrackLockdown,
ITrackPowered {
    protected static double START_BOOST = 0.04;
    protected static double BOOST_FACTOR = 0.06;
    protected boolean powered = false;
    private py lockedCart;
    protected byte prevDelay = 0;
    protected byte delay = 0;
    private UUID uuid;

    @Override
    public int getTextureIndex() {
        if (this.isPowered() || this.delay > 0) {
            return this.getTrackType().getTextureIndex();
        }
        return this.getTrackType().getTextureIndex() + 1;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public py getCurrentCart() {
        return this.lockedCart;
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        this.setCurrentCart(null);
    }

    private UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    protected void setCurrentCart(py cart) {
        if (this.lockedCart != cart && this.lockedCart != null) {
            Train train = LinkageManager.getInstance(this.lockedCart.p).getTrain(this.lockedCart);
            train.removeLockingTrack(this.getUUID());
        }
        this.lockedCart = cart;
    }

    protected void lockCart(py cart) {
        if (cart != null) {
            Train train = LinkageManager.getInstance(cart.p).getTrain(cart);
            train.addLockingTrack(this.getUUID());
        }
    }

    protected void releaseCart(py cart) {
        if (cart != null) {
            Train train = LinkageManager.getInstance(cart.p).getTrain(cart);
            train.removeLockingTrack(this.getUUID());
        }
    }

    protected void checkCart(py cart) {
        if (this.delay > 0 && cart != this.lockedCart) {
            this.delay = 0;
            this.setCurrentCart(cart);
        }
    }

    protected byte getDelayTime() {
        return 3;
    }

    @Override
    public void releaseCart() {
        this.delay = (byte)10;
    }

    @Override
    public boolean isCartLockedDown(py cart) {
        return !this.powered && this.lockedCart == cart && this.delay == 0;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("powered", this.powered);
        data.a("uuidHigh", this.getUUID().getMostSignificantBits());
        data.a("uuidLow", this.getUUID().getLeastSignificantBits());
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.powered = data.n("powered");
        if (data.b("uuidHigh")) {
            this.uuid = new UUID(data.f("uuidHigh"), data.f("uuidLow"));
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.delay);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.delay = data.readByte();
        this.markBlockNeedsUpdate();
    }
}

