/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackGated;

public class TrackGatedOneWay
extends TrackGated
implements ITrackReversable,
ITrackPowered {
    private static final double MOTION_MIN = 0.2;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.GATED_ONEWAY;
    }

    @Override
    public int getTextureIndex() {
        int texture = this.getTrackType().getTextureIndex();
        if (this.isReversed()) {
            return texture + 1;
        }
        return texture;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.isGateOpen()) {
            int meta = this.tileEntity.p();
            if (meta == 0) {
                cart.y = this.isReversed() ? Math.max(Math.abs(cart.y), 0.2) : -Math.max(Math.abs(cart.y), 0.2);
            } else if (meta == 1) {
                cart.w = this.isReversed() ? -Math.max(Math.abs(cart.w), 0.2) : Math.max(Math.abs(cart.w), 0.2);
            }
        }
    }
}

