/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.effects.EffectManager;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TrackEmbarking
extends TrackBaseRailcraft
implements ITrackPowered,
IGuiReturnHandler {
    public static final Set excludedEntities = new HashSet();
    public static final byte MIN_AREA = 1;
    public static final byte MAX_AREA = 5;
    private boolean powered = false;
    private byte area = (byte)2;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.EMBARKING;
    }

    @Override
    public int getTextureIndex() {
        if (this.isPowered()) {
            return this.getTrackType().getTextureIndex();
        }
        return this.getTrackType().getTextureIndex() + 1;
    }

    @Override
    public boolean blockActivated(qx player) {
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)current.b();
            GuiHandler.openGui(EnumGui.TRACK_EMBARKING, player, this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.powered && cart.canBeRidden() && cart.n == null && cart.getEntityData().e("MountPrevention") <= 0) {
            byte a = this.area;
            aoe box = aoe.a().a((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)(this.getX() + 1), (double)(this.getY() + 1), (double)(this.getZ() + 1));
            box = box.b((double)a, (double)a, (double)a);
            List entities = this.getWorld().a(md.class, box);
            if (entities.size() > 0) {
                md entity = (md)entities.get(MiscTools.getRand().nextInt(entities.size()));
                if (entity instanceof qx) {
                    qx player = (qx)entity;
                    if (player.ah()) {
                        return;
                    }
                    ur current = player.bS();
                    if (current != null && current.b() instanceof IToolCrowbar) {
                        return;
                    }
                } else if (excludedEntities.contains(entity.getClass())) {
                    return;
                }
                if (entity.o == null) {
                    EffectManager.instance.teleportEffect((lq)entity, cart.t, cart.u, cart.v);
                    entity.a((lq)cart);
                }
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("powered", this.powered);
        data.a("area", this.area);
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.powered = data.n("powered");
        this.area = data.c("area");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.area);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        this.setArea(data.readByte());
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.area);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        byte a = data.readByte();
        if (this.area != a) {
            this.setArea(a);
            this.sendUpdateToClient();
        }
    }

    public void setArea(byte radius) {
        radius = (byte)Math.max(1, radius);
        this.area = radius = (byte)Math.min(5, radius);
    }

    public byte getArea() {
        return this.area;
    }

    static {
        excludedEntities.add(pi.class);
        excludedEntities.add(pp.class);
        excludedEntities.add(pr.class);
        excludedEntities.add(qa.class);
        excludedEntities.add(qo.class);
        excludedEntities.add(qi.class);
        excludedEntities.add(ph.class);
    }
}

