/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;

public class TrackDisembark
extends TrackBaseRailcraft
implements ITrackPowered {
    private static final int TIME_TILL_NEXT_MOUNT = 40;
    private boolean powered = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.DISEMBARK;
    }

    @Override
    public int getTextureIndex() {
        if (this.isPowered()) {
            return this.getTrackType().getTextureIndex();
        }
        return this.getTrackType().getTextureIndex() + 1;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.powered && cart.canBeRidden() && cart.n != null) {
            cart.n.a((lq)cart);
            cart.getEntityData().a("MountPrevention", 40);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("powered", this.powered);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }
}

