/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackEmitter;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.util.misc.Game;

public class TrackDetectorDirection
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackEmitter {
    private boolean reversed = false;
    private byte delay = 0;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.DETECTOR_DIRECTION;
    }

    @Override
    public int getTextureIndex() {
        if (this.isTrackPowering()) {
            if (this.isReversed()) {
                return this.getTrackType().getTextureIndex() + 3;
            }
            return this.getTrackType().getTextureIndex() + 1;
        }
        if (this.isReversed()) {
            return this.getTrackType().getTextureIndex() + 2;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.delay > 0) {
            this.delay = (byte)(this.delay - 1);
            if (this.delay == 0) {
                this.notifyNeighbors();
            }
        }
    }

    @Override
    public void onMinecartPass(py cart) {
        int meta = this.tileEntity.p();
        if (meta == 1 || meta == 2 || meta == 3) {
            if (this.isReversed() && cart.w < 0.0 || !this.isReversed() && cart.w > 0.0) {
                this.setTrackPowering();
            }
        } else if ((meta == 0 || meta == 4 || meta == 5) && (this.isReversed() && cart.y > 0.0 || !this.isReversed() && cart.y < 0.0)) {
            this.setTrackPowering();
        }
    }

    private void notifyNeighbors() {
        this.getWorld().h(this.getX(), this.getY(), this.getZ(), RailcraftBlocks.getBlockTrack().cm);
        this.getWorld().h(this.getX(), this.getY() - 1, this.getZ(), RailcraftBlocks.getBlockTrack().cm);
        this.sendUpdateToClient();
    }

    private void setTrackPowering() {
        boolean notify = this.delay == 0;
        this.delay = (byte)3;
        if (notify) {
            this.notifyNeighbors();
        }
    }

    @Override
    public boolean isTrackPowering() {
        return this.delay > 0;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("direction", this.reversed);
        nbttagcompound.a("delay", this.delay);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.n("direction");
        this.delay = nbttagcompound.c("delay");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.delay);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.delay = data.readByte();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

