/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;

public class TrackCoupler
extends TrackBaseRailcraft
implements ITrackPowered {
    private py taggedCart;
    private boolean powered = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.COUPLER;
    }

    @Override
    public int getTextureIndex() {
        if (this.isPowered()) {
            return this.getTrackType().getTextureIndex();
        }
        return this.getTrackType().getTextureIndex() + 1;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.isPowered()) {
            ILinkageManager lm = CartTools.getLinkageManager(cart.p);
            lm.createLink(this.taggedCart, cart);
            this.taggedCart = cart;
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("powered", this.powered);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }
}

