/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SignalReceiver;
import railcraft.common.api.signals.SimpleSignalReceiver;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.TileSignalBase;
import railcraft.common.util.misc.Game;

public class TileSignalDistantSignal
extends TileSignalBase
implements IReceiverTile {
    private boolean isPairedWithController;
    private int controllerX = -1;
    private int controllerY = -1;
    private int controllerZ = -1;
    private boolean prevBlinkState;
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.DISTANT_SIGNAL;
    }

    @Override
    public void g() {
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            this.receiver.tickClient();
            if (this.update % 4 == 0 && this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.k.c(yo.b, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.sendUpdateToClient();
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.receiver.readFromNBT(data);
        if (data.b("ControllerX")) {
            int cx = data.e("ControllerX");
            int cy = data.e("ControllerY");
            int cz = data.e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
    }

    @Override
    public SignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.receiver.getAspect();
    }
}

