/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import buildcraft.api.tools.IToolWrench;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.signals.ISignalTile;
import railcraft.common.blocks.signals.Signals;
import railcraft.common.blocks.signals.TileSignalFoundation;
import railcraft.common.util.misc.MiscTools;

public abstract class TileSignalBase
extends TileSignalFoundation
implements ISignalTile {
    protected static final float BOUNDS = 0.15f;
    private ForgeDirection facing = ForgeDirection.NORTH;
    protected int update = MiscTools.getRand().nextInt();

    @Override
    public boolean blockActivated(int side, qx player) {
        IToolWrench wrench;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolWrench && side != ForgeDirection.UP.ordinal() && side != ForgeDirection.DOWN.ordinal() && (wrench = (IToolWrench)current.b()).canWrench(player, this.l, this.m, this.n)) {
            this.facing = this.facing.ordinal() == side ? MiscTools.getOppositeSide(side) : ForgeDirection.getOrientation((int)side);
            wrench.wrenchUsed(player, this.l, this.m, this.n);
            this.markBlockForUpdate();
            return true;
        }
        return super.blockActivated(side, player);
    }

    @Override
    public void setBlockBoundsBasedOnState(ym world, int i, int j, int k) {
        this.getBlock().a(0.15f, 0.35f, 0.15f, 0.85f, 1.0f, 0.85f);
    }

    @Override
    public aoe getSelectedBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.15f), (double)((float)j + 0.35f), (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.15f), (double)((float)j + 0.35f), (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    public boolean canUpdate() {
        return true;
    }

    public void g() {
    }

    public void setFacing(ForgeDirection facing) {
        this.facing = facing;
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public void onBlockPlacedBy(md entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.k, this.l, this.m, this.n, entityliving);
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("Facing", (byte)this.facing.ordinal());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.facing = ForgeDirection.getOrientation((int)data.c("Facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public abstract SignalAspect getSignalAspect();

    @Override
    public int getLightValue() {
        if (Signals.isAspectLit(this.getSignalAspect())) {
            return 5;
        }
        return 0;
    }
}

