/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SimpleSignalReceiver;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.IAspectActionManager;
import railcraft.common.blocks.signals.ItemSignalTuner;
import railcraft.common.blocks.signals.TileBoxBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileBoxReceiver
extends TileBoxBase
implements IAspectActionManager,
IGuiReturnHandler,
IReceiverTile {
    protected int update = MiscTools.getRand().nextInt();
    private boolean prevBlinkState;
    private boolean[] powerOnAspects = new boolean[SignalAspect.values().length];
    private final SimpleSignalReceiver receiver = new SimpleSignalReceiver(this.b(), this);

    public TileBoxReceiver() {
        this.powerOnAspects[SignalAspect.GREEN.ordinal()] = true;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_RECEIVER;
    }

    @Override
    public boolean blockActivated(int side, qx player) {
        if (player.ah()) {
            return false;
        }
        ur current = player.bS();
        if (current != null && current.b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_RECEIVER, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public void g() {
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            this.receiver.tickClient();
            if (this.receiver.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        SignalAspect prevAspect = this.receiver.getAspect();
        if (this.receiver.isBeingPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (!this.receiver.isPaired()) {
            this.receiver.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.receiver.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.updateNeighbors();
        this.sendUpdateToClient();
    }

    private void updateNeighbors() {
        int blockID = this.getBlockId();
        this.k.h(this.l, this.m, this.n, blockID);
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this);
        }
    }

    @Override
    public boolean isPoweringTo(ym world, int i, int j, int k, int side) {
        any tile = MiscTools.getBlockTileEntityOnSide(this.k, i, j, k, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return false;
        }
        return this.powerOnAspects[this.receiver.getAspect().ordinal()];
    }

    @Override
    public void b(bq data) {
        super.b(data);
        byte[] array = new byte[this.powerOnAspects.length];
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            array[i] = (byte)(this.powerOnAspects[i] ? 1 : 0);
        }
        data.a("PowerOnAspect", array);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        if (data.b("PowerOnAspect")) {
            byte[] array = data.j("PowerOnAspect");
            for (int i = 0; i < this.powerOnAspects.length; ++i) {
                this.powerOnAspects[i] = array[i] == 1;
            }
        }
        this.receiver.readFromNBT(data);
        if (data.b("ControllerX")) {
            int cx = data.e("ControllerX");
            int cy = data.e("ControllerY");
            int cz = data.e("ControllerZ");
            this.receiver.registerLegacyController(cx, cy, cz);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
        this.readGuiData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        int bits = 0;
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            bits = (byte)(bits | (this.powerOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        byte bits = data.readByte();
        for (int bit = 0; bit < this.powerOnAspects.length; ++bit) {
            this.powerOnAspects[bit] = (bits >> bit & 1) == 1;
        }
        this.updateNeighbors();
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        any tile = this.k.q(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public boolean isEmitingRedstone() {
        return this.powerOnAspects[this.receiver.getAspect().ordinal()];
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.powerOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.powerOnAspects[aspect.ordinal()] = trigger;
        this.updateNeighbors();
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.receiver.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }

    @Override
    public SimpleSignalReceiver getReceiver() {
        return this.receiver;
    }
}

