/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.gamma.TileLoaderBase;
import railcraft.common.liquids.TankManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public abstract class TileLoaderLiquidBase
extends TileLoaderBase
implements la,
ITankContainer {
    protected final TankManager tankManager = new TankManager();
    protected int update = MiscTools.getRand().nextInt();

    protected TileLoaderLiquidBase() {
        this.setInventorySize(2);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void g() {
        super.g();
        ++this.update;
        if (Game.isHost(this.getWorld()) && this.update % 128 == 0) {
            this.sendUpdateToClient();
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.tankManager.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(tankIndex, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        return this.tankManager.getTanks();
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tankManager.getTank(0);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        if (data.a("tanks") instanceof bq) {
            data.a("tanks", (cd)new by());
        }
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
    }
}

