/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.tools.IToolWrench;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import ic2.api.IWrenchable;
import ic2.api.energy.tile.IEnergyTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.blocks.machine.gamma.TileLoaderBase;
import railcraft.common.modules.ModuleIC2;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.IEnergyDevice;
import railcraft.common.util.misc.MiscTools;

public abstract class TileLoaderEnergyBase
extends TileLoaderBase
implements IWrenchable,
IEnergyDevice,
ISidedInventory,
IEnergyTile {
    private static final int SLOT_CHARGE = 0;
    private static final int SLOT_BATTERY = 1;
    private static final int TIER = 2;
    private static final int CAPACITY = 100000;
    private static final int MAX_OVERCLOCKS = 10;
    private static final int MAX_LAPOTRON = 9;
    protected int energy;
    private int prevEnergy;
    protected int transferRate;
    protected short storageUpgrades;
    protected short lapotronUpgrades;
    protected short transformerUpgrades;
    protected short overclockerUpgrades;
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected int update;
    private boolean addedToIC2EnergyNet;

    public TileLoaderEnergyBase() {
        this.setInventorySize(6);
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    @Override
    public void onBlockPlacedBy(md entityliving) {
        super.onBlockPlacedBy(entityliving);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.direction = MiscTools.getSideClosestToPlayer(this.k, this.l, this.m, this.n, entityliving);
    }

    protected void countUpgrades() {
        ur storage = IC2Plugin.getItem("energyStorageUpgrade");
        ur overclocker = IC2Plugin.getItem("overclockerUpgrade");
        ur transformer = IC2Plugin.getItem("transformerUpgrade");
        up lapotron = ModuleIC2.lapotronUpgrade;
        this.storageUpgrades = 0;
        this.overclockerUpgrades = 0;
        this.transformerUpgrades = 0;
        this.lapotronUpgrades = 0;
        for (int i = 2; i < 6; ++i) {
            ur stack = this.a(i);
            if (stack == null) continue;
            if (storage != null && stack.a(storage)) {
                this.storageUpgrades = (short)(this.storageUpgrades + stack.a);
                continue;
            }
            if (overclocker != null && stack.a(overclocker)) {
                this.overclockerUpgrades = (short)(this.overclockerUpgrades + stack.a);
                continue;
            }
            if (transformer != null && stack.a(transformer)) {
                this.transformerUpgrades = (short)(this.transformerUpgrades + stack.a);
                continue;
            }
            if (lapotron == null || stack.c != lapotron.cj) continue;
            this.lapotronUpgrades = (short)(this.lapotronUpgrades + stack.a);
        }
        if (this.overclockerUpgrades > 10) {
            this.overclockerUpgrades = (short)10;
        }
        if (this.lapotronUpgrades > 9) {
            this.lapotronUpgrades = (short)9;
        }
    }

    public void d() {
        super.d();
        this.countUpgrades();
    }

    @Override
    public void g() {
        ur battery;
        ur charge;
        int capacity;
        super.g();
        ++this.update;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.addedToIC2EnergyNet) {
            IC2Plugin.addTileToNet(this);
            this.addedToIC2EnergyNet = true;
        }
        if (this.energy > (capacity = this.getCapacity())) {
            this.energy = capacity;
        }
        if (Game.isHost(this.getWorld()) && this.prevEnergy != this.energy && this.update % 4 == 0) {
            this.prevEnergy = this.energy;
            this.markBlockForUpdate();
        }
        if ((charge = this.a(0)) != null && charge.b() instanceof IElectricItem && this.energy > 0) {
            this.energy -= ElectricItem.charge(charge, this.energy, this.getTier(), false, false);
        }
        if ((battery = this.a(1)) != null && battery.b() instanceof IElectricItem && ((IElectricItem)battery.b()).canProvideEnergy() && this.energy < capacity) {
            this.energy += ElectricItem.discharge(battery, capacity - this.energy, this.getTier(), false, false);
        }
        if (this.update % 64 == 0) {
            this.countUpgrades();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.addedToIC2EnergyNet) {
            IC2Plugin.removeTileFromNet(this);
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToIC2EnergyNet;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("energy", this.energy);
        data.a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.energy = data.e("energy");
        this.direction = ForgeDirection.getOrientation((int)data.c("direction"));
        this.countUpgrades();
        this.update = MiscTools.getRand().nextInt();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.getFacing());
        data.writeShort(this.storageUpgrades);
        data.writeShort(this.lapotronUpgrades);
        data.writeInt(this.energy);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setFacing(data.readByte());
        this.storageUpgrades = data.readShort();
        this.lapotronUpgrades = data.readShort();
        this.energy = data.readInt();
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        IToolWrench wrench;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolWrench && (wrench = (IToolWrench)current.b()).canWrench(player, this.l, this.m, this.n)) {
            this.direction = this.direction.ordinal() == side ? MiscTools.getOppositeSide(side) : ForgeDirection.getOrientation((int)side);
            wrench.wrenchUsed(player, this.l, this.m, this.n);
            this.markBlockForUpdate();
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return this.direction.ordinal() != side;
    }

    @Override
    public short getFacing() {
        return (short)this.direction.ordinal();
    }

    @Override
    public void setFacing(short side) {
        if (this.direction.ordinal() != side) {
            this.direction = ForgeDirection.getOrientation((int)side);
            this.sendUpdateToClient();
        }
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        return this.getMachineType().getItem();
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getCapacity() {
        int capacity = 100000;
        capacity += this.storageUpgrades * 10000;
        return capacity += this.lapotronUpgrades * 1000000;
    }

    public int getTier() {
        return 2 + this.transformerUpgrades;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    @Override
    public int getEnergyBarScaled(int scale) {
        return this.getEnergy() * scale / this.getCapacity();
    }
}

