/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.fuel.FuelManager;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidFilter;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.BoilerFuelTank;
import railcraft.common.liquids.tanks.FakeTank;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;

public class TileBoilerFireboxLiquid
extends TileBoilerFirebox {
    private static final int TANK_FUEL = 2;

    public TileBoilerFireboxLiquid() {
        super(2);
        this.tankManager.addTank(new BoilerFuelTank(16000));
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_LIQUID;
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_LIQUID, player, this.k, mBlock.l, mBlock.m, mBlock.n);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleClick(qx player) {
        if (LiquidManager.getInstance().handleRightClick(this, 2, player, true, false)) {
            return true;
        }
        return super.handleClick(player);
    }

    @Override
    protected void process() {
    }

    @Override
    protected void processBuckets() {
        super.processBuckets();
        LiquidManager.getInstance().processContainers(this, 2, this.inventory, 0, 1, true, false);
    }

    @Override
    protected float getMoreFuel() {
        LiquidStack fuel = this.tankManager.drain(2, 1000, false);
        if (fuel == null) {
            return 0.0f;
        }
        float heatValue = FuelManager.getBoilerFuelValue(fuel);
        if (heatValue > 0.0f) {
            this.tankManager.drain(2, 1000, true);
            if (fuel.amount < 1000) {
                heatValue *= (float)fuel.amount / 1000.0f;
            }
        }
        return heatValue;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        LiquidStack liquid = LiquidManager.getInstance().getLiquidInContainer(stack);
        if (liquid == null) {
            return 0;
        }
        if (liquid.isLiquidEqual(LiquidFilter.WATER) || FuelManager.getBoilerFuelValue(liquid) > 0) {
            ur remainder;
            la inv = this.invWaterInput;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remainder.a;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this.invWaterOutput;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (LiquidFilter.WATER.isLiquidEqual(resource)) {
            return this.fill(0, resource, doFill);
        }
        return this.fill(2, resource, doFill);
    }

    @Override
    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            switch (side) {
                case DOWN: {
                    return new TileBoilerFirebox.WaterTankWrapper((ILiquidTank)tMan.getTank(0));
                }
            }
            return tMan.getTank(2);
        }
        return FakeTank.INSTANCE;
    }
}

