/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.TileTank;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.slots.SlotWaterOrEmpty;
import railcraft.common.liquids.LiquidFilter;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.FilteredTank;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileTankWater
extends TileTank
implements ISpecialInventory {
    private static final int OUTPUT_RATE = 40;
    private static final int TANK_CAPACITY = 400000;
    private static final int REFILL_INTERVAL = 8;
    private static final float REFILL_RATE = 10.0f;
    private static final float REFILL_PENALTY_INSIDE = 0.5f;
    private static final float REFILL_PENALTY_SNOW = 0.5f;
    private static final float REFILL_BOOST_RAIN = 3.0f;
    private static final byte REFILL_RATE_MIN = 1;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final List patterns = new ArrayList();
    private la invInput = new InventoryMapper(this, 0, 1);
    private la invOutput = new InventoryMapper(this, 1, 1);
    private boolean testOutputs = true;
    private ITankContainer[] outputs = new ITankContainer[6];

    public TileTankWater() {
        super("gui.tank.water", 2, patterns);
        FilteredTank tank = new FilteredTank(400000, new LiquidStack(amq.E, 0));
        tank.setTankPressure(1);
        this.tankManager.addTank(tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.TANK_WATER;
    }

    @Override
    public sr getInputSlot(la inv, int id, int x, int y) {
        return new SlotWaterOrEmpty(inv, id, x, y);
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        if (Game.isHost(this.k) ? this.isStructureValid() && LiquidManager.getInstance().handleRightClick(this.getTankManager(), 0, player, true, true) : LiquidManager.getInstance().isContainer(player.bJ.g())) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public void g() {
        super.g();
        if (Game.isHost(this.getWorld())) {
            TankManager tMan;
            if (this.isMaster()) {
                if (this.k.u.h != -1 && this.update % 8 == 0) {
                    float rate = 10.0f;
                    yy biome = this.k.a(this.l, this.n);
                    float humidity = biome.G;
                    rate *= humidity;
                    boolean outside = false;
                    for (int x = this.l; x < this.l + 3; ++x) {
                        for (int z = this.n; z < this.n + 3 && !(outside = this.k.k(x, this.m + 3, z)); ++z) {
                        }
                    }
                    if (!outside) {
                        rate *= 0.5f;
                    } else if (this.k.N()) {
                        rate = biome.c() ? (rate *= 0.5f) : (rate *= 3.0f);
                    }
                    int rateFinal = ke.d((float)rate);
                    if (rateFinal < 1) {
                        rateFinal = 1;
                    }
                    LiquidStack fillStack = new LiquidStack(amq.E, rateFinal);
                    this.fill(0, fillStack, true);
                }
                if (this.update % 8 == 0) {
                    LiquidManager.getInstance().processContainers(this.tankManager.getTank(0), this, 0, 1);
                }
            }
            if ((tMan = this.getTankManager()) != null) {
                this.findOutputs();
                tMan.outputLiquid(this.outputs, 0, 40);
            }
        }
    }

    @Override
    public ITankContainer getOutputOnSide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return null;
        }
        return super.getOutputOnSide(side);
    }

    private void findOutputs() {
        if (this.testOutputs) {
            this.testOutputs = false;
            for (int side = 0; side < 6; ++side) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!MiscTools.blockExistsOnSide(this.k, this.l, this.m, this.n, dir)) {
                    this.testOutputs = true;
                    this.outputs[side] = null;
                    continue;
                }
                this.outputs[side] = this.getOutputOnSide(dir);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        super.onNeighborBlockChange(id);
        this.testOutputs = true;
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.TANK, player, this.k, mBlock.l, mBlock.m, mBlock.n);
            return true;
        }
        return false;
    }

    @Override
    public int getBlockTexture(int side) {
        return EnumMachineAlpha.TANK_WATER.getTexture(side);
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UP) {
            return 0;
        }
        return this.fill(0, resource, doFill);
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex != 0 || resource == null || resource.itemID != amq.E.cm) {
            return 0;
        }
        return super.fill(tankIndex, resource, doFill);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (stack == null) {
            return 0;
        }
        LiquidManager lm = LiquidManager.getInstance();
        if (lm.isContainer(stack) && (lm.isEmptyContainer(stack) || lm.containsLiquid(stack, LiquidFilter.WATER))) {
            ur remainder;
            la inv = this.invInput;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remainder.a;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this.invOutput;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'A', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

