/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.tools.IToolWrench;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.TileMultiBlockInventory;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.blocks.machine.beta.ISteamUser;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidFilter;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.FakeTank;
import railcraft.common.liquids.tanks.FilteredTank;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.effects.EffectManager;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.sounds.SoundHelper;

public class TileSteamOven
extends TileMultiBlockInventory
implements ITankContainer,
ISpecialInventory,
ISidedInventory,
ISteamUser {
    private static final int STEAM_PER_BATCH = 8000;
    private static final int TOTAL_COOK_TIME = 256;
    private static final int COOK_STEP = 16;
    private static final int ITEMS_SMELTED = 9;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 9;
    private static final int TANK_CAPACITY = 8000;
    private static final List patterns = new ArrayList();
    private ForgeDirection facing = ForgeDirection.NORTH;
    public int cookTime;
    public boolean finishedCycle = false;
    private final TankManager tankManager = new TankManager();
    private final StandardTank tank;
    private la invInput = new InventoryMapper(this, 0, 9);
    private la invOutput = new InventoryMapper(this, 9, 9);

    public TileSteamOven() {
        super("gui.steam.oven", 18, patterns);
        this.tank = new FilteredTank(8000, LiquidFilter.STEAM);
        this.tankManager.addTank(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.STEAM_OVEN;
    }

    public TankManager getTankManager() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.isStructureValid() && side == this.getFacing().ordinal()) {
            switch (side) {
                case 2: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionX() == 2) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionX() == 2) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
                case 3: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionX() == 1) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionX() == 1) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
                case 4: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionZ() == 1) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionZ() == 1) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
                case 5: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionZ() == 2) {
                            return this.getMachineType().getTexture(6);
                        }
                        return this.getMachineType().getTexture(7);
                    }
                    if (this.getPatternPositionZ() == 2) {
                        return this.getMachineType().getTexture(8);
                    }
                    return this.getMachineType().getTexture(9);
                }
            }
        }
        if (side > 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(0);
    }

    public int getCookProgressScaled(int i) {
        int scale = this.getCookTime() * i / 256;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    public int getCookTime() {
        TileSteamOven masterOven = (TileSteamOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cookTime;
        }
        return -1;
    }

    public ForgeDirection getFacing() {
        TileSteamOven masterOven = (TileSteamOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.facing;
        }
        return this.facing;
    }

    public boolean hasFinishedCycle() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        return mBlock != null && mBlock.finishedCycle;
    }

    public void setHasFinishedCycle(boolean finished) {
        if (this.finishedCycle != finished) {
            this.finishedCycle = finished;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.getWorld())) {
            if (this.hasFinishedCycle()) {
                EffectManager.instance.steamEffect(this.k, this, 0.25);
            }
            return;
        }
        if (this.isMaster() && this.update % 16 == 0) {
            this.setHasFinishedCycle(false);
            if (this.cookTime <= 0 && this.hasRecipe() && this.drainSteam()) {
                this.cookTime = 1;
            } else if (this.cookTime > 0 && this.hasRecipe()) {
                this.cookTime += 16;
                if (this.cookTime >= 256 && this.smeltItems()) {
                    this.cookTime = 0;
                    this.setHasFinishedCycle(true);
                    SoundHelper.playSound(this.k, this.l, this.m, this.n, "machine.steamburst", 1.0f, (float)(1.0 + MiscTools.getRand().nextGaussian() * 0.1));
                }
            } else {
                this.cookTime = 0;
            }
        }
    }

    private boolean drainSteam() {
        LiquidStack steam = this.tank.drain(8000, false);
        if (steam != null && steam.amount >= 8000) {
            this.tank.drain(8000, true);
            return true;
        }
        return false;
    }

    private boolean hasRecipe() {
        for (int slot = 0; slot < 9; ++slot) {
            ur stack = this.invInput.a(slot);
            if (stack == null || wj.a().getSmeltingResult(stack) == null) continue;
            return true;
        }
        return false;
    }

    private boolean smeltItems() {
        int count = 0;
        boolean changed = true;
        boolean smelted = false;
        while (count < 9 && changed) {
            changed = false;
            for (int slot = 0; slot < 9; ++slot) {
                ur remainder;
                ur output;
                ur stack = this.invInput.a(slot);
                if (stack == null || (output = wj.a().getSmeltingResult(stack)) == null || !InvTools.isRoomForStack(output, this.invOutput) || (remainder = InvTools.moveItemStack(output.l(), this.invOutput)) != null) continue;
                this.invInput.a(slot, 1);
                changed = true;
                ++count;
            }
            smelted |= changed;
        }
        return smelted;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 0;
            }
        }
        return 9;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 9;
    }

    @Override
    public void onBlockPlacedBy(md player) {
        super.onBlockPlacedBy(player);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.k, this.l, this.m, this.n, player);
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        TileSteamOven master;
        IToolWrench wrench;
        ur current;
        if (side > 1 && Game.isHost(this.k) && (current = player.bS()) != null && current.b() instanceof IToolWrench && (wrench = (IToolWrench)current.b()).canWrench(player, this.l, this.m, this.n) && (master = (TileSteamOven)this.getMasterBlock()) != null) {
            master.facing = master.facing.ordinal() == side ? MiscTools.getOppositeSide(side) : ForgeDirection.getOrientation((int)side);
            wrench.wrenchUsed(player, this.l, this.m, this.n);
            master.retestMasterBlock();
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.STEAN_OVEN, player, this.k, masterBlock.l, masterBlock.m, masterBlock.n);
            return true;
        }
        return false;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
        data.a("cookTime", this.cookTime);
        data.a("facing", (byte)this.facing.ordinal());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.tankManager.readTanksFromNBT(data);
        this.cookTime = data.e("cookTime");
        this.facing = ForgeDirection.getOrientation((int)data.c("facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.facing.ordinal());
        data.writeBoolean(this.finishedCycle);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte f = data.readByte();
        this.finishedCycle = data.readBoolean();
        if (f != this.facing.ordinal()) {
            this.facing = ForgeDirection.getOrientation((int)f);
            this.markBlockForUpdate();
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TankManager tMan = this.getTankManager();
        if (tMan == null) {
            return 0;
        }
        return tMan.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            if (stack == null) {
                return 0;
            }
            if (wj.a().getSmeltingResult(stack) != null) {
                ur remainder;
                la inv = mBlock.invInput;
                if (!doAdd) {
                    inv = new InventoryCopy(inv);
                }
                if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                    return stack.a;
                }
                return stack.a - remainder.a;
            }
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            la inv = mBlock.invOutput;
            if (!doRemove) {
                inv = new InventoryCopy(inv);
            }
            return InvTools.removeItems(inv, maxItemCount);
        }
        return new ur[0];
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTank(0);
        }
        return FakeTank.INSTANCE;
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map));
    }
}

