/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineItem;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.indicator.IIndicatorController;
import railcraft.common.gui.util.ToolTip;
import railcraft.common.plugins.buildcraft.actions.EnumTriggerActions;
import railcraft.common.plugins.buildcraft.triggers.IHasWork;
import railcraft.common.util.crafting.RollingMachineCraftingManager;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.ItemStackSizeSorter;
import railcraft.common.util.misc.Game;

public class TileRollingMachine
extends TileMachineItem
implements ISpecialInventory,
IPowerReceptor,
ISidedInventory,
IHasWork {
    private static final int PROCESS_TIME = 100;
    private static final int ACTIVATION_POWER = 5;
    private static final int MAX_RECEIVE = 100;
    private static final int MAX_ENERGY = 500;
    private ry craftMatrix = new ry((rq)new RollingContainer(), 3, 3);
    private la invResult = new InventoryMapper(this, 0, 1);
    private la invBuffer = new InventoryMapper(this, 1, 4);
    private IPowerProvider provider;
    public boolean useLast;
    private boolean isWorking;
    private boolean paused;
    private int progress;
    private int update;
    public int guiEnergy;
    private final Set actions = new HashSet();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public TileRollingMachine() {
        super(5);
        if (PowerFramework.currentFramework != null) {
            this.provider = PowerFramework.currentFramework.createPowerProvider();
            this.initPowerProvider();
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROLLING_MACHINE;
    }

    private void initPowerProvider() {
        if (PowerFramework.currentFramework != null) {
            this.provider.configure(0, 1, 100, 5, 500);
            this.provider.configurePowerPerdition(1, 40);
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.provider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.provider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest() {
        if (this.provider != null) {
            return (int)Math.ceil(Math.min((float)this.provider.getMaxEnergyReceived(), (float)this.provider.getMaxEnergyStored() - this.provider.getEnergyStored()));
        }
        return 0;
    }

    @Override
    public int getBlockTexture(int side) {
        return EnumMachineAlpha.ROLLING_MACHINE.getTexture(side);
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("progress", this.progress);
        if (this.provider != null) {
            PowerFramework.currentFramework.savePowerProvider(this, data);
        }
        by nbttaglist = new by();
        for (int i = 0; i < this.craftMatrix.k_(); ++i) {
            if (this.craftMatrix.a(i) == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.craftMatrix.a(i).b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        data.a("Crafting", (cd)nbttaglist);
    }

    @Override
    public void a(bq data) {
        int i;
        super.a(data);
        this.progress = data.e("progress");
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.loadPowerProvider(this, data);
            this.initPowerProvider();
        }
        by nbttaglist = data.m("Crafting");
        for (i = 0; i < this.craftMatrix.k_(); ++i) {
            this.craftMatrix.a(i, null);
        }
        for (i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            int j = nbttagcompound1.c("Slot") & 0xFF;
            if (j < 0 || j >= this.craftMatrix.k_()) continue;
            this.craftMatrix.a(j, ur.a((bq)nbttagcompound1));
        }
    }

    @Override
    public boolean openGui(qx player) {
        if (player.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) > 64.0) {
            return false;
        }
        GuiHandler.openGui(EnumGui.ROLLING_MACHINE, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 1;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 4;
            }
        }
        return 1;
    }

    public void d() {
        this.craftMatrix.d();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory((la)this.craftMatrix, this.k, this.l, this.m, this.n);
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 100;
    }

    public ry getCraftMatrix() {
        return this.craftMatrix;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        ++this.update;
        if (Game.isNotHost(this.k)) {
            return;
        }
        if (PowerFramework.currentFramework != null) {
            this.provider.update(this);
        }
        for (int inputSlot = 0; inputSlot < this.invBuffer.k_(); ++inputSlot) {
            ur inputStack = this.invBuffer.a(inputSlot);
            if (inputStack == null) continue;
            if (inputStack.a <= 0) {
                this.invBuffer.a(inputSlot, null);
                continue;
            }
            if (!inputStack.e()) {
                this.invBuffer.a(inputSlot, null);
                InvTools.dropItem(inputStack, this.k, this.l, this.m, this.n);
                continue;
            }
            ur outputStack = null;
            for (int recipeSlot = 0; recipeSlot < this.craftMatrix.k_(); ++recipeSlot) {
                ur craftingStack = this.craftMatrix.a(recipeSlot);
                if (!InvTools.isItemEqual(inputStack, craftingStack) || outputStack != null && craftingStack.a >= outputStack.a) continue;
                outputStack = craftingStack;
            }
            if (outputStack != null && outputStack.a < outputStack.d()) {
                this.invBuffer.a(inputSlot, 1);
                ++outputStack.a;
                break;
            }
            if (outputStack != null) continue;
            this.invBuffer.a(inputSlot, null);
            InvTools.dropItem(inputStack, this.k, this.l, this.m, this.n);
        }
        List chests = InvTools.getAdjacentInventories(this.k, this.l, this.m, this.n, anm.class);
        for (int slot = 0; slot < this.craftMatrix.k_(); ++slot) {
            ur stack = this.craftMatrix.a(slot);
            if (stack == null || !stack.e() || stack.a != 1) continue;
            for (la inv : chests) {
                ur request = InvTools.removeOneItem(inv, stack);
                if (request == null) continue;
                ++stack.a;
                break;
            }
            if (stack.a > 1) break;
        }
        if (this.update % 16 == 0) {
            this.processActions();
        }
        if (this.paused) {
            return;
        }
        ur recipe = RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.k);
        if (recipe != null && this.canMakeMore()) {
            if (this.progress >= 100) {
                this.isWorking = false;
                if (InvTools.isRoomForStack(recipe, this.invResult)) {
                    for (int i = 0; i < this.craftMatrix.k_(); ++i) {
                        this.craftMatrix.a(i, 1);
                    }
                    InvTools.moveItemStack(recipe, this.invResult);
                    this.useLast = false;
                    this.progress = 0;
                }
            } else {
                this.isWorking = true;
                if (PowerFramework.currentFramework != null) {
                    float energy = this.getPowerProvider().useEnergy(5.0f, 5.0f, true);
                    if (energy >= 5.0f) {
                        ++this.progress;
                    }
                } else {
                    ++this.progress;
                }
            }
        } else {
            this.progress = 0;
            this.isWorking = false;
        }
    }

    @Override
    public boolean hasWork() {
        return this.isWorking;
    }

    public void setPaused(boolean p) {
        this.paused = p;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != EnumTriggerActions.PAUSE.getAction()) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        this.actions.add(action);
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        ur slot;
        if (stack == null || !stack.e() || stack.a <= 0) {
            return 0;
        }
        stack = stack.l();
        Object inv = this.craftMatrix;
        if (!doAdd) {
            inv = new InventoryCopy((la)inv);
        }
        ArrayList<ur> slots = new ArrayList<ur>();
        for (int i = 0; i < inv.k_(); ++i) {
            slot = inv.a(i);
            if (!InvTools.isItemEqual(slot, stack)) continue;
            slots.add(slot);
        }
        if (!slots.isEmpty()) {
            int used = 0;
            while (stack.a > 0) {
                ItemStackSizeSorter.sort(slots);
                slot = (ur)slots.get(0);
                if (slot.a >= slot.d()) break;
                ++slot.a;
                --stack.a;
                ++used;
            }
            return used;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int max) {
        la inv = this.invResult;
        if (!doRemove) {
            inv = new InventoryCopy(this.invResult);
        }
        return InvTools.removeItems(inv, max);
    }

    public boolean canMakeMore() {
        if (RollingMachineCraftingManager.getInstance().findMatchingRecipe(this.craftMatrix, this.k) == null) {
            return false;
        }
        if (this.useLast) {
            return true;
        }
        for (int i = 0; i < this.craftMatrix.k_(); ++i) {
            ur slot = this.craftMatrix.a(i);
            if (slot == null || slot.a > 1) continue;
            return false;
        }
        return true;
    }

    private static class RollingContainer
    extends rq {
        private RollingContainer() {
        }

        public boolean a(qx entityplayer) {
            return true;
        }
    }

    private class EnergyIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private EnergyIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%d MJ", TileRollingMachine.this.guiEnergy);
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileRollingMachine.this.guiEnergy, 500);
            return (int)(e * (float)size / 500.0f);
        }
    }
}

