/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineItem;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.beta.TileSentinel;
import railcraft.common.carts.ItemCartAnchor;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.effects.EffectManager;
import railcraft.common.util.misc.ChunkManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.IAnchor;
import railcraft.common.util.misc.MiscTools;

public class TileAnchorWorld
extends TileMachineItem
implements IAnchor,
ISidedInventory {
    public static final Map pairingMap = Collections.synchronizedMap(new HashMap());
    private static final int SENTINEL_CHECK = 128;
    private static final byte MAX_CHUNKS = 9;
    private static final byte ANCHOR_RADIUS = 1;
    private int xSentinel = -1;
    private int ySentinel = -1;
    private int zSentinel = -1;
    protected ForgeChunkManager.Ticket ticket;
    private int update = MiscTools.getRand().nextInt();
    private Set chunks;
    private long fuel;
    private int fuelCount;
    private boolean hasTicket;
    private boolean refreshTicket;
    private boolean powered;

    public TileAnchorWorld() {
        super(1);
    }

    @Override
    public int k_() {
        return this.getRefuelTime() > 0 ? 1 : 0;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.WORLD_ANCHOR;
    }

    @Override
    public int getBlockTexture(int side) {
        if (!this.hasTicket && side < 2) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        WorldCoordinate sentinel;
        IToolCrowbar crowbar;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.b()).canWhack(player, current, this.l, this.m, this.n) && (sentinel = (WorldCoordinate)pairingMap.get(player)) != null) {
            if (this.k.u.h == sentinel.dimension) {
                this.setSentinel(player, sentinel.x, sentinel.y, sentinel.z);
                crowbar.onWhack(player, current, this.l, this.m, this.n);
            }
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(qx player) {
        if (this.getRefuelTime() > 0) {
            GuiHandler.openGui(EnumGui.WORLD_ANCHOR, player, this.k, this.l, this.m, this.n);
            return true;
        }
        return false;
    }

    public int getMaxSentinelChunks() {
        if (this.ticket == null) {
            return 9;
        }
        return Math.min(this.ticket.getMaxChunkListDepth(), 9);
    }

    public void setSentinel(qx player, int x, int y, int z) {
        any tile = this.k.q(x, y, z);
        if (tile instanceof TileSentinel) {
            int xChunk = this.l >> 4;
            int zChunk = this.n >> 4;
            int xSentinelChunk = tile.l >> 4;
            int zSentinelChunk = tile.n >> 4;
            if (xChunk != xSentinelChunk && zChunk != zSentinelChunk) {
                if (Game.isNotHost(this.k)) {
                    String message = RailcraftLanguage.translate("gui.anchor.pair.fail.alignment");
                    player.b(String.format(message, this.b(), RailcraftLanguage.translate(EnumMachineBeta.SENTINEL.getTag())));
                }
                return;
            }
            int max = this.getMaxSentinelChunks();
            if (Math.abs(xChunk - xSentinelChunk) > max || Math.abs(zChunk - zSentinelChunk) > max) {
                if (Game.isNotHost(this.k)) {
                    String message = RailcraftLanguage.translate("gui.anchor.pair.fail.distance");
                    player.b(String.format(message, this.b(), RailcraftLanguage.translate(EnumMachineBeta.SENTINEL.getTag())));
                }
                return;
            }
            this.xSentinel = tile.l;
            this.ySentinel = tile.m;
            this.zSentinel = tile.n;
            if (Game.isHost(this.k)) {
                this.requestTicket();
                this.sendUpdateToClient();
            } else {
                String message = RailcraftLanguage.translate("gui.anchor.pair.success");
                player.b(String.format(message, this.b()));
            }
        }
    }

    public void clearSentinel() {
        if (!this.hasSentinel()) {
            return;
        }
        this.xSentinel = -1;
        this.ySentinel = -1;
        this.zSentinel = -1;
        this.requestTicket();
        this.sendUpdateToClient();
    }

    public boolean hasSentinel() {
        return this.ySentinel != -1;
    }

    public boolean hasFuel() {
        return this.fuel > 0L;
    }

    @Override
    public ArrayList getBlockDropped(int fortune) {
        ArrayList<ur> items = new ArrayList<ur>();
        ur drop = this.getMachineType().getItem();
        if (this.getRefuelTime() > 0 && this.hasFuel()) {
            bq nbt = new bq("tag");
            nbt.a("fuel", this.fuel);
            drop.d(nbt);
        }
        items.add(drop);
        return items;
    }

    @Override
    public void initFromItem(ur stack) {
        super.initFromItem(stack);
        if (this.getRefuelTime() > 0) {
            this.fuel = ItemCartAnchor.getFuel(stack);
        }
    }

    @Override
    public void g() {
        any tile;
        int hoursPerFeeding;
        super.g();
        if (Game.isNotHost(this.k)) {
            if (this.chunks != null) {
                EffectManager.instance.chunkLoaderEffect(this.k, this, this.chunks);
            }
            return;
        }
        if (RailcraftConfig.deleteAnchors()) {
            this.releaseTicket();
            this.k.e(this.l, this.m, this.n, amq.as.cm);
            return;
        }
        if (this.ticket != null && (this.refreshTicket || this.powered)) {
            this.releaseTicket();
        }
        if ((hoursPerFeeding = this.getRefuelTime()) > 0) {
            this.fuelCount = this.fuelCount >= 9 ? 0 : ++this.fuelCount;
            if (this.chunks == null || this.chunks.size() > this.fuelCount) {
                if (this.ticket != null && this.fuel > 0L) {
                    --this.fuel;
                }
                if (this.fuel <= 0L) {
                    ur stack = this.a(0);
                    if (stack == null || stack.a <= 0) {
                        this.a(0, null);
                        this.releaseTicket();
                    } else if (stack.c == RailcraftConfig.anchorFuelItemID()) {
                        this.a(0, 1);
                        this.fuel = (long)hoursPerFeeding * 72000L;
                    }
                }
            }
        }
        ++this.update;
        if (this.update % 128 == 0 && this.hasSentinel() && !((tile = this.k.q(this.xSentinel, this.ySentinel, this.zSentinel)) instanceof TileSentinel)) {
            this.clearSentinel();
        }
        if (this.ticket == null) {
            this.requestTicket();
        }
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.releaseTicket();
    }

    public void w_() {
        super.w_();
        this.refreshTicket = true;
    }

    protected void releaseTicket() {
        this.refreshTicket = false;
        this.setTicket(null);
    }

    protected void requestTicket() {
        ForgeChunkManager.Ticket chunkTicket;
        if (this.meetsTicketRequirements() && (chunkTicket = this.getTicketFromForge()) != null) {
            this.setTicketData(chunkTicket);
            this.forceChunkLoading(chunkTicket);
        }
    }

    protected int getRefuelTime() {
        return RailcraftConfig.anchorRefuel();
    }

    protected boolean meetsTicketRequirements() {
        return !this.powered && (this.hasFuel() || this.getRefuelTime() <= 0);
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)Railcraft.getMod(), (yc)this.k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
    }

    protected void setTicketData(ForgeChunkManager.Ticket chunkTicket) {
        chunkTicket.getModData().a("xCoord", this.l);
        chunkTicket.getModData().a("yCoord", this.m);
        chunkTicket.getModData().a("zCoord", this.n);
    }

    public void setTicket(ForgeChunkManager.Ticket ticket) {
        boolean changed = false;
        if (this.ticket != ticket) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
            changed = true;
        }
        this.ticket = ticket;
        boolean bl = this.hasTicket = ticket != null;
        if (changed) {
            this.sendUpdateToClient();
        }
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        this.setTicket(ticket);
        this.setupChunks();
        if (this.chunks != null) {
            for (xv chunk : this.chunks) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (xv)chunk);
            }
        }
    }

    public void setupChunks() {
        this.chunks = !this.hasTicket ? null : (this.hasSentinel() ? ChunkManager.getInstance().getChunksBetween(this.l >> 4, this.n >> 4, this.xSentinel >> 4, this.zSentinel >> 4, this.getMaxSentinelChunks()) : ChunkManager.getInstance().getChunksAround(this.l >> 4, this.n >> 4, 1));
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean power) {
        this.powered = power;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        boolean newPower;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = newPower = this.k.A(this.l, this.m, this.n) || this.k.B(this.l, this.m, this.n);
        if (this.powered != newPower) {
            this.powered = newPower;
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.hasTicket);
        data.writeInt(this.xSentinel);
        data.writeInt(this.ySentinel);
        data.writeInt(this.zSentinel);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean tick = data.readBoolean();
        if (this.hasTicket != tick) {
            this.hasTicket = tick;
            this.markBlockForUpdate();
        }
        this.xSentinel = data.readInt();
        this.ySentinel = data.readInt();
        this.zSentinel = data.readInt();
        this.setupChunks();
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("fuel", this.fuel);
        data.a("powered", this.powered);
        data.a("xSentinel", this.xSentinel);
        data.a("ySentinel", this.ySentinel);
        data.a("zSentinel", this.zSentinel);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        if (this.getRefuelTime() > 0) {
            this.fuel = data.f("fuel");
        }
        this.powered = data.n("powered");
        this.xSentinel = data.e("xSentinel");
        this.ySentinel = data.e("ySentinel");
        this.zSentinel = data.e("zSentinel");
    }

    @Override
    public float getResistance(lq exploder) {
        return 60.0f;
    }

    @Override
    public float getHardness() {
        return 20.0f;
    }

    @Override
    public long getAnchorFuel() {
        return this.fuel;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (RailcraftConfig.anchorsCanInteractWithPipes()) {
            return 1;
        }
        return 0;
    }
}

