/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineBase;
import railcraft.common.blocks.machine.alpha.TileAnchorPersonal;
import railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import railcraft.common.blocks.machine.alpha.TileBlastFurnace;
import railcraft.common.blocks.machine.alpha.TileCokeOven;
import railcraft.common.blocks.machine.alpha.TileFeedStation;
import railcraft.common.blocks.machine.alpha.TileRockCrusher;
import railcraft.common.blocks.machine.alpha.TileRollingMachine;
import railcraft.common.blocks.machine.alpha.TileSteamOven;
import railcraft.common.blocks.machine.alpha.TileSteamTurbine;
import railcraft.common.blocks.machine.alpha.TileTankWater;
import railcraft.common.blocks.machine.gamma.TileDispenserCart;
import railcraft.common.blocks.machine.gamma.TileDispenserTrain;
import railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import railcraft.common.blocks.machine.gamma.TileItemUnloaderAdvanced;
import railcraft.common.blocks.machine.gamma.TileLiquidUnloader;
import railcraft.common.carts.ItemCartAnchor;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.modules.ModuleManager;

public enum EnumMachineAlpha implements IEnumMachine
{
    WORLD_ANCHOR(ModuleManager.Module.CHUNK_LOADING, "world.anchor", TileAnchorWorld.class, new int[]{185, 185, 201, 201, 201, 201, 169}),
    TURBINE(ModuleManager.Module.ENERGY, "turbine", TileSteamTurbine.class, new int[]{2, 2, 2, 2, 32, 2, 0, 1, 16, 17, 18, 32, 33, 34}),
    PERSONAL_ANCHOR(ModuleManager.Module.CHUNK_LOADING, "personal.anchor", TileAnchorPersonal.class, new int[]{183, 183, 199, 199, 199, 199, 167}),
    STEAM_OVEN(ModuleManager.Module.FACTORY, "steam.oven", TileSteamOven.class, new int[]{226, 226, 243, 243, 242, 243, 224, 225, 240, 241}),
    LIQUID_UNLOADER(null, "unloader.liquid", TileLiquidUnloader.class, new int[]{26, 28, 27, 27, 27, 27}),
    ITEM_UNLOADER_ADVANCED(null, "unloader.item.advanced", TileItemUnloaderAdvanced.class, new int[]{138, 138, 139, 140, 139, 139}),
    DISPENSER_CART(null, "dispenser.cart", TileDispenserCart.class, new int[]{106, 106, 107, 108, 107, 107}),
    COKE_OVEN(ModuleManager.Module.FACTORY, "coke.oven", TileCokeOven.class, new int[]{170, 170, 170, 170, 171, 170, 171, 172}),
    ROLLING_MACHINE(ModuleManager.Module.FACTORY, "rolling.machine", TileRollingMachine.class, new int[]{186, 188, 187, 187, 187, 187}),
    ENERGY_LOADER(null, "loader.energy", TileEnergyLoader.class, new int[]{202, 202, 203, 204, 203, 203}),
    ENERGY_UNLOADER(null, "unloader.energy", TileEnergyUnloader.class, new int[]{218, 218, 219, 220, 219, 219}),
    FEED_STATION(ModuleManager.Module.AUTOMATION, "feed.station", TileFeedStation.class, new int[]{234, 236, 235, 235, 235, 235}),
    BLAST_FURNACE(ModuleManager.Module.FACTORY, "blast.furnace", TileBlastFurnace.class, new int[]{215, 215, 215, 215, 216, 215, 216, 217}),
    DISPENSER_TRAIN(null, "dispenser.train", TileDispenserTrain.class, new int[]{231, 231, 232, 233, 232, 232}),
    TANK_WATER(ModuleManager.Module.TRANSPORT, "tank.water", TileTankWater.class, new int[]{214, 214, 213, 213, 213, 213}),
    ROCK_CRUSHER(ModuleManager.Module.FACTORY, "rock.crusher", TileRockCrusher.class, new int[]{3, 5, 4, 4, 4, 4});

    private final ModuleManager.Module module;
    private final String tag;
    private final Class tile;
    private final int[] texture;
    private static final List creativeList;
    private static final EnumMachineAlpha[] VALUES;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMachineAlpha(Class module3, int ... tag) {
        void texture;
        void tile;
        this.module = module3;
        this.tile = tile;
        this.tag = tag;
        this.texture = texture;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    @Override
    public int getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    public static EnumMachineAlpha fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "rc.machine.alpha." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return (TileMachineBase)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ur getItem() {
        return this.getItem(1);
    }

    @Override
    public ur getItem(int qty) {
        amq block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ur(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public amq getBlock() {
        return RailcraftBlocks.getBlockMachineAlpha();
    }

    @Override
    public int getBlockId() {
        amq block = this.getBlock();
        if (block != null) {
            return block.cm;
        }
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && this.getBlock() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    public void addItemInfo(ur stack, qx player, List info, boolean adv) {
        switch (this) {
            case WORLD_ANCHOR: {
                if (RailcraftConfig.anchorRefuel() <= 0) break;
                this.addAnchorInfo(stack, info);
                break;
            }
            case PERSONAL_ANCHOR: {
                if (RailcraftConfig.anchorRefuelPersonal() <= 0) break;
                this.addAnchorInfo(stack, info);
                break;
            }
            default: {
                String tipTag = "gui.tip." + this.tag;
                if (!RailcraftLanguage.hasTag(tipTag)) break;
                info.add(RailcraftLanguage.translate(tipTag));
            }
        }
    }

    private void addAnchorInfo(ur stack, List info) {
        long fuel = ItemCartAnchor.getFuel(stack);
        double hours = (double)fuel / 72000.0;
        String format = RailcraftLanguage.translate("gui.anchor.fuel.remaining");
        info.add(String.format(format, hours));
    }

    static {
        creativeList = new ArrayList();
        VALUES = EnumMachineAlpha.values();
        creativeList.add(COKE_OVEN);
        creativeList.add(BLAST_FURNACE);
        creativeList.add(STEAM_OVEN);
        creativeList.add(TANK_WATER);
        creativeList.add(ROLLING_MACHINE);
        creativeList.add(ROCK_CRUSHER);
        creativeList.add(FEED_STATION);
        creativeList.add(WORLD_ANCHOR);
        creativeList.add(PERSONAL_ANCHOR);
        creativeList.add(TURBINE);
    }
}

