/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine;

import buildcraft.api.core.SafeTimeTracker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMachineBase;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.PacketTileRequest;

public abstract class TileMultiBlock
extends TileMachineBase {
    private static final int UNKNOWN_STATE_RECHECK = 256;
    private static final int NETWORK_RECHECK = 64;
    private static final int NEIGHBOR_CHECK = 32;
    protected boolean isMaster;
    private byte patternX;
    private byte patternY;
    private byte patternZ;
    private boolean checkNeighbors = true;
    private boolean tested;
    private boolean requestPacket;
    protected int update = MiscTools.getRand().nextInt();
    private SafeTimeTracker timeTracker = new SafeTimeTracker();
    private MultiBlockState state;
    private TileMultiBlock masterBlock;
    private MultiBlockPattern currentPattern;
    private final List patterns;
    private final TileMultiBlock[] neighbors = new TileMultiBlock[6];

    public TileMultiBlock(List patterns) {
        this.patterns = patterns;
        this.currentPattern = (MultiBlockPattern)patterns.get(0);
        this.tested = FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER;
    }

    protected void onPatternLock(MultiBlockPattern pattern) {
    }

    public final char getPatternMarker() {
        if (this.currentPattern == null || !this.isStructureValid()) {
            return 'O';
        }
        return this.currentPattern.getPatternMarker(this.patternX, this.patternY, this.patternZ);
    }

    public final int getPatternPositionX() {
        return this.patternX;
    }

    public final int getPatternPositionY() {
        return this.patternY;
    }

    public final int getPatternPositionZ() {
        return this.patternZ;
    }

    private void setPatternPosition(byte x, byte y, byte z) {
        this.patternX = x;
        this.patternY = y;
        this.patternZ = z;
    }

    public final void setPattern(MultiBlockPattern pattern) {
        this.currentPattern = pattern;
        this.onPatternLock(pattern);
    }

    public final MultiBlockPattern getPattern() {
        return this.currentPattern;
    }

    public final byte getPatternIndex() {
        return (byte)this.patterns.indexOf(this.currentPattern);
    }

    protected int getMaxRecursionDepth() {
        return 12;
    }

    @Override
    public final boolean canUpdate() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        ++this.update;
        if (Game.isHost(this.k)) {
            if (this.checkNeighbors && this.update % 32 == 0) {
                this.grabNeighbors();
            }
            if (!(this.tested || this.state == MultiBlockState.UNKNOWN && this.update % 256 != 0)) {
                this.testIfMasterBlock();
            }
        } else if (this.requestPacket && this.timeTracker.markTimeIfDelay(this.k, 64L)) {
            PacketTileRequest pkt = new PacketTileRequest(this);
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
            this.requestPacket = false;
        }
    }

    private void testIfMasterBlock() {
        this.state = this.getMasterBlockState();
        this.tested = true;
        if (this.state == MultiBlockState.UNKNOWN) {
            this.tested = false;
        } else if (this.state == MultiBlockState.VALID) {
            this.isMaster = true;
            byte by2 = this.currentPattern.getPatternWidthX();
            byte by3 = this.currentPattern.getPatternWidthZ();
            byte by4 = this.currentPattern.getPatternHeight();
            int xOffset = this.l - this.currentPattern.getMasterOffsetX();
            int yOffset = this.m - this.currentPattern.getMasterOffsetY();
            int zOffset = this.n - this.currentPattern.getMasterOffsetZ();
            for (byte px2 = 0; px2 < by2; px2 = (byte)((byte)(px2 + 1))) {
                for (byte py2 = 0; py2 < by4; py2 = (byte)((byte)(py2 + 1))) {
                    for (byte pz = 0; pz < by3; pz = (byte)((byte)(pz + 1))) {
                        char marker = this.currentPattern.getPatternMarker(px2, py2, pz);
                        if (this.isMapPositionOtherBlock(marker)) continue;
                        int x = px2 + xOffset;
                        int y = py2 + yOffset;
                        int z = pz + zOffset;
                        any tile = this.k.q(x, y, z);
                        if (tile instanceof TileMultiBlock) {
                            TileMultiBlock multiBlock = (TileMultiBlock)tile;
                            multiBlock.masterBlock = this;
                            multiBlock.tested = true;
                            multiBlock.checkNeighbors = true;
                            multiBlock.setPattern(this.currentPattern);
                            multiBlock.setPatternPosition(px2, py2, pz);
                            multiBlock.sendUpdateToClient();
                            continue;
                        }
                        return;
                    }
                }
            }
        } else if (this.isMaster) {
            this.isMaster = false;
            this.onMasterReset();
            this.sendUpdateToClient();
        }
    }

    protected void onMasterReset() {
    }

    protected boolean isMapPositionOtherBlock(char mapPos) {
        switch (mapPos) {
            case 'A': 
            case 'O': {
                return true;
            }
        }
        return false;
    }

    protected boolean isMapPositionValid(int i, int j, int k, char mapPos) {
        int id = this.k.a(i, j, k);
        switch (mapPos) {
            case 'O': {
                if (id != this.getBlockId() || this.k.h(i, j, k) != this.p()) break;
                return false;
            }
            case 'B': 
            case 'W': {
                if (id == this.getBlockId() && this.k.h(i, j, k) == this.p()) break;
                return false;
            }
            case 'A': {
                if (this.k.c(i, j, k)) break;
                return false;
            }
        }
        return true;
    }

    private MultiBlockState getMasterBlockState() {
        for (MultiBlockPattern map : this.patterns) {
            boolean valid = true;
            int xWidth = map.getPatternWidthX();
            int zWidth = map.getPatternWidthZ();
            int height = map.getPatternHeight();
            int xOffset = this.l - map.getMasterOffsetX();
            int yOffset = this.m - map.getMasterOffsetY();
            int zOffset = this.n - map.getMasterOffsetZ();
            for (int x = 0; x < xWidth && valid; ++x) {
                block2: for (int y = 0; y < height && valid; ++y) {
                    for (int z = 0; z < zWidth; ++z) {
                        int xx2 = x + xOffset;
                        int yy2 = y + yOffset;
                        int zz = z + zOffset;
                        if (!this.k.f(xx2, yy2, zz)) {
                            return MultiBlockState.UNKNOWN;
                        }
                        if (this.isMapPositionValid(xx2, yy2, zz, map.getPatternMarker(x, y, z))) continue;
                        valid = false;
                        continue block2;
                    }
                }
            }
            if (!valid) continue;
            aoe entityCheckBounds = map.getEntityCheckBounds(this.l, this.m, this.n);
            if (entityCheckBounds != null && !this.k.a(lq.class, entityCheckBounds).isEmpty()) {
                return MultiBlockState.INVALID;
            }
            this.currentPattern = map;
            return MultiBlockState.VALID;
        }
        return MultiBlockState.INVALID;
    }

    private void grabNeighbors() {
        this.checkNeighbors = false;
        for (int side = 0; side < 6; ++side) {
            this.neighbors[side] = null;
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (!MiscTools.blockExistsOnSide(this.k, this.l, this.m, this.n, dir)) {
                this.checkNeighbors = true;
                continue;
            }
            any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, dir);
            if (tile == null || !this.isStructureTile(tile)) continue;
            this.neighbors[side] = (TileMultiBlock)tile;
        }
    }

    @Override
    public void onBlockAdded() {
        super.onBlockAdded();
        if (Game.isNotHost(this.k)) {
            return;
        }
        this.grabNeighbors();
        this.onBlockChange();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        if (Game.isNotHost(this.k)) {
            return;
        }
        this.onBlockChange();
        this.isMaster = false;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (Game.isNotHost(this.k)) {
            return;
        }
        this.tested = false;
        this.retestMasterBlock();
    }

    public void w_() {
        if (this.k != null && Game.isNotHost(this.k)) {
            return;
        }
        this.tested = false;
        this.retestMasterBlock();
        super.w_();
    }

    private void onBlockChange() {
        for (int side = 0; side < 6; ++side) {
            TileMultiBlock tile = this.neighbors[side];
            if (tile == null) continue;
            tile.grabNeighbors();
            tile.onBlockChange(this.getMaxRecursionDepth());
        }
    }

    private void onBlockChange(int depth) {
        if (--depth < 0) {
            return;
        }
        if (this.tested) {
            this.tested = false;
            for (int side = 0; side < 6; ++side) {
                TileMultiBlock tile = this.neighbors[side];
                if (tile != null && !tile.r()) {
                    TileMultiBlock mBlock = tile.getMasterBlock();
                    if (mBlock == null) {
                        tile.onBlockChange(depth);
                        continue;
                    }
                    mBlock.grabNeighbors();
                    mBlock.onBlockChange(this.getMaxRecursionDepth());
                    continue;
                }
                this.neighbors[side] = null;
            }
        }
    }

    protected boolean isStructureTile(any tile) {
        return tile.getClass() == this.getClass();
    }

    public void d() {
        TileMultiBlock mBlock;
        super.d();
        if (!this.isMaster && (mBlock = this.getMasterBlock()) != null) {
            mBlock.d();
        }
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("master", this.isMaster);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.isMaster = data.n("master");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        boolean hasMaster = this.getMasterBlock() != null;
        data.writeBoolean(hasMaster);
        if (hasMaster) {
            byte patternIndex = this.getPatternIndex();
            data.writeByte(patternIndex);
            data.writeByte(this.patternX);
            data.writeByte(this.patternY);
            data.writeByte(this.patternZ);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.requestPacket = false;
        boolean needsUpdate = false;
        boolean hasMaster = data.readBoolean();
        if (hasMaster) {
            byte patternIndex = data.readByte();
            patternIndex = (byte)Math.max(patternIndex, 0);
            patternIndex = (byte)Math.min(patternIndex, this.patterns.size() - 1);
            MultiBlockPattern pat = (MultiBlockPattern)this.patterns.get(patternIndex);
            byte pX = data.readByte();
            byte pY = data.readByte();
            byte pZ = data.readByte();
            if (this.patternX != pX || this.patternY != pY || this.patternZ != pZ) {
                this.patternX = pX;
                this.patternY = pY;
                this.patternZ = pZ;
                needsUpdate = true;
            }
            this.isMaster = pX == pat.getMasterOffsetX() && pY == pat.getMasterOffsetY() && pZ == pat.getMasterOffsetZ();
            this.setPattern(pat);
            int masterX = pat.getMasterRelativeX(this.l, pX);
            int masterY = pat.getMasterRelativeY(this.m, pY);
            int masterZ = pat.getMasterRelativeZ(this.n, pZ);
            any tile = null;
            if (this.k != null) {
                tile = this.k.q(masterX, masterY, masterZ);
            }
            if (tile != null && this.masterBlock != tile && this.isStructureTile(tile)) {
                needsUpdate = true;
                this.masterBlock = (TileMultiBlock)tile;
            }
            if (this.getMasterBlock() == null) {
                this.requestPacket = true;
            }
        } else if (this.masterBlock != null) {
            needsUpdate = true;
            this.masterBlock = null;
            this.isMaster = false;
        }
        if (needsUpdate) {
            this.markBlockForUpdate();
        }
    }

    public final boolean isMaster() {
        return this.isMaster;
    }

    public final void setMaster(boolean m) {
        this.isMaster = m;
    }

    public final void retestMasterBlock() {
        if (this.masterBlock != null) {
            this.masterBlock.tested = false;
        }
    }

    public final boolean isStructureValid() {
        return this.masterBlock != null && this.masterBlock.tested && this.masterBlock.isMaster && !this.masterBlock.r();
    }

    public final TileMultiBlock getMasterBlock() {
        if (this.masterBlock != null && !this.isStructureValid()) {
            this.masterBlock = null;
            this.sendUpdateToClient();
        }
        return this.masterBlock;
    }

    @Override
    public boolean canCreatureSpawn(me type) {
        return this.isStructureValid() && this.getPatternPositionY() < 2 ? false : super.canCreatureSpawn(type);
    }

    private static enum MultiBlockState {
        VALID,
        INVALID,
        UNKNOWN;

    }
}

