/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.blocks.detector.TileDetector;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileDetectorVillager
extends TileDetector
implements IGuiReturnHandler {
    private int profession;
    private Mode mode = Mode.ANY;

    private boolean cartHasVillager() {
        for (py cart : this.getCarts()) {
            if (!(cart.n instanceof qu)) continue;
            return true;
        }
        return false;
    }

    private boolean cartHasProfesion() {
        for (py cart : this.getCarts()) {
            qu villager;
            if (!(cart.n instanceof qu) || (villager = (qu)cart.n).m() != this.profession) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testForCarts() {
        switch (this.mode) {
            case ANY: {
                return this.cartHasVillager();
            }
            case NONE: {
                return !this.cartHasVillager();
            }
            case EQUALS: {
                return this.cartHasProfesion();
            }
            case NOT: {
                return !this.cartHasProfesion();
            }
        }
        return false;
    }

    @Override
    public boolean blockActivated(qx player) {
        GuiHandler.openGui(EnumGui.DETECTOR_VILLAGER, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setProfession(int profession) {
        this.profession = profession;
    }

    public int getProfession() {
        return this.profession;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("profession", this.profession);
        data.a("mode", (byte)this.mode.ordinal());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.profession = data.e("profession");
        this.mode = Mode.values()[data.c("mode")];
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.profession);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.profession = data.readInt();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeInt(this.profession);
        data.writeByte(this.mode.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.profession = data.readInt();
        this.mode = Mode.values()[data.readByte()];
    }

    public static enum Mode {
        ANY,
        NONE,
        NOT,
        EQUALS;

    }
}

